// #include "jptr.h"


template <class tType>
   tType* clJPTR<tType>::ptr() const
   {
      ldebug(cout<<"MEMBER type*"<<endl, 3 );

      assert( _pKey && "Key should always have data!" );
      return (_pKey );
   }

template < class tType >
   void clJPTR< tType >::operator=( tType* pMem )
   {
      ldebug(cout<<"MEMBER operator=pMemory"<<endl,3);

      // check if new returned null.  I really don't know
      // if it does or throughs an exception, but just
      // in case.
      if (!pMem)
      {
	 OutOfMemory();
	 return;
      }

      // If we where pointing to something else,
      // stop point to it, and start pointing to pMEm.
      if (_pKey)
	 remove();
      add( pMem );
   }

template < class tType >
   void clJPTR< tType >::operator=( const clJPTR& oOther )
   {
      ldebug(cout<<"MEMBER operator=Java Pointer"<<endl,3);

      // Re-use other code.
      *this = oOther._pKey;
   }

template < class tType >
   tType* clJPTR< tType >::operator->() const 
   {
      ldebug(cout<<"MEMBER operator ->"<<endl, 3 );

      assert( _pKey && "Key should always have data!" );
      return (_pKey );
   }

template < class tType >
   tType* clJPTR< tType >::clone() const 
   {
      ldebug( cout<<"MEMBER clone"<<endl,3 );
      assert( _pKey && "This shouldn't be null!" );

      // DANGER: This assumes that class we point to has
      // copy constructor!
      return new tType(*_pKey);
   }

template < class tType >
   void clJPTR< tType >::add( tType* pMem )
   {
      ldebug(cout<<"MEMBER add"<<endl,4);

      // Add key
      _pKey = pMem;

      // Add 1 to our count
      _oMap[ pMem ] ++;

      ldebug(print(2),2);
   }

template < class tType >
   void clJPTR< tType >::remove()
   {
      ldebug(cout<<"MEMBER remove"<<endl,4);

      // Decrement our reference count
      _oMap[ _pKey ] --;

      // Insanity Check
      assert( (_oMap[_pKey] >= 0) && "Map value is negative!" );

      // If 0 then we have just deleted our last pointer
      if ( _oMap[_pKey] == 0 )
      {
	 ldebug( cout<<"DELETEING MEMORY: ",2 );
	 assert( _pKey && "Major bug, this should never be NULL" );
         
         // Remove Memory 
	 delete _pKey;
         
         // Remove Key Entry
         _oMap.erase( _pKey );
      }

      // undefine key
      _pKey = NULL;

      // List table of entries
      ldebug( print(2), 2 );
   }


template< class tType >
   void clJPTR< tType >::print(int level)
   {
      assert( (level > -1) && "Expecting a non-negative level!" );

      clMap::const_iterator	iWalk;
      char			cBuff[30] = {  0  };
      char			cTabs[20] = {  0  };

      // Fill fillers
      memset( cBuff, '-', sizeof( cBuff ) -1 );
      memset( cTabs, '\t', min( level, (int) sizeof( cTabs ) - 1) );

      // add a new line
      cout << endl;

      // Title of table
      cout << cTabs << "Ptr         ->   Reference Count" << endl;
      cout << cTabs << cBuff << endl;

      // Elements of Table
      for( iWalk = _oMap.begin(); iWalk != _oMap.end(); iWalk ++ )
      {
	 cout << cTabs << (*iWalk).first << "  ->   " << (*iWalk).second << endl;
      }

      // Trailer of table
      cout << cTabs << cBuff << endl;
   }



/*
   The reason this is private is so the you the programmer are not
   tempted to write something like
   clJPTR< xcl > oNew;

   because this pointer will not have an object to after it's 
   constructor and a little too dangerous.   
*/

template < class tType >
   clJPTR< tType >::clJPTR()
   {
      ldebug(cout<<"DEFAULT Constructor"<<endl,4);
      _pKey = NULL;
   };

template < class tType >
   clJPTR<tType>::clJPTR(  tType* pMem )
   {
      ldebug(cout<<"MEM Constructor"<<endl,4);
      _pKey = NULL;
      *this=pMem;
   }

template < class tType >
   clJPTR<tType>::clJPTR(const clJPTR<tType>& oThat)
   {
      ldebug(cout<<"COPY Constructor"<<endl,4);
      _pKey = NULL;
      *this=oThat;
   }

template <class tType >
   clJPTR<tType>::~clJPTR()
   {
      ldebug(cout<<"Destructor"<<endl,4);
      if (_pKey)
	 remove();
   }

/* override this method,
   it is for the instance when new returns
   NULL
*/

template <class tType>
   void clJPTR<tType>::OutOfMemory()
   {
      ldebug(cout << "ERROR: Out of Memory" << endl, 1 );
      assert( 0 && "Out of Memory!" );
   }


// Wierd but true, global variable declaration for this
// class.
//
template <class tType>
   clJPTR<tType>::clMap clJPTR<tType>::_oMap;

