/*
 * Decompiled with CFR 0.152.
 */
package swingwtx.swing.table;

import java.io.Serializable;
import java.util.Vector;
import swingwtx.swing.event.TableModelEvent;
import swingwtx.swing.event.TableModelListener;
import swingwtx.swing.table.AbstractTableModel;

public class DefaultTableModel
extends AbstractTableModel
implements Serializable {
    protected Vector dataVector = new Vector();
    protected Vector columnIdentifiers = new Vector();

    public DefaultTableModel() {
        this(0, 0);
    }

    public DefaultTableModel(Vector columnNames, int rowCount) {
        this.setDataVector(new Vector(rowCount), columnNames);
    }

    public DefaultTableModel(Object[] columnNames, int rowCount) {
        this(DefaultTableModel.convertToVector(columnNames), rowCount);
    }

    public DefaultTableModel(int rowCount, int columnCount) {
        this(new Vector(columnCount), rowCount);
    }

    public DefaultTableModel(Vector data, Vector columnNames) {
        this.setDataVector(data, columnNames);
    }

    public DefaultTableModel(Object[][] data, Object[] columnNames) {
        this.setDataVector(data, columnNames);
    }

    public Vector getDataVector() {
        return this.dataVector;
    }

    public void setDataVector(Vector dataVector, Vector columnIdentifiers) {
        if (dataVector == null) {
            dataVector = new Vector();
        }
        this.dataVector = dataVector;
        this.columnIdentifiers = columnIdentifiers;
        this.updateRowData(0, this.getRowCount());
        this.fireTableStructureChanged();
    }

    public void setDataVector(Object[][] dataVector, Object[] columnIdentifiers) {
        this.setDataVector(DefaultTableModel.convertToVector(dataVector), DefaultTableModel.convertToVector(columnIdentifiers));
    }

    public void newDataAvailable(TableModelEvent event) {
        this.fireTableChanged(event);
    }

    public void newRowsAdded(TableModelEvent e) {
        this.updateRowData(e.getFirstRow(), e.getLastRow() + 1);
        this.fireTableChanged(e);
    }

    public void rowsRemoved(TableModelEvent event) {
        this.fireTableChanged(event);
    }

    public void setNumRows(int rowCount) {
        int old = this.getRowCount();
        if (old == rowCount) {
            return;
        }
        this.dataVector.setSize(rowCount);
        if (rowCount <= old) {
            this.fireTableRowsDeleted(rowCount, old - 1);
        } else {
            this.updateRowData(old, rowCount);
            this.fireTableRowsInserted(old, rowCount - 1);
        }
    }

    public void setRowCount(int rowCount) {
        this.setNumRows(rowCount);
    }

    public void addRow(Vector rowData) {
        this.insertRow(this.getRowCount(), rowData);
    }

    public void addRow(Object[] rowData) {
        this.addRow(DefaultTableModel.convertToVector(rowData));
    }

    public void addColumn(Object columnName) {
        this.addColumn(columnName, (Vector)null);
    }

    public void addColumn(Object columnName, Vector columnData) {
        this.columnIdentifiers.addElement(columnName);
        if (columnData != null) {
            int columnSize = columnData.size();
            if (columnSize > this.getRowCount()) {
                this.dataVector.setSize(columnSize);
            }
            this.updateRowData(0, this.getRowCount());
            int newColumn = this.getColumnCount() - 1;
            for (int i = 0; i < columnSize; ++i) {
                Vector row = (Vector)this.dataVector.elementAt(i);
                row.setElementAt(columnData.elementAt(i), newColumn);
            }
        } else {
            this.updateRowData(0, this.getRowCount());
        }
        this.fireTableStructureChanged();
    }

    public void addColumn(Object columnName, Object[] columnData) {
        this.addColumn(columnName, DefaultTableModel.convertToVector(columnData));
    }

    public void insertRow(int row, Vector rowData) {
        this.dataVector.insertElementAt(rowData, row);
        this.updateRowData(row, row + 1);
        this.fireTableRowsInserted(row, row);
    }

    public void insertRow(int row, Object[] rowData) {
        this.insertRow(row, DefaultTableModel.convertToVector(rowData));
    }

    public void removeRow(int row) {
        this.dataVector.removeElementAt(row);
        this.fireTableRowsDeleted(row, row);
    }

    public void setColumnIdentifiers(Vector columnIdentifiers) {
        this.setDataVector(this.dataVector, columnIdentifiers);
    }

    public void setColumnIdentifiers(Object[] newIdentifiers) {
        this.setColumnIdentifiers(DefaultTableModel.convertToVector(newIdentifiers));
    }

    public void setColumnCount(int columnCount) {
        this.columnIdentifiers.setSize(columnCount);
        this.updateRowData(0, this.getRowCount());
        this.fireTableStructureChanged();
    }

    public int getRowCount() {
        return this.dataVector.size();
    }

    public int getColumnCount() {
        return this.columnIdentifiers.size();
    }

    public String getColumnName(int column) {
        return this.columnIdentifiers.elementAt(column).toString();
    }

    public boolean isCellEditable(int row, int column) {
        return true;
    }

    public Object getValueAt(int row, int column) {
        Vector rowVector = (Vector)this.dataVector.elementAt(row);
        return rowVector.elementAt(column);
    }

    public void setValueAt(Object aValue, int row, int column) {
        Vector rowVector = (Vector)this.dataVector.elementAt(row);
        rowVector.setElementAt(aValue, column);
        this.fireTableCellUpdated(row, column);
    }

    protected static Vector convertToVector(Object[] anArray) {
        Vector<Object> v = new Vector<Object>(anArray.length);
        for (int i = 0; i < anArray.length; ++i) {
            v.addElement(anArray[i]);
        }
        return v;
    }

    protected static Vector convertToVector(Object[][] anArray) {
        Vector<Vector> v = new Vector<Vector>(anArray.length);
        for (int i = 0; i < anArray.length; ++i) {
            v.addElement(DefaultTableModel.convertToVector(anArray[i]));
        }
        return v;
    }

    private void updateRowData(int from, int to) {
        this.dataVector.setSize(this.getRowCount());
        for (int i = from; i < to; ++i) {
            if (this.dataVector.elementAt(i) == null) {
                this.dataVector.setElementAt(new Vector(), i);
            }
            ((Vector)this.dataVector.elementAt(i)).setSize(this.getColumnCount());
        }
    }

    public void addTableModelListener(TableModelListener l) {
        this.listenerList.add(l);
    }

    public void removeTableModelListener(TableModelListener l) {
        this.listenerList.remove(l);
    }
}

