/* Swfdec
 * Copyright (C) 2007 Pekka Lampila <pekka.lampila@iki.fi>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 2.1 of the License, or (at your option) any later version.
 * 
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * Lesser General Public License for more details.
 * 
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, 
 * Boston, MA  02110-1301  USA
 */

#ifdef HAVE_CONFIG_H
#include "config.h"
#endif

#include "swfdec_as_internal.h"
#include "swfdec_debug.h"

SWFDEC_AS_NATIVE (1109, 1, swfdec_convolution_filter_get_matrixX)
void
swfdec_convolution_filter_get_matrixX (SwfdecAsContext *cx,
    SwfdecAsObject *object, guint argc, SwfdecAsValue *argv,
    SwfdecAsValue *ret)
{
  SWFDEC_STUB ("ConvolutionFilter.matrixX (get)");
}

SWFDEC_AS_NATIVE (1109, 2, swfdec_convolution_filter_set_matrixX)
void
swfdec_convolution_filter_set_matrixX (SwfdecAsContext *cx,
    SwfdecAsObject *object, guint argc, SwfdecAsValue *argv,
    SwfdecAsValue *ret)
{
  SWFDEC_STUB ("ConvolutionFilter.matrixX (set)");
}

SWFDEC_AS_NATIVE (1109, 3, swfdec_convolution_filter_get_matrixY)
void
swfdec_convolution_filter_get_matrixY (SwfdecAsContext *cx,
    SwfdecAsObject *object, guint argc, SwfdecAsValue *argv,
    SwfdecAsValue *ret)
{
  SWFDEC_STUB ("ConvolutionFilter.matrixY (get)");
}

SWFDEC_AS_NATIVE (1109, 4, swfdec_convolution_filter_set_matrixY)
void
swfdec_convolution_filter_set_matrixY (SwfdecAsContext *cx,
    SwfdecAsObject *object, guint argc, SwfdecAsValue *argv,
    SwfdecAsValue *ret)
{
  SWFDEC_STUB ("ConvolutionFilter.matrixY (set)");
}

SWFDEC_AS_NATIVE (1109, 5, swfdec_convolution_filter_get_matrix)
void
swfdec_convolution_filter_get_matrix (SwfdecAsContext *cx,
    SwfdecAsObject *object, guint argc, SwfdecAsValue *argv,
    SwfdecAsValue *ret)
{
  SWFDEC_STUB ("ConvolutionFilter.matrix (get)");
}

SWFDEC_AS_NATIVE (1109, 6, swfdec_convolution_filter_set_matrix)
void
swfdec_convolution_filter_set_matrix (SwfdecAsContext *cx,
    SwfdecAsObject *object, guint argc, SwfdecAsValue *argv,
    SwfdecAsValue *ret)
{
  SWFDEC_STUB ("ConvolutionFilter.matrix (set)");
}

SWFDEC_AS_NATIVE (1109, 7, swfdec_convolution_filter_get_divisor)
void
swfdec_convolution_filter_get_divisor (SwfdecAsContext *cx,
    SwfdecAsObject *object, guint argc, SwfdecAsValue *argv,
    SwfdecAsValue *ret)
{
  SWFDEC_STUB ("ConvolutionFilter.divisor (get)");
}

SWFDEC_AS_NATIVE (1109, 8, swfdec_convolution_filter_set_divisor)
void
swfdec_convolution_filter_set_divisor (SwfdecAsContext *cx,
    SwfdecAsObject *object, guint argc, SwfdecAsValue *argv,
    SwfdecAsValue *ret)
{
  SWFDEC_STUB ("ConvolutionFilter.divisor (set)");
}

SWFDEC_AS_NATIVE (1109, 9, swfdec_convolution_filter_get_bias)
void
swfdec_convolution_filter_get_bias (SwfdecAsContext *cx,
    SwfdecAsObject *object, guint argc, SwfdecAsValue *argv,
    SwfdecAsValue *ret)
{
  SWFDEC_STUB ("ConvolutionFilter.bias (get)");
}

SWFDEC_AS_NATIVE (1109, 10, swfdec_convolution_filter_set_bias)
void
swfdec_convolution_filter_set_bias (SwfdecAsContext *cx,
    SwfdecAsObject *object, guint argc, SwfdecAsValue *argv,
    SwfdecAsValue *ret)
{
  SWFDEC_STUB ("ConvolutionFilter.bias (set)");
}

SWFDEC_AS_NATIVE (1109, 11, swfdec_convolution_filter_get_preserveAlpha)
void
swfdec_convolution_filter_get_preserveAlpha (SwfdecAsContext *cx,
    SwfdecAsObject *object, guint argc, SwfdecAsValue *argv,
    SwfdecAsValue *ret)
{
  SWFDEC_STUB ("ConvolutionFilter.preserveAlpha (get)");
}

SWFDEC_AS_NATIVE (1109, 12, swfdec_convolution_filter_set_preserveAlpha)
void
swfdec_convolution_filter_set_preserveAlpha (SwfdecAsContext *cx,
    SwfdecAsObject *object, guint argc, SwfdecAsValue *argv,
    SwfdecAsValue *ret)
{
  SWFDEC_STUB ("ConvolutionFilter.preserveAlpha (set)");
}

SWFDEC_AS_NATIVE (1109, 13, swfdec_convolution_filter_get_clamp)
void
swfdec_convolution_filter_get_clamp (SwfdecAsContext *cx,
    SwfdecAsObject *object, guint argc, SwfdecAsValue *argv,
    SwfdecAsValue *ret)
{
  SWFDEC_STUB ("ConvolutionFilter.clamp (get)");
}

SWFDEC_AS_NATIVE (1109, 14, swfdec_convolution_filter_set_clamp)
void
swfdec_convolution_filter_set_clamp (SwfdecAsContext *cx,
    SwfdecAsObject *object, guint argc, SwfdecAsValue *argv,
    SwfdecAsValue *ret)
{
  SWFDEC_STUB ("ConvolutionFilter.clamp (set)");
}

SWFDEC_AS_NATIVE (1109, 15, swfdec_convolution_filter_get_color)
void
swfdec_convolution_filter_get_color (SwfdecAsContext *cx,
    SwfdecAsObject *object, guint argc, SwfdecAsValue *argv,
    SwfdecAsValue *ret)
{
  SWFDEC_STUB ("ConvolutionFilter.color (get)");
}

SWFDEC_AS_NATIVE (1109, 16, swfdec_convolution_filter_set_color)
void
swfdec_convolution_filter_set_color (SwfdecAsContext *cx,
    SwfdecAsObject *object, guint argc, SwfdecAsValue *argv,
    SwfdecAsValue *ret)
{
  SWFDEC_STUB ("ConvolutionFilter.color (set)");
}

SWFDEC_AS_NATIVE (1109, 17, swfdec_convolution_filter_get_alpha)
void
swfdec_convolution_filter_get_alpha (SwfdecAsContext *cx,
    SwfdecAsObject *object, guint argc, SwfdecAsValue *argv,
    SwfdecAsValue *ret)
{
  SWFDEC_STUB ("ConvolutionFilter.alpha (get)");
}

SWFDEC_AS_NATIVE (1109, 18, swfdec_convolution_filter_set_alpha)
void
swfdec_convolution_filter_set_alpha (SwfdecAsContext *cx,
    SwfdecAsObject *object, guint argc, SwfdecAsValue *argv,
    SwfdecAsValue *ret)
{
  SWFDEC_STUB ("ConvolutionFilter.alpha (set)");
}

// constructor
SWFDEC_AS_NATIVE (1109, 0, swfdec_convolution_filter_contruct)
void
swfdec_convolution_filter_contruct (SwfdecAsContext *cx,
    SwfdecAsObject *object, guint argc, SwfdecAsValue *argv,
    SwfdecAsValue *ret)
{
  SWFDEC_STUB ("ConvolutionFilter");
}
