'''
 ====================================================================
 Copyright (c) 2003-2006 Barry A Scott.  All rights reserved.

 This software is licensed as described in the file LICENSE.txt,
 which you should have received as part of this distribution.

 ====================================================================

    wb_list_panel.py

'''
import wb_ids
import wb_list_panel_common

import wx

class WbListPanel(wb_list_panel_common.WbListPanelCommon):
    def __init__( self, app, frame, parent ):
        wb_list_panel_common.WbListPanelCommon.__init__( self, app, frame, parent )

    def __repr__( self ):
        return '<WbListPanel %r>' % self.list_handler

    def getAcceleratorTableInit( self ):
        if wx.Platform == '__WXMAC__':
            acc_init =[
                (wx.ACCEL_ALT, ord('C'), wb_ids.id_SP_EditCopy),
                (wx.ACCEL_ALT, ord('X'), wb_ids.id_SP_EditCut),
                (wx.ACCEL_ALT, ord('V'), wb_ids.id_SP_EditPaste),

                (wx.ACCEL_ALT, ord('A'), wb_ids.id_SP_Add),
                (wx.ACCEL_ALT, ord('D'), wb_ids.id_SP_DiffWorkBase),
                (wx.ACCEL_ALT, ord('E'), wb_ids.id_File_Edit),
                (wx.ACCEL_ALT, ord('L'), wb_ids.id_SP_History),
                (wx.ACCEL_ALT, ord('I'), wb_ids.id_SP_Info),
                (wx.ACCEL_ALT, ord('P'), wb_ids.id_SP_Properties),
                (wx.ACCEL_ALT, ord('R'), wb_ids.id_SP_Revert),
                (wx.ACCEL_ALT, ord('U'), wb_ids.id_SP_Update),
                (wx.ACCEL_NORMAL, wx.WXK_DELETE, wb_ids.id_SP_Delete),
                (wx.ACCEL_ALT, wx.WXK_BACK, wb_ids.id_SP_Delete),
                (wx.ACCEL_NORMAL, wx.WXK_RETURN, wb_ids.id_Return_Hotkey),
                (wx.ACCEL_ALT, ord('O'), wb_ids.id_Shell_Open),
                ]
        elif wx.Platform == '__WXMSW__':
            acc_init =[
                (wx.ACCEL_CTRL, ord('C'), wb_ids.id_SP_EditCopy),
                (wx.ACCEL_CTRL, ord('X'), wb_ids.id_SP_EditCut),
                (wx.ACCEL_CTRL, ord('V'), wb_ids.id_SP_EditPaste),

                (wx.ACCEL_CTRL, ord('A'), wb_ids.id_SP_Add),
                (wx.ACCEL_CTRL, ord('D'), wb_ids.id_SP_DiffWorkBase),
                (wx.ACCEL_CTRL, ord('E'), wb_ids.id_File_Edit),
                (wx.ACCEL_CTRL, ord('L'), wb_ids.id_SP_History),
                (wx.ACCEL_CTRL, ord('I'), wb_ids.id_SP_Info),
                (wx.ACCEL_CTRL, ord('P'), wb_ids.id_SP_Properties),
                (wx.ACCEL_CTRL, ord('R'), wb_ids.id_SP_Revert),
                (wx.ACCEL_CTRL, ord('U'), wb_ids.id_SP_Update),
                (wx.ACCEL_NORMAL, wx.WXK_DELETE, wb_ids.id_SP_Delete),
                (wx.ACCEL_NORMAL, wx.WXK_RETURN, wb_ids.id_Return_Hotkey),
                (wx.ACCEL_CTRL, ord('O'), wb_ids.id_Shell_Open),
                ]
        else:
            # Unix
            acc_init =[
                (wx.ACCEL_CTRL, ord('C'), wb_ids.id_SP_EditCopy),
                (wx.ACCEL_CTRL, ord('X'), wb_ids.id_SP_EditCut),
                (wx.ACCEL_CTRL, ord('V'), wb_ids.id_SP_EditPaste),

                (wx.ACCEL_CTRL, ord('A'), wb_ids.id_SP_Add),
                (wx.ACCEL_CTRL, ord('D'), wb_ids.id_SP_DiffWorkBase),
                (wx.ACCEL_CTRL, ord('E'), wb_ids.id_File_Edit),
                (wx.ACCEL_CTRL, ord('L'), wb_ids.id_SP_History),
                (wx.ACCEL_CTRL, ord('I'), wb_ids.id_SP_Info),
                (wx.ACCEL_CTRL, ord('P'), wb_ids.id_SP_Properties),
                (wx.ACCEL_CTRL, ord('R'), wb_ids.id_SP_Revert),
                (wx.ACCEL_CTRL, ord('U'), wb_ids.id_SP_Update),
                (wx.ACCEL_NORMAL, wx.WXK_DELETE, wb_ids.id_SP_Delete),
                (wx.ACCEL_NORMAL, wx.WXK_RETURN, wb_ids.id_Return_Hotkey),
                ]
        return acc_init
