# Copyright (c) 2014,
# Mathias Kuhring, KuhringM@rki.de, Robert Koch Institute, Germany, 
# All rights reserved. For details, please note the license.txt.


# BaseConfirmation for the ends
endConfirmation <- function(coverage, corecoverage, endSize){
  
  num <- length(coverage)
  leftconf <- vector(mode="list", length=num)
  rightconf <- vector(mode="list", length=num)
  for (i in 1:num){
    leftc <- getEnd(coverage[[i]], endSize[i], "left")
    leftcc <- getEnd(corecoverage[[i]], endSize[i], "left")
    leftconf[[i]] <- apply(cbind(leftcc,leftc), 1, mybinom)
    
    rightc <- getEnd(coverage[[i]], endSize[i], "right")
    rightcc <- getEnd(corecoverage[[i]], endSize[i], "right")
    rightconf[[i]] <- apply(cbind(rightcc,rightc), 1, mybinom)
  }
    
  leftright <- data.frame(sapply(leftconf, mean), sapply(leftconf, sd),
                          sapply(leftconf, median), sapply(leftconf, mad),
                          sapply(leftconf, min), sapply(leftconf, max),
                          sapply(rightconf, mean), sapply(rightconf, sd),
                          sapply(rightconf, median), sapply(rightconf, mad),
                          sapply(rightconf, min), sapply(rightconf, max))
  
  ordered <- t(apply(leftright, 1, orderMinMax))
  colnames(ordered) <- c('BaseConfirmationMinEndMean', 'BaseConfirmationMinEndSD',
                         'BaseConfirmationMinEndMedian', 'BaseConfirmationMinEndMad',
                         'BaseConfirmationMinEndMin', 'BaseConfirmationMinEndMax',
                         'BaseConfirmationMaxEndMean', 'BaseConfirmationMaxEndSD',
                         'BaseConfirmationMaxEndMedian', 'BaseConfirmationMaxEndMad',
                         'BaseConfirmationMaxEndMin', 'BaseConfirmationMaxEndMax')
  return(ordered)
}

orderMinMax <- function(line){
  if (line[1] <= line[7]) return(line)
  else return(cbind(line[7:12],line[1:6]))
}

getEnd <- function(sequence, endsize, side){
  if (side=='right') sequence <- rev(sequence)
  sequence[1:min(endsize,length(sequence))]
}