classdef RETURN_VALUE_FUNC
    %RETURN_VALUE_FUNC A class to store the functions to read the TraCI
    %results for each SUMO object.
    
    %   Copyright 2013 Universidad Nacional de Colombia,
    %   Politecnico Jaime Isaza Cadavid.
    %   Authors: Andres Acosta, Jairo Espinosa, Jorge Espinosa.
	%   $Id: RETURN_VALUE_FUNC.m 13 2014-03-13 21:41:33Z afacostag $

    properties (Constant)
		areal = containers.Map({...
			traci.constants.ID_LIST...
			traci.constants.ID_COUNT,...
			traci.constants.JAM_LENGTH_METERS,...
			traci.constants.JAM_LENGTH_VEHICLE,...
			traci.constants.LAST_STEP_MEAN_SPEED,...
			traci.constants.LAST_STEP_OCCUPANCY},...
			{'readStringList','readInt','readDouble','readInt','readDouble','readDouble'});
        edge = containers.Map({...
            traci.constants.ID_LIST,...
            traci.constants.ID_COUNT,...
            traci.constants.VAR_EDGE_TRAVELTIME,...
            traci.constants.VAR_EDGE_EFFORT,...
            traci.constants.VAR_CO2EMISSION,...
            traci.constants.VAR_COEMISSION,...
            traci.constants.VAR_HCEMISSION,...
            traci.constants.VAR_PMXEMISSION,...
            traci.constants.VAR_NOXEMISSION,...
            traci.constants.VAR_FUELCONSUMPTION,...
            traci.constants.VAR_NOISEEMISSION,...
            traci.constants.LAST_STEP_MEAN_SPEED,...
            traci.constants.LAST_STEP_OCCUPANCY,...
            traci.constants.LAST_STEP_LENGTH,...
            traci.constants.VAR_CURRENT_TRAVELTIME,...
            traci.constants.LAST_STEP_VEHICLE_NUMBER,...
            traci.constants.LAST_STEP_VEHICLE_HALTING_NUMBER,...
            traci.constants.LAST_STEP_VEHICLE_ID_LIST},...
            {'readStringList','readInt','readDouble','readDouble','readDouble',...
            'readDouble','readDouble','readDouble','readDouble','readDouble',...
            'readDouble','readDouble','readDouble','readDouble','readDouble',...
            'readInt','readInt','readStringList'});
        gui = containers.Map({...
            traci.constants.ID_LIST,...
            traci.constants.VAR_VIEW_ZOOM,...
            traci.constants.VAR_VIEW_OFFSET,...
            traci.constants.VAR_VIEW_SCHEMA,...
            traci.constants.VAR_VIEW_BOUNDARY},...
            {'readStringList','readDouble','@(result) typecast([fliplr(result.read(8)) fliplr(result.read(8))],''double'')',...
            'readString','@(result) typecast([fliplr(result.read(8)) fliplr(result.read(8)) fliplr(result.read(8)) fliplr(result.read(8))],''double'')'});
        inductionloop = containers.Map({...
            traci.constants.ID_LIST,...
            traci.constants.VAR_POSITION,...
            traci.constants.VAR_LANE_ID,...
            traci.constants.LAST_STEP_VEHICLE_NUMBER,...
            traci.constants.LAST_STEP_MEAN_SPEED,...
            traci.constants.LAST_STEP_VEHICLE_ID_LIST,...
            traci.constants.LAST_STEP_OCCUPANCY,...
            traci.constants.LAST_STEP_LENGTH,...
            traci.constants.LAST_STEP_TIME_SINCE_DETECTION,...
            traci.constants.LAST_STEP_VEHICLE_DATA},...
            {'readStringList','readDouble','readString',...
            'readInt','readDouble','readStringList',...
            'readDouble','readDouble','readDouble',...
            'traci.inductionloop.readVehicleData'});
        junction = containers.Map({...
            traci.constants.ID_LIST,...
            traci.constants.VAR_POSITION},...
            {'readStringList','@(result) typecast([fliplr(result.read(8)) fliplr(result.read(8))],''double'')'});
        lane = containers.Map({...
            traci.constants.ID_LIST,...
            traci.constants.VAR_LENGTH,...
            traci.constants.VAR_MAXSPEED,...
            traci.constants.VAR_WIDTH,...
            traci.constants.LANE_ALLOWED,...
            traci.constants.LANE_DISALLOWED,...
            traci.constants.LANE_LINK_NUMBER,...
            traci.constants.LANE_LINKS,...
            traci.constants.VAR_SHAPE,...
            traci.constants.LANE_EDGE_ID,...
            traci.constants.VAR_CO2EMISSION,...
            traci.constants.VAR_COEMISSION,...
            traci.constants.VAR_HCEMISSION,...
            traci.constants.VAR_PMXEMISSION,...
            traci.constants.VAR_NOXEMISSION,...
            traci.constants.VAR_FUELCONSUMPTION,...
            traci.constants.VAR_NOISEEMISSION,...
            traci.constants.LAST_STEP_MEAN_SPEED,...
            traci.constants.LAST_STEP_OCCUPANCY,...
            traci.constants.LAST_STEP_LENGTH,...
            traci.constants.VAR_CURRENT_TRAVELTIME,...
            traci.constants.LAST_STEP_VEHICLE_NUMBER,...
            traci.constants.LAST_STEP_VEHICLE_HALTING_NUMBER,...
            traci.constants.LAST_STEP_VEHICLE_ID_LIST},...
            {'readStringList','readDouble','readDouble','readDouble','readStringList',...
            'readStringList','@(result) result.read(1)','traci.lane.readLinks','readShape','readString',...
            'readDouble','readDouble','readDouble','readDouble','readDouble',...
            'readDouble','readDouble','readDouble','readDouble','readDouble',...
            'readDouble','readInt','readInt','readStringList'});
        multientryexit = containers.Map({...
            traci.constants.ID_LIST,...
            traci.constants.LAST_STEP_VEHICLE_NUMBER,...
            traci.constants.LAST_STEP_MEAN_SPEED,...
            traci.constants.LAST_STEP_VEHICLE_ID_LIST,...
            traci.constants.LAST_STEP_VEHICLE_HALTING_NUMBER},...
            {'readStringList','readInt','readDouble','readStringList','readInt'});
        poi = containers.Map({...
            traci.constants.ID_LIST,...
            traci.constants.VAR_TYPE,...
            traci.constants.VAR_POSITION,...
            traci.constants.VAR_COLOR},...
            {'readStringList','readString','@(result) typecast([fliplr(result.read(8)) fliplr(result.read(8))],''double'')',...
            '@(result) result.read(4)'});
        polygon = containers.Map({...
            traci.constants.ID_LIST,...
            traci.constants.VAR_TYPE,...
            traci.constants.VAR_SHAPE,...
            traci.constants.VAR_COLOR},...
            {'readStringList','readString','readShape','@(result) result.read(4)'});
        route = containers.Map({...
            traci.constants.ID_LIST,...
            traci.constants.VAR_EDGES},...
            {'readStringList','readStringList'});
        simulation = containers.Map({...
            traci.constants.VAR_TIME_STEP,...
            traci.constants.VAR_LOADED_VEHICLES_NUMBER,...
            traci.constants.VAR_LOADED_VEHICLES_IDS,...
            traci.constants.VAR_DEPARTED_VEHICLES_NUMBER,...
            traci.constants.VAR_DEPARTED_VEHICLES_IDS,...
            traci.constants.VAR_ARRIVED_VEHICLES_NUMBER,...
            traci.constants.VAR_ARRIVED_VEHICLES_IDS,...
            traci.constants.VAR_MIN_EXPECTED_VEHICLES,...
            traci.constants.VAR_TELEPORT_STARTING_VEHICLES_NUMBER,...
            traci.constants.VAR_TELEPORT_STARTING_VEHICLES_IDS,...
            traci.constants.VAR_TELEPORT_ENDING_VEHICLES_NUMBER,...
            traci.constants.VAR_TELEPORT_ENDING_VEHICLES_IDS,...
            traci.constants.VAR_DELTA_T,...
            traci.constants.VAR_NET_BOUNDING_BOX},...
            {'readInt','readInt','readStringList','readInt',...
            'readStringList','readInt','readStringList','readInt',...
            'readInt','readStringList','readInt','readStringList',...
            'readInt','@(result) typecast([fliplr(result.read(8)) fliplr(result.read(8)) fliplr(result.read(8)) fliplr(result.read(8))],''double'')'});
        trafficlights = containers.Map({...
            traci.constants.ID_LIST,...
            traci.constants.TL_RED_YELLOW_GREEN_STATE,...
            traci.constants.TL_COMPLETE_DEFINITION_RYG,...
            traci.constants.TL_CONTROLLED_LANES,...
            traci.constants.TL_CONTROLLED_LINKS,...
            traci.constants.TL_CURRENT_PROGRAM,...
            traci.constants.TL_CURRENT_PHASE,...
            traci.constants.TL_NEXT_SWITCH},...
            {'readStringList','readString','traci.trafficlights.readLogics',...
            'readStringList','traci.trafficlights.readLinks','readString',...
            'readInt','readInt'});
        vehicle = containers.Map({...
            traci.constants.ID_LIST,...
            traci.constants.VAR_SPEED,...
            traci.constants.VAR_SPEED_WITHOUT_TRACI,...
            traci.constants.VAR_POSITION,...
            traci.constants.VAR_ANGLE,...
            traci.constants.VAR_ROAD_ID,...
            traci.constants.VAR_LANE_ID,...
            traci.constants.VAR_LANE_INDEX,...
            traci.constants.VAR_TYPE,...
            traci.constants.VAR_ROUTE_ID,...
            traci.constants.VAR_COLOR,...
            traci.constants.VAR_LANEPOSITION,...
            traci.constants.VAR_CO2EMISSION,...
            traci.constants.VAR_COEMISSION,...
            traci.constants.VAR_HCEMISSION,...
            traci.constants.VAR_PMXEMISSION,...
            traci.constants.VAR_NOXEMISSION,...
            traci.constants.VAR_FUELCONSUMPTION,...
            traci.constants.VAR_NOISEEMISSION,...
            traci.constants.VAR_EDGE_TRAVELTIME,...
            traci.constants.VAR_EDGE_EFFORT,...
            traci.constants.VAR_ROUTE_VALID,...
            traci.constants.VAR_EDGES,...
            traci.constants.VAR_SIGNALS,...
            traci.constants.VAR_LENGTH,...
            traci.constants.VAR_MAXSPEED,...
            traci.constants.VAR_VEHICLECLASS,...
            traci.constants.VAR_SPEED_FACTOR,...
            traci.constants.VAR_SPEED_DEVIATION,...
            traci.constants.VAR_EMISSIONCLASS,...
            traci.constants.VAR_WIDTH,...
            traci.constants.VAR_MINGAP,...
            traci.constants.VAR_SHAPECLASS,...
            traci.constants.VAR_ACCEL,...
            traci.constants.VAR_DECEL,...
            traci.constants.VAR_IMPERFECTION,...
            traci.constants.VAR_TAU,...
            traci.constants.VAR_BEST_LANES,...
            traci.constants.DISTANCE_REQUEST},...
            {'readStringList','readDouble','readDouble','@(result) typecast([fliplr(result.read(8)) fliplr(result.read(8))],''double'')',...
            'readDouble','readString','readString','readInt','readString',...
            'readString','@(result) result.read(4)','readDouble','readDouble','readDouble',...
            'readDouble','readDouble','readDouble','readDouble','readDouble',...
            'readDouble','readDouble','@(result) result.read(1)','readStringList',...
            'readInt','readDouble','readDouble','readString','readDouble','readDouble',...
            'readString','readDouble','readDouble','readString','readDouble','readDouble',...
            'readDouble','readDouble','traci.vehicle.readBestLanes','readDouble'});
        vehicletype = containers.Map({...
            traci.constants.ID_LIST,...
            traci.constants.VAR_LENGTH,...
            traci.constants.VAR_MAXSPEED,...
            traci.constants.VAR_SPEED_FACTOR,...
            traci.constants.VAR_SPEED_DEVIATION,...
            traci.constants.VAR_ACCEL,...
            traci.constants.VAR_DECEL,...
            traci.constants.VAR_IMPERFECTION,...
            traci.constants.VAR_TAU,...
            traci.constants.VAR_VEHICLECLASS,...
            traci.constants.VAR_EMISSIONCLASS,...
            traci.constants.VAR_SHAPECLASS,...
            traci.constants.VAR_MINGAP,...
            traci.constants.VAR_WIDTH,...
            traci.constants.VAR_COLOR},...
            {'readStringList','readDouble','readDouble','readDouble','readDouble',...
            'readDouble','readDouble','readDouble','readDouble','readString',...
            'readString','readString','readDouble','readDouble','@(result) result.read(4)'});
    end    
end