/*
 * Decompiled with CFR 0.152.
 */
package cadyts.interfaces.sumo;

import cadyts.interfaces.sumo.SumoCalibrator;
import cadyts.measurements.SingleLinkMeasurement;
import cadyts.supply.BasicSimResults;
import cadyts.utilities.misc.DynamicData;
import java.util.logging.Logger;
import javax.xml.parsers.SAXParser;
import javax.xml.parsers.SAXParserFactory;
import org.xml.sax.Attributes;
import org.xml.sax.helpers.DefaultHandler;

class SumoFlowLoader
extends DefaultHandler {
    static final String INTERVAL_ELEM = "interval";
    static final String START_ATTR = "begin";
    static final String END_ATTR = "end";
    static final String EDGE_ELEM = "edge";
    static final String ID_ATTR = "id";
    static final String ENTERED_ATTR = "entered";
    static final String ARRIVED_ATTR = "arrived";
    static final String DEPARTED_ATTR = "departed";
    static final String TT_ATTR = "traveltime";
    private final SumoCalibrator calibrator;
    private final BasicSimResults<String> result;
    private final DynamicData<String> flowResult;
    private final DynamicData<String> countResult;
    private final DynamicData<String> ttResult;
    private int start_s = 0;
    private int end_s = 0;

    SumoFlowLoader(SumoCalibrator calibrator) {
        if (calibrator == null) {
            throw new IllegalArgumentException("calibrator is null");
        }
        this.calibrator = calibrator;
        this.result = new BasicSimResults(0, calibrator.getTimeBinSize_s(), 86400 / calibrator.getTimeBinSize_s());
        this.flowResult = this.result.getSimResults(SingleLinkMeasurement.TYPE.FLOW_VEH_H);
        this.countResult = this.result.getSimResults(SingleLinkMeasurement.TYPE.COUNT_VEH);
        this.ttResult = new DynamicData(this.countResult.getStartTime_s(), this.countResult.getBinSize_s(), this.countResult.getBinCnt());
    }

    void load(String fileName) {
        try {
            SAXParserFactory factory = SAXParserFactory.newInstance();
            SAXParser saxParser = factory.newSAXParser();
            saxParser.parse(fileName, (DefaultHandler)this);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    BasicSimResults<String> getResults() {
        return this.result;
    }

    DynamicData<String> getTravelTimes() {
        return this.ttResult;
    }

    private void checkTimes(int start_s, int end_s, int binSize_s, int bin) {
        if (start_s != bin * binSize_s) {
            Logger.getLogger(this.getClass().getName()).warning("flow start time " + start_s + " s is not the beginning of a " + binSize_s + " s time bin; corrected into " + bin * binSize_s + " s");
        }
        if (end_s != (bin + 1) * binSize_s) {
            Logger.getLogger(this.getClass().getName()).warning("flow end time " + end_s + " s is not " + binSize_s + " s larger than (proper) start time; " + "corrected into " + (bin + 1) * binSize_s + " s");
        }
    }

    public void startFlow(double flow_veh, int start_s, int end_s, String link) {
        int binSize_s = this.flowResult.getBinSize_s();
        int bin = this.flowResult.bin(start_s);
        this.checkTimes(start_s, end_s, binSize_s, bin);
        this.countResult.put(link, bin, flow_veh);
        double flow_veh_h = flow_veh / (double)(end_s - start_s) * 3600.0;
        this.flowResult.put(link, bin, flow_veh_h);
    }

    public void startTT(double tt_s, int start_s, int end_s, String link) {
        int binSize_s = this.flowResult.getBinSize_s();
        int bin = this.flowResult.bin(start_s);
        this.checkTimes(start_s, end_s, binSize_s, bin);
        this.ttResult.put(link, bin, tt_s);
    }

    @Override
    public void startElement(String namespaceURI, String sName, String qName, Attributes attrs) {
        if (INTERVAL_ELEM.equals(qName)) {
            this.start_s = (int)Math.round(Double.parseDouble(attrs.getValue(START_ATTR)));
            this.end_s = (int)Math.round(Double.parseDouble(attrs.getValue(END_ATTR)));
            if (this.start_s < 0) {
                Logger.getLogger(this.getClass().getName()).warning("start time is negative; corrected");
                this.start_s = 0;
            }
            if ((double)this.end_s > 86400.0) {
                Logger.getLogger(this.getClass().getName()).warning("end time goes beyond one day; corrected");
                this.end_s = 86400;
            }
            if (this.start_s >= this.end_s) {
                Logger.getLogger(this.getClass().getName()).warning("meaningless time interval [" + this.start_s + ", " + this.end_s + ") s; ignored");
            }
        } else if (EDGE_ELEM.equals(qName) && this.start_s < this.end_s) {
            String linkId = attrs.getValue(ID_ATTR);
            double flow_veh = Integer.parseInt(attrs.getValue(ENTERED_ATTR));
            if (this.calibrator.getCountFirstLink()) {
                flow_veh += (double)Integer.parseInt(attrs.getValue(DEPARTED_ATTR));
            }
            if (!this.calibrator.getCountLastLink()) {
                flow_veh -= (double)Integer.parseInt(attrs.getValue(ARRIVED_ATTR));
            }
            if (flow_veh < 0.0) {
                Logger.getLogger(this.getClass().getName()).warning("simulated flow on link " + linkId + " is " + flow_veh + " (probably because too many arrived vehicles were " + "subtracted from entered vehicles)");
            }
            this.startFlow(flow_veh, this.start_s, this.end_s, linkId);
            String ttString = attrs.getValue(TT_ATTR);
            if (ttString != null) {
                double tt_s = Double.parseDouble(ttString);
                this.startTT(tt_s, this.start_s, this.end_s, linkId);
            }
        }
    }
}

