/*
 * Decompiled with CFR 0.152.
 */
package cadyts.interfaces.dracula;

import cadyts.interfaces.dracula.DraculaCalibrator;
import cadyts.interfaces.dracula.DraculaLink;
import cadyts.interfaces.dracula.DraculaODRelation;
import cadyts.interfaces.dracula.DraculaRoute;
import cadyts.utilities.io.tabularFileParser.TabularFileHandler;
import cadyts.utilities.io.tabularFileParser.TabularFileParser;
import cadyts.utilities.misc.Tuple;
import java.io.IOException;
import java.io.Serializable;
import java.util.LinkedHashMap;
import java.util.Map;

class DraculaRoutes
implements TabularFileHandler,
Serializable {
    private static final long serialVersionUID = 1L;
    private static final String START_TAG = "&ROUTES";
    private static final String END_TAG = "&PUB_SERVICES";
    private static final int ROUTE_ID_INDEX = 0;
    private static final int ORIGIN_ZONE_INDEX = 1;
    private static final int DESTINATION_ZONE_INDEX = 2;
    private final int LINK_CNT_INDEX;
    private final int FIRST_LINK_INDEX;
    private Map<Tuple<?, ?>, DraculaODRelation> zones2od = new LinkedHashMap();
    private Map<Long, DraculaRoute> id2route = new LinkedHashMap<Long, DraculaRoute>();

    DraculaRoutes(String routeFileName, DraculaCalibrator calibrator) {
        if (routeFileName == null) {
            throw new IllegalArgumentException("routeFileName is null");
        }
        if (calibrator == null) {
            throw new IllegalArgumentException("calibrator is null");
        }
        this.LINK_CNT_INDEX = 9 + (calibrator.getDemandPeriods() - 1);
        this.FIRST_LINK_INDEX = 10 + (calibrator.getDemandPeriods() - 1);
        TabularFileParser parser = new TabularFileParser();
        parser.setStartTag(START_TAG);
        parser.setEndTag(END_TAG);
        parser.setDelimiterRegex("\\s");
        parser.setMinRowLength(this.FIRST_LINK_INDEX + 1);
        try {
            parser.parse(routeFileName, this);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    DraculaRoute getRoute(Long id) {
        return this.id2route.get(id);
    }

    @Override
    public void startDocument() {
    }

    @Override
    public void endDocument() {
    }

    @Override
    public String preprocess(String line) {
        return line;
    }

    @Override
    public void startRow(String[] row) {
        DraculaODRelation od;
        Integer toZone;
        Integer fromZone = Integer.parseInt(row[1]);
        Tuple<Integer, Integer> zones = new Tuple<Integer, Integer>(fromZone, toZone = Integer.valueOf(Integer.parseInt(row[2])));
        if (this.zones2od.containsKey(zones)) {
            od = this.zones2od.get(zones);
        } else {
            od = new DraculaODRelation(fromZone, toZone);
            this.zones2od.put(zones, od);
        }
        long routeId = Long.parseLong(row[0]);
        DraculaRoute route = new DraculaRoute(routeId, od);
        int linkCnt = Integer.parseInt(row[this.LINK_CNT_INDEX].replaceAll("/", ""));
        int i = this.FIRST_LINK_INDEX;
        while (i < this.FIRST_LINK_INDEX + linkCnt) {
            int linkIndex = Integer.parseInt(row[i].replaceAll("/", ""));
            route.addLink(new DraculaLink(linkIndex));
            ++i;
        }
        route.trimToSize();
        this.id2route.put(route.getId(), route);
        od.addRoute(route);
    }

    public static void main(String[] args) {
        DraculaCalibrator c = new DraculaCalibrator(null, null, 3600);
        DraculaRoutes routeSet = new DraculaRoutes("C:\\dracula\\otley\\otley.dem", c);
        for (Map.Entry<Long, DraculaRoute> entry : routeSet.id2route.entrySet()) {
            System.out.println(entry.getKey() + " --> " + entry.getValue());
        }
    }
}

