/*
 * Decompiled with CFR 0.152.
 */
package trafficdefinition;

import classes.Pair;
import classes.Project;
import classes.TypeSelection;
import simulation.VehicleType;
import tdl.XMLHelpers;
import trafficdefinition.TrafficDefinitionLayer;

public class RandomTrafficDefinitionLayer
extends TrafficDefinitionLayer {
    private static final long serialVersionUID = 1L;
    private int startingTime = 0;
    private int endingTime = 0;
    private int vehiclesPerSecond = 0;
    private TypeSelection<VehicleType> vehicleSelection;

    public RandomTrafficDefinitionLayer() {
        this.vehicleSelection = new TypeSelection();
        this.vehicleSelection.add(new Pair<VehicleType, Float>(Project.getCurrentlyLoadedProject().getDefaultVehicleType(), Float.valueOf(1.0f)));
    }

    public RandomTrafficDefinitionLayer(RandomTrafficDefinitionLayer source) {
        super(source);
    }

    @Override
    public TrafficDefinitionLayer duplicate() {
        return new RandomTrafficDefinitionLayer(this);
    }

    @Override
    public String toString() {
        return String.valueOf(super.toString()) + "(Random layer)";
    }

    public int getEndingTime() {
        return this.endingTime;
    }

    public void setEndingTime(int endingTime) {
        this.endingTime = endingTime;
    }

    public int getStartingTime() {
        return this.startingTime;
    }

    public void setStartingTime(int startingTime) {
        this.startingTime = startingTime;
    }

    public int getVehiclesPerSecond() {
        return this.vehiclesPerSecond;
    }

    public void setVehiclesPerSecond(int vehiclesPerSecond) {
        this.vehiclesPerSecond = vehiclesPerSecond;
    }

    public TypeSelection<VehicleType> getVehicleSelection() {
        return this.vehicleSelection;
    }

    public void setVehicleSelection(TypeSelection<VehicleType> vehicleSelection) {
        this.vehicleSelection = vehicleSelection;
    }

    @Override
    public String toXML() {
        StringBuilder sb = new StringBuilder();
        sb.append("<randomTrafficLayer name=\"" + this.name + "\" startingTime =\"" + String.valueOf(this.startingTime) + "\" endingTime =\"" + String.valueOf(this.endingTime) + "\" vehiclesPerSecond=\"" + String.valueOf(this.vehiclesPerSecond) + "\">\n");
        sb.append(XMLHelpers.vehicleSelectionToXML("vehicleSelection", this.vehicleSelection));
        sb.append("</randomTrafficLayer>\n");
        return sb.toString();
    }
}

