#ifdef ENABLE_TTXT

/*
 *	subtitle editor
 *
 *	http://kitone.free.fr/subtitleeditor/
 *
 *	Copyright @ 2005-2006, kitone
 *
 *	Contact: kitone at free dot fr
 *
 *	This program is free software; you can redistribute it and/or
 *	modify it under the terms of the GNU General Public
 *	License as published by the Free Software Foundation; either
 *	version 2 of the License, or (at your option) any later version.
 *
 *	This program is distributed in the hope that it will be useful,
 *	but WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.	See the GNU
 *	General Public License for more details.
 *
 *	You should have received a copy of the GNU General Public
 *	License along with this program; if not, write to the Free Software
 *	Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA	02111-1307	USA
 *
 *	See gpl.txt for more information regarding the GNU General Public License.
 *
 *
 *	\file
 *	\brief 
 *	\author kitone (kitone at free dot fr)
 */


#include "SubtitleTTXT.h"
#include <libxml++/libxml++.h>
#include <iostream>
#include <glib.h>
#include "utility.h"

/*
 *
 */
Glib::ustring SubtitleTTXT::get_name()
{
	return "TTXT";
}

/*
 *
 */
Glib::ustring SubtitleTTXT::get_extension()
{
	return "ttxt";
}

/*
 *
 */
bool SubtitleTTXT::check(const std::string &line)
{
	if(line.find("<TextStream") != std::string::npos)
		return true;
	return false;
}



/*
 *
 */
SubtitleTTXT::SubtitleTTXT(Document* doc)
:SubtitleFormat(doc)
{
	se_debug(SE_DEBUG_LOADER | SE_DEBUG_SAVER);
}

/*
 *
 */
SubtitleTTXT::~SubtitleTTXT()
{
	se_debug(SE_DEBUG_LOADER | SE_DEBUG_SAVER);
}


bool SubtitleTTXT::open(const Glib::ustring &filename, const Glib::ustring &encoding)
{
	se_debug(SE_DEBUG_LOADER);

	SubtitleFormat::open(filename,encoding);

	try
	{
		xmlpp::DomParser parser;
		//parser.set_validate();
		parser.set_substitute_entities();
		parser.parse_file(filename);

		if(parser)
		{
			const xmlpp::Node* root = parser.get_document()->get_root_node();

			xmlpp::Node::NodeList list = root->get_children();

			for(xmlpp::Node::NodeList::const_iterator it = list.begin(); it!=list.end(); ++it)
			{

				if((*it)->get_name() == "TextSample")
				{
					const xmlpp::Element *element = dynamic_cast<const xmlpp::Element*>(*it);

					SubtitleModifier subtitle( m_subtitleModel->append() );
					
					// text
					const xmlpp::Attribute *att_text = element->get_attribute("text");
					if(att_text)
					{
						Glib::ustring text = att_text->get_value();

						subtitle.set_text(text);
					}
					// time
					const xmlpp::Attribute *att_time =  element->get_attribute("sampleTime");
					if(att_time)
					{
						Glib::ustring time = att_time->get_value();

						subtitle.set_start(time);
					}
				}
			}

			return true;
			
		}
		else
		{
			throw SubtitleException("SubtitleTTXT", _("I can't open this file."));
		}
	}
	catch(const std::exception &ex)
	{
		throw SubtitleException("SubtitleTTXT", ex.what());
	}

	return false;
}


/*
 *
 */
bool SubtitleTTXT::save(const Glib::ustring &filename, const Glib::ustring &encoding)
{
	se_debug(SE_DEBUG_SAVER);
	
	try
	{
		SubtitleFormat::save(filename,encoding);

		xmlpp::Document doc;

		xmlpp::Element* root = doc.create_root_node("TextStream");

		SubtitleColumnRecorder column;
		
		Gtk::TreeNodeChildren rows = m_subtitleModel->children();

		for(Gtk::TreeIter it = rows.begin(); it; ++it)
		{
			SubtitleModifier subtitle(it);

			xmlpp::Element* sub = root->add_child("TextSample");

			SubtitleTime start = subtitle.get_start();
			SubtitleTime end = subtitle.get_end();
			Glib::ustring text = "'" + subtitle.get_text() + "'";


			sub->set_attribute("sampleTime", get_time(start));
			//sub->set_attribute("sampleTime", get_time(end));
			
			newline_to_characters(text, "''");

			sub->set_attribute("text", text);
		}

		doc.write_to_file(filename, encoding);
	}
	catch(const std::exception &ex)
	{
		throw SubtitleException("SubtitleTTXT", ex.what());
	}

	return true;
}

/*
 *
 */
Glib::ustring SubtitleTTXT::get_time(const SubtitleTime &time)
{
	gchar* tmp = g_strdup_printf("%.2i:%.2i:%.2i.%.3i",
			time.hours, time.mins, time.secs, time.msecs);
	Glib::ustring str(tmp);
	g_free(str);

	return str;
}

#endif//ENABLE_TTXT
