/* ====================================================================
 * Copyright (c) 2007-2008  Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_SPLITTER_H
#define _SC_SPLITTER_H

// sc
class SplitterHandle;

// qt
#include <QtGui/QSplitter>



/** Splitter with "on handle double click hide first or last child" */
class Splitter : public QSplitter
{
  typedef QSplitter super;
  Q_OBJECT

public:
  enum Hide
  {
    First,    ///< double click on handle hides the first child.
    Last      ///< double click on handle hides the last child.
  };

  /**
   * construct a @a Splitter with the given parent @a parent and hide widget
   * @a hide. Optionally set the splitter @a orientation.
   */
  Splitter( QWidget *parent, Hide hide = First );
  Splitter( QWidget *parent, Qt::Orientation orientation, Hide hide = First );

  /** @c QSplitter overwrite. */
  QSplitterHandle* createHandle();

  /** show or hide the "hide" child. */
  void showHide( bool );

  /** enable or disable the "hide" child. */
  void enableHide( bool );

private:
  int length();

  Hide            _hide;
  SplitterHandle* _handle;
};

#endif // _SC_SPLITTER_H
