/* ====================================================================
 * Copyright (c) 2003-2007, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_UPDATEPARAM_H
#define _SC_UPDATEPARAM_H

// sc
#include "ScParam.h"
#include "util/String.h"
#include "svn/Revision.h"


/**
 * Parameter class for UpdateCmd.
 */
class UpdateParam : public ScParam
{
public:
  UpdateParam( const sc::String& path, const svn::RevisionPtr rev, bool recurse )
    : _path(path), _rev(rev), _recurse(recurse)
  {
  }

  ~UpdateParam()
  {
  }

  const sc::String& getPath() const
  {
    return _path;
  }

  void setPath( const sc::String& path )
  {
    _path = path;
  }

  const svn::RevisionPtr getRevision() const
  {
    return _rev;
  }

  void setRevision( svn::RevisionPtr rev )
  {
    _rev = rev;
  }

  bool getRecurse() const
  {
    return _recurse;
  }

  void setRecurse( bool recurse )
  {
    _recurse = recurse;
  }

  svn::Revnumber& getRevnumber()
  {
    return _revnum;
  }

  ScParamAccept(UpdateParam);

private:
  // in
  sc::String       _path;
  svn::RevisionPtr _rev;
  bool             _recurse;

  // out
  svn::Revnumber   _revnum;
};

#endif // _SC_UPDATEPARAM_H
