/* ====================================================================
 * Copyright (c) 2008       Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

// sc
#include "Admin.h"
#include "Error.h"
#include "util/apr.h"
#include "util/Error.h"

// svn
#include <svn_repos.h>

using sc::Success;

namespace svn
{

sc::Error* Admin::createRepository( const sc::String& path )
{
  apr::Pool pool;
  svn_repos_t* repos;
  svn_error_t* err = svn_repos_create( &repos, path, NULL, NULL, NULL, NULL, pool );

  if( err )
    return wrapError(err);

  return Success;
}

} // namespace
