/* ====================================================================
 * Copyright (c) 2003-2007, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

// sc
#include "config.h"
#include "ToolsSettingsWidget.h"
#include "../ExternProvider.h"
#include "sublib/ExternButton.h"
#include "util/String.h"

// qt
#include <QtGui/QLayout>
#include <QtGui/QLabel>
#include <QtGui/QLineEdit>
#include <QtGui/QPushButton>
#include <QtGui/QFileDialog>



ToolsSettingsWidget::ToolsSettingsWidget( ExternProvider* p, QWidget *parent )
: super(parent), _p(p), _initialized(false)
{
  QVBoxLayout* vl = new QVBoxLayout(this);
  {
    int row = 0;

    QGridLayout* gl = new QGridLayout(vl,2,3);
    gl->setMargin(2);
    gl->setSpacing(5);
    gl->setColStretch( 0, 1 );
    gl->setColStretch( 1, 6 );
    gl->setColStretch( 2, 1 );
    vl->addStretch(1);
    {
      // diff command
      QLabel* diffLabel   = new QLabel(_q("(visual) diff comand:"), this);
      QPushButton* diffBi = new QPushButton( _q("reset/builtin"), this );
      _diffEdit           = new QLineEdit( this );
      QPushButton* diffEx = new ExternButton( this );
      QLabel* diffInfo    = new QLabel(
        _q("valid diff parameters: {left}, {right}, {llabel}, {rlabel}"), this);

      gl->addMultiCellWidget(diffLabel,row,row,0,2);
      row++;
      gl->addWidget(diffBi,row,0);
      gl->addWidget(_diffEdit,row,1);
      gl->addWidget(diffEx,row,2);
      row++;
      gl->addMultiCellWidget(diffInfo,row,row,0,2);
      row++;

      gl->setRowSpacing(row,25);
      row++;

      // merge command
      QLabel* mergeLabel   = new QLabel(_q("(visual) merge comand:"), this);
      QPushButton* mergeBi = new QPushButton( _q("reset/builtin"), this );
      _mergeEdit           = new QLineEdit( this );
      QPushButton* mergeEx = new ExternButton( this );
      QLabel* mergeInfo    = new QLabel(
        _q("valid merge parameters: {theirs}, {mine}, {base}, {merged}"), this);

      gl->addMultiCellWidget(mergeLabel,row,row,0,2);
      row++;
      gl->addWidget(mergeBi,row,0);
      gl->addWidget(_mergeEdit,row,1);
      gl->addWidget(mergeEx,row,2);
      row++;
      gl->addMultiCellWidget(mergeInfo,row,row,0,2);
      row++;

      connect( diffEx,  SIGNAL(clicked()), SLOT(selectDiff()) );
      connect( mergeEx, SIGNAL(clicked()), SLOT(selectMerge()) );

      connect( diffBi,  SIGNAL(clicked()), SLOT(resetDiff()) );
      connect( mergeBi, SIGNAL(clicked()), SLOT(resetMerge()) );

      connect( _diffEdit,  SIGNAL(textChanged(const QString&)), SLOT(textChanged(const QString&)) );
      connect( _mergeEdit, SIGNAL(textChanged(const QString&)), SLOT(textChanged(const QString&)) );
    }
  }
}

ToolsSettingsWidget::~ToolsSettingsWidget()
{
}

void ToolsSettingsWidget::setBuiltinDiffCmd( const QString& cmd )
{
  _diffBi = cmd;
}

void ToolsSettingsWidget::setBuiltinMergeCmd( const QString& cmd )
{
  _mergeBi = cmd;
}

void ToolsSettingsWidget::setDiffCmd( const QString& cmd )
{
  _diffEdit->setText(cmd);
}

void ToolsSettingsWidget::setMergeCmd( const QString& cmd )
{
  _mergeEdit->setText(cmd);
}

QString ToolsSettingsWidget::getDiffCmd()
{
  return _diffEdit->text();
}

QString ToolsSettingsWidget::getMergeCmd()
{
  return _mergeEdit->text();
}

void ToolsSettingsWidget::selectDiff()
{
  QString qres = QFileDialog::getOpenFileName( _diffEdit->text(), QString::null,
    this, "", _q("subcommander:select diff command") );

  if( ! qres.isEmpty() )
    _diffEdit->setText( qres );

  emit modified();
}

void ToolsSettingsWidget::selectMerge()
{
  QString qres = QFileDialog::getOpenFileName( _mergeEdit->text(), QString::null,
    this, "", _q("subcommander:select merge command") );

  if( ! qres.isEmpty() )
    _mergeEdit->setText( qres );

  emit modified();
}

void ToolsSettingsWidget::setInitialized()
{
  _initialized = true;
}

void ToolsSettingsWidget::textChanged( const QString& )
{
  if( _initialized )
    emit modified();
}

void ToolsSettingsWidget::resetDiff()
{
  setDiffCmd(_diffBi);
  emit modified();
}

void ToolsSettingsWidget::resetMerge()
{
  setMergeCmd(_mergeBi);
  emit modified();
}
