/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SVN_WC_STATUS_H
#define _SVN_WC_STATUS_H

// sc
#include "WcStatusTypes.h"
#include "util/String.h"

// svn
#include <svn_wc.h>


namespace svn
{
class WcEntry;
class Lock;


// wc/svn_wc_status_kind
enum WcStatusKind
{
  WcStatus_None        = svn_wc_status_none,
  WcStatus_Unversioned = svn_wc_status_unversioned,
  WcStatus_Normal      = svn_wc_status_normal,
  WcStatus_Added       = svn_wc_status_added,
  WcStatus_Missing     = svn_wc_status_missing,
  WcStatus_Deleted     = svn_wc_status_deleted,
  WcStatus_Replaced    = svn_wc_status_replaced,
  WcStatus_Modified    = svn_wc_status_modified,
  WcStatus_Merged      = svn_wc_status_merged,
  WcStatus_Conflicted  = svn_wc_status_conflicted,
  WcStatus_Ignored     = svn_wc_status_ignored,
  WcStatus_Obstructed  = svn_wc_status_obstructed,
  WcStatus_External    = svn_wc_status_external,
  WcStatus_Incomplete  = svn_wc_status_incomplete
};

/** 
 * The Status of the Lock if any.
 */
enum WcStatusLockKind
{
  WcStatusLock_None,
  WcStatusLock_Locked,
  WcStatusLock_Stolen,
  WcStatusLock_Other,
  WcStatusLock_Broken
};

// wc/svn_wc_status2_t
class WcStatus
{
public:
  WcStatus( const sc::String&, svn_wc_status2_t* );
  WcStatus( const WcStatus& src );
  ~WcStatus();

  void calcLockStatus( bool repos );

  const sc::String& getName() const;

  const WcEntry* getWcEntry() const;
  WcStatusKind getTextStatus() const;
  WcStatusKind getPropStatus() const;
  bool isLocked() const;
  bool isCopied() const;
  bool isSwitched() const;
  WcStatusKind getReposTextStatus() const;
  WcStatusKind getReposPropStatus() const;

  WcStatusLockKind getLockStatus() const;
  const Lock* getReposLock() const;

  bool isChanged() const;
  bool isReposChanged() const;

  bool isChangedOrFlaged() const;  ///< a better name?

  bool isAddable() const;
  bool isRevertable() const;
  bool isRemoveable() const;
  bool isConflicted() const;
  bool isPropConflicted() const;
  bool isVersioned() const;

  // WcEntry
  bool isDir() const;

private:
  sc::String       _name;

  WcEntry*         _entry;
  WcStatusKind     _textStatus;
  WcStatusKind     _propStatus;
  bool             _locked;
  bool             _copied;
  bool             _switched;
  WcStatusKind     _reposTextStatus;
  WcStatusKind     _reposPropStatus;

  WcStatusLockKind _lockStatus;
  Lock*            _reposLock;
};

} // namespace

#endif //  _SVN_WC_STATUS_H

