/* ====================================================================
 * Copyright (c) 2006,      Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

// sc
#include "Path.h"
#include "util/apr.h"

// svn
#include <svn_path.h>

// apr
#include <apr_tables.h>


namespace svn
{
 
  
sc::String Path::findPrefix( const Paths& paths )
{
  apr::Pool pool;

  if( paths.size() == 0 )
  {
    return sc::String();
  }
  else if( paths.size() == 1 )
  {
    char* res = svn_path_dirname( paths.front(), pool );

    return sc::String(res);
  }
  else
  {
    apr_array_header_t* patharr = apr_array_make( pool, (int)paths.size(), sizeof(char*) );

    for( Paths::const_iterator it = paths.begin(); it != paths.end(); it++ )
    {
      APR_ARRAY_PUSH( patharr, const char* ) = *it;
    }

    const char* res = NULL;
    svn_error_t* err = svn_path_condense_targets( &res, NULL, patharr, false, pool );
    if( err != SVN_NO_ERROR )
    {
      // todo
    }

    return sc::String(res);
  }
}

 
} // namespace
