/* ====================================================================
 * Copyright (c) 2003-2006, Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef SC_ERRORDIALOG_H
#define SC_ERRORDIALOG_H

// sc
#include "util/Stackframe.h"
namespace sc {
  class Error;
  class Exception;
  class ExceptionStack;
}

// qt
#include <qdialog.h>
class QLineEdit;
class QTextEdit;


class ErrorDialog : public QDialog
{
  typedef QDialog super;
  Q_OBJECT 

public:
  ErrorDialog( const sc::Exception& e,
    QWidget* parent=0, const char* name=0 );
  ErrorDialog( const sc::Error* err, const Stackframes& stack,
    QWidget* parent=0, const char* name=0 );
  virtual ~ErrorDialog();

private slots:
  void send();

private:
  void setup( const sc::Error* err, const Stackframes& stack );

private:
  QTextEdit* _text;
  QString    _dump;
};

#endif // SC_ERRORDIALOG_H
