/* ====================================================================
 * Copyright (c) 2006,      Martin Hauner
 *                          http://subcommander.tigris.org
 *
 * Subcommander is licensed as described in the file doc/COPYING, which
 * you should have received as part of this distribution.
 * ====================================================================
 */

#ifndef _SC_MERGEDIALOGCMD_H
#define _SC_MERGEDIALOGCMD_H

// sc
#include "sublib/TargetId.h"
class BaseModel;
class Project;
class MergeDialog;
namespace svn {
  class Revision;
}

// qt
#include <qobject.h>
#include <qstring.h>
class QWidget;

/**
 * Helper class to run a dialog based merge.
 */ 
class MergeDialogCmd : public QObject
{
  typedef QObject super;
  Q_OBJECT 

public:
  MergeDialogCmd( QWidget* parent, ID tid, BaseModel* model,
    const Project* prj, bool enableSrc1, bool enableSrc2 );
  ~MergeDialogCmd();

  void run( const QString& src1, const QString& src2,
    const svn::Revision* first, const svn::Revision* second,
    const QString& dst );

public slots:
  void dryrun();
  void merge();
  void close();

private:
  QWidget*       _parent;
  ID             _tid;
  BaseModel*     _model;
  MergeDialog*   _dlg;

  const Project* _prj;
  bool           _enableSrc1;
  bool           _enableSrc2;
};

#endif // _SC_MERGEDIALOGCMD_H
