# - Try to find the  binding of the Poppler library
# Once done this will define
#
#  POPPLER_FOUND - system has poppler
#  POPPLER_INCLUDE_DIR - the poppler include directory
#  POPPLER_LIBRARIES - Link these to use poppler
#  POPPLER_DEFINITIONS - Compiler switches required for using poppler
#

# use pkg-config to get the directories and then use these values
# in the FIND_PATH() and FIND_LIBRARY() calls
INCLUDE(UsePkgConfig)
  
PKGCONFIG(poppler PopplerIncDir PopplerLinkDir PopplerLinkFlags PopplerCflags)
  
set(POPPLER_DEFINITIONS ${PopplerCflags})

FIND_PATH(POPPLER_INCLUDE_DIR poppler-config.h
  ${PopplerIncDir}/poppler
  /usr/include/poppler
  /usr/local/include/poppler
) 
 
FIND_LIBRARY(POPPLER_LIBRARIES poppler
  ${PopplerLinkDir}
  /usr/lib
  /usr/local/lib
)
  
if (POPPLER_INCLUDE_DIR AND POPPLER_LIBRARIES)
  set(POPPLER_FOUND TRUE)
else (POPPLER_INCLUDE_DIR AND POPPLER_LIBRARIES)
  set(POPPLER_FOUND FALSE)
endif (POPPLER_INCLUDE_DIR AND POPPLER_LIBRARIES)
  
if (POPPLER_FOUND)
  if (NOT POPPLER_FIND_QUIETLY)
    message(STATUS "Found poppler: library: ${POPPLER_LIBRARIES}, include path: ${POPPLER_INCLUDE_DIR}")
  endif (NOT POPPLER_FIND_QUIETLY)
else (POPPLER_FOUND)
  if (POPPLER_FIND_REQUIRED)
    message(FATAL_ERROR "Could NOT find poppler")
  endif (POPPLER_FIND_REQUIRED)
endif (POPPLER_FOUND)
  
MARK_AS_ADVANCED(POPPLER_INCLUDE_DIR POPPLER_LIBRARIES)
