""" OfflineToggle.py

"""
__copyright__ = "Copyright (c) 2002-2005 Free Software Foundation, Inc."
__license__ = """
Straw is free software; you can redistribute it and/or modify it under the
terms of the GNU General Public License as published by the Free Software
Foundation; either version 2 of the License, or (at your option) any later
version.

Straw is distributed in the hope that it will be useful, but WITHOUT ANY
WARRANTY; without even the implied warranty of MERCHANTABILITY or FITNESS FOR
A PARTICULAR PURPOSE. See the GNU General Public License for more details.

You should have received a copy of the GNU General Public License along with
this program; if not, write to the Free Software Foundation, Inc., 59 Temple
Place - Suite 330, Boston, MA 02111-1307, USA. """


import pygtk
pygtk.require('2.0')
import gtk
import os
import MVP
import Event
import utils
import Config

class OfflineView(MVP.WidgetView):
    """
    Model: Config instance
    Presenter: OfflinePresenter instance
    """
    def _initialize(self):
        self._widget.remove(self._widget.get_child())
        image = gtk.Image()
        self._widget.add(image)
        self._tooltips = gtk.Tooltips()
        self._model.signal_connect(Event.OfflineModeChangedSignal,
                                   self._mode_changed)

    def _mode_changed(self, signal):
        self._presenter.show()

    def _on_offline_toggle_toggled(self, *args):
        status = self._widget.get_active()
        self._presenter.set(status)

    def set_status(self, text, active):
        self._tooltips.set_tip(self._widget, text, text)
        self._widget.set_active(active)

    def display(self, image):
        self._tooltips.enable()
        child = self._widget.get_child()
        child.set_from_file(image)
        self._widget.show_all()

class OfflinePresenter(MVP.BasicPresenter):
    """
    Model: Config instance
    View: OfflineView instance
    """
    def set(self, status):
        if status != self._model.offline:
            self._model.offline = not self._model.offline

    def show(self):
        if self._model.offline:
            image = "offline.png"
            text = _("Straw is currently online. Click to go offline.")
            self._view.set_status(text, True)
        else:
            image = "online.png"
            text = _("Straw is currently offline. Click to go online.")
            self._view.set_status(text, False)
        image_dir = utils.find_image_dir()
        image_path = os.path.join(image_dir, image)
        self._view.display(image_path)

class OfflineToggle:
    def __init__(self, widget):
        config = Config.get_instance()
        oview =  OfflineView(widget, model=config)
        self._presenter = OfflinePresenter(model=config, view=oview)

    def show(self):
        self._presenter.show()
