# -*- perl -*-

#
#   Copyright (C) Heinz-Josef Claes (2000)
#                 hjclaes@web.de
#   
#   This program is free software; you can redistribute it and/or modify
#   it under the terms of the GNU General Public License as published by
#   the Free Software Foundation; either version 2 of the License, or
#   (at your option) any later version.
#   
#   This program is distributed in the hope that it will be useful,
#   but WITHOUT ANY WARRANTY; without even the implied warranty of
#   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
#   GNU General Public License for more details.
#   
#   You should have received a copy of the GNU General Public License
#   along with this program; if not, write to the Free Software
#   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
#


push @VERSION, '$Id: humanRead.pl,v 1.2 2001/03/14 12:59:37 hjc Exp $ ';

use strict;

# Stellt eine Zahl als dreistellig + Zeichen dar, analog `df -h`
sub humanReadable
{
    my (@par) = (@_);
    my (@type) = (' ', 'k', 'M', 'G', 'T', 'P');
    my (@ret, $s);

    foreach $s (@par)
    {
	my $i;
	for ($i = 0 ; $i < @type - 1; $i++, $s /= 1024.)
	{
	    if ($s < 9)
	    {
		push @ret, sprintf("%.1f%s", $s, $type[$i]);
		goto nextNumber;
	    }
	    elsif ($s < 999)
	    {
		push @ret, sprintf("%3.0f%s", $s, $type[$i]);
		goto nextNumber;
	    }
	}
	push @ret, sprintf("%3.0f%s", $s, $type[$i]);
      nextNumber:;
    }

    return @ret;
}
