/*
 * p a t h . c			-- Path names management
 * 
 * Copyright  2000 Erick Gallesio - I3S-CNRS/ESSI <eg@unice.fr>
 * 
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, 
 * USA.
 * 
 *           Author: Erick Gallesio [eg@unice.fr]
 *    Creation date:  9-Jan-2000 14:25 (eg)
 * Last file update:  9-Jan-2000 19:36 (eg)
 */

#include "stklos.h"
#include "path.h"


/*===========================================================================*\
 * 
 * tilde-expand		-- expand '~' and '~user' string prefix
 * 
\*===========================================================================*/

static char *tilde_expand(char *name, char *result)
{
  if (name[0] != '~') {
    strcpy(result, name);
    return name;
  }
  
  if (ISDIRSEP(name[1]) || name[1] == '\0') {
    char *dir = getenv("HOME");
    
    if (dir == NULL)
      STk_error("couldn't find HOME in environment when expanding %S", name);

    sprintf(result, "%s%c%s", dir, DIRSEP, name+1);
  } 
  else {
#ifdef WIN32
    STk_error("Form '%~user' not allowed on Win32. It was: %S", name);
#else
    char *p;
    struct passwd *pwPtr;
    register int len;
    for (p=&name[1]; (*p != 0) && (*p != '/'); p++) {
      /* Null body;  just find end of name. */
    }
    len = p-(name+1);
    strncpy(result, name+1, (size_t) len);
    result[len] = '\0';

    pwPtr = getpwnam(result);
    if (pwPtr == NULL) {
      endpwent();
      STk_error("User %S does not exist", result);
    }
    sprintf(result, "%s/%s", pwPtr->pw_dir, p);
    endpwent();
#endif
  }
  return result;
}


/*===========================================================================*\
 * 
 * absolute	-- Given a file name, return its (mostly clean) 
 *		   absolute path name
 *
\*===========================================================================*/

static void absolute(char *s, char *pathname)	
{
  char *p = pathname;
  char *t;

  if (!ISABSOLUTE(s)) {
    getcwd(pathname, MAX_PATH_LENGTH);
    p = &pathname[strlen(pathname)];     /* place p at end of pathname */ 
#ifdef WIN32 
    *p = DIRSEP;
#endif
  }
#ifdef WIN32
  else *p = *s++;
#else
  *p = DIRSEP;
#endif
  
  for ( ; *s; s++) {
    t = s;
    switch (*s) {
      case '.' : if (*(s+1)) {
		   switch (*++s) {
		     case '.' : if (ISDIRSEP(*p) && (*(s+1)=='\0' || 
						     ISDIRSEP(*(s+1)))) {
		                  /* We must go back to the parent */
		                  if (ISDIRSEP(*p) && p > pathname)    p --;
				  while (p > pathname && !ISDIRSEP(*p)) p--;
		                }
		                else {
				  /* There are several dots. Copy them */
				  for (s = t; *s == '.'; s++) *++p = '.';
				  s -= 1;
				}
		                break;
#ifdef WIN32
		     case '\\':
#endif
		     case '/' : if (!ISDIRSEP(*p)) {
		                   *++p = '.';
		       		   *++p = DIRSEP;
		     	        }
		                break;
		     default  : *++p = '.'; *++p = *s; break;
		   }
                 }
                 else { /* We have a final (single) dot */
		   if (!ISDIRSEP(*p)) *++p = '.';
		 }
                 break;
#ifdef WIN32
      case '\\':
#endif
      case '/' : if (!ISDIRSEP(*p)) *++p = DIRSEP; break;
      default  : *++p = *s;
    }
  }
  
  /* Place a \0 at end. If path ends with a "/", delete it */
  if (p == pathname || !ISDIRSEP(*p)) p++;
  *p = '\0';

#ifdef WIN32
  /* Replace all "/" by "\" */
  for (p = pathname; *p; p++) 
    if (*p == '/') *p = '\\';
#endif
}
 
char *STk_expand_file_name(char *s)
{
  char expanded[2 * MAX_PATH_LENGTH], abs[2 * MAX_PATH_LENGTH];  
  /* Warning: absolute makes no control about path overflow. Hence the "2 *" */

  absolute(tilde_expand(s, expanded), abs);
  return STk_strdup(abs);
}
