#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif
#include "skin.h"
#include <stdlib.h>
#include <string.h>

#include "stardict.h"

_Skin_cursor::_Skin_cursor()
{
	cursor=NULL;
}

_Skin_cursor::~_Skin_cursor()
{
	if (cursor)
		gdk_cursor_unref(cursor);
}

_Skin_pixbuf_1::_Skin_pixbuf_1()
{
	for (int i=0;i<1;i++)
		p[i]=NULL;
}

_Skin_pixbuf_1::~_Skin_pixbuf_1()
{
	for (int i=0;i<1;i++)
	{
		if (p[i])
			g_object_unref(p[i]);
	}
}

AppSkin::AppSkin()
{
}

void AppSkin::load()
{		
	stardict.normal_cursor.cursor=(GdkCursor *)NULL; // NULL is the default cursor.
	stardict.watch_cursor.cursor= gdk_cursor_new(GDK_WATCH);

#ifdef _WIN32			
	gchar *filename;
 	filename = g_build_filename(stardict_data_dir, "pixmaps", "stardict.png", NULL);
	stardict.icon.p[0] = gdk_pixbuf_new_from_file (filename, NULL);
	g_free(filename);
	filename = g_build_filename(stardict_data_dir, "pixmaps", "about_menu.png", NULL);
	stardict.about_menu.p[0] = gdk_pixbuf_new_from_file (filename, NULL);
	g_free(filename);
	filename = g_build_filename(stardict_data_dir, "pixmaps", "index_wazard.png", NULL);
	stardict.index_wazard.p[0] = gdk_pixbuf_new_from_file (filename, NULL);
	g_free(filename);
	filename = g_build_filename(stardict_data_dir, "pixmaps", "index_appendix.png", NULL);
	stardict.index_appendix.p[0] = gdk_pixbuf_new_from_file (filename, NULL);
	g_free(filename);
#else
	stardict.icon.p[0] = gdk_pixbuf_new_from_file (GNOME_ICONDIR "/stardict.png", NULL);
	stardict.docklet_normal_icon.p[0] = gdk_pixbuf_new_from_file (STARDICT_DATA_DIR "/pixmaps/docklet_normal.png", NULL);
	stardict.docklet_scan_icon.p[0] = gdk_pixbuf_new_from_file (STARDICT_DATA_DIR "/pixmaps/docklet_scan.png", NULL);
	stardict.docklet_stop_icon.p[0] = gdk_pixbuf_new_from_file (STARDICT_DATA_DIR "/pixmaps/docklet_stop.png", NULL);
	stardict.index_wazard.p[0] = gdk_pixbuf_new_from_file (STARDICT_DATA_DIR "/pixmaps/index_wazard.png", NULL);
	stardict.index_appendix.p[0] = gdk_pixbuf_new_from_file (STARDICT_DATA_DIR "/pixmaps/index_appendix.png", NULL);
#endif
}
