#ifdef HAVE_CONFIG_H
#  include "config.h"
#endif

#include <string.h>
#include <string>
#include "floatwin.h"
#include "stardict.h"

#ifdef _WIN32
#  include <gdk/gdkwin32.h>
#  include "win32/intl.h"
#endif

FloatWin::FloatWin()
{
	timeout = 0;
	now_window_width = 0;
	now_window_height = 0;
	button_box_once_shown = false;
	ismoving = false;
	menu = NULL;
}

void FloatWin::End()
{
	if (timeout)
		gtk_timeout_remove(timeout);
	if (menu)
		gtk_widget_destroy(menu);
	if (FloatWindow)
		gtk_widget_destroy(FloatWindow);
}

void FloatWin::Create()
{	
	FloatWindow = gtk_window_new(GTK_WINDOW_POPUP);
	gtk_widget_set_events(FloatWindow, GDK_ENTER_NOTIFY_MASK | GDK_LEAVE_NOTIFY_MASK | GDK_BUTTON_PRESS_MASK | GDK_BUTTON_RELEASE_MASK | GDK_BUTTON1_MOTION_MASK);
	g_signal_connect (G_OBJECT (FloatWindow), "button_press_event", G_CALLBACK (vButtonPressCallback), this);
	g_signal_connect (G_OBJECT (FloatWindow), "button_release_event", G_CALLBACK (vButtonReleaseCallback), this);
	g_signal_connect (G_OBJECT (FloatWindow), "motion_notify_event", G_CALLBACK (vMotionNotifyCallback), this);
	g_signal_connect (G_OBJECT (FloatWindow), "enter_notify_event", G_CALLBACK (vEnterNotifyCallback), this);
	g_signal_connect (G_OBJECT (FloatWindow), "leave_notify_event", G_CALLBACK (vLeaveNotifyCallback), this);

#ifdef _WIN32
	rw_cfg_read_boolean (usercfgfile, "preferences/dictionary", "hide_floatwin_when_modifier_key_released", &hide_floatwin_when_modifier_key_released);
	rw_cfg_read_boolean (usercfgfile, "preferences/floating_window", "lock", &bIsLocked);
	rw_cfg_read_boolean (usercfgfile, "preferences/floating_window", "pronounce_when_popup", &pronounce_when_popup);
	rw_cfg_read_int (usercfgfile, "preferences/floating_window", "max_window_width", &Window_max_width);
	rw_cfg_read_int (usercfgfile, "preferences/floating_window", "max_window_height", &Window_max_height);
#else
	gpAppFrame->oAppConf.read_bool("/apps/stardict/preferences/dictionary/hide_floatwin_when_modifier_key_released", &hide_floatwin_when_modifier_key_released, true);
	gpAppFrame->oAppConf.read_bool("/apps/stardict/preferences/floating_window/lock", &bIsLocked, false);
	gpAppFrame->oAppConf.read_bool("/apps/stardict/preferences/floating_window/pronounce_when_popup", &pronounce_when_popup, false);
	gpAppFrame->oAppConf.read_int("/apps/stardict/preferences/floating_window/max_window_width", &Window_max_width, DEFAULT_MAX_FLOATWIN_WIDTH);
	gpAppFrame->oAppConf.read_int("/apps/stardict/preferences/floating_window/max_window_height", &Window_max_height, DEFAULT_MAX_FLOATWIN_HEIGHT);
#endif

	GdkScreen *screen = gtk_window_get_screen(GTK_WINDOW(FloatWindow));
	gint screen_width = gdk_screen_get_width(screen);
	gint screen_height = gdk_screen_get_height(screen);

	if ((Window_max_width < MIN_MAX_FLOATWIN_WIDTH)||(Window_max_width>screen_width))
		Window_max_width = DEFAULT_MAX_FLOATWIN_WIDTH;
	if ((Window_max_height < MIN_MAX_FLOATWIN_HEIGHT)||(Window_max_height>screen_height))
		Window_max_height = DEFAULT_MAX_FLOATWIN_HEIGHT;
	
	gint lock_x,lock_y;
#ifdef _WIN32
	rw_cfg_read_int (usercfgfile, "preferences/floating_window", "lock_x", &lock_x);
	rw_cfg_read_int (usercfgfile, "preferences/floating_window", "lock_y", &lock_y);
#else
	gpAppFrame->oAppConf.read_int("/apps/stardict/preferences/floating_window/lock_x", &lock_x, 0);
	gpAppFrame->oAppConf.read_int("/apps/stardict/preferences/floating_window/lock_y", &lock_y, 0);
#endif

	if (lock_x<0)
		lock_x=0;
	else if (lock_x > (screen_width - Window_max_width))
		lock_x = screen_width - Window_max_width;
	if (lock_y<0)
		lock_y=0;
	else if (lock_y > (screen_height - Window_max_height))
		lock_y = screen_height - Window_max_height;
	gtk_window_move(GTK_WINDOW(FloatWindow),lock_x,lock_y);
	
	GtkWidget *frame;
	frame = gtk_frame_new(NULL);
	gtk_frame_set_shadow_type(GTK_FRAME(frame),GTK_SHADOW_ETCHED_OUT);
	gtk_container_add(GTK_CONTAINER(FloatWindow),frame);
	GtkWidget *vbox;
	vbox = gtk_vbox_new(false,0);
	gtk_container_set_border_width (GTK_CONTAINER (vbox), FLOATWIN_BORDER_WIDTH);
	gtk_container_add(GTK_CONTAINER(frame),vbox);
	
	button_hbox = gtk_hbox_new(false,0);
	gtk_box_pack_start(GTK_BOX(vbox),button_hbox,false,false,0);
	
	GtkWidget *button;
	button= gtk_button_new();
	gtk_container_add(GTK_CONTAINER(button),gtk_image_new_from_stock(GTK_STOCK_FIND,GTK_ICON_SIZE_MENU));
	gtk_button_set_relief (GTK_BUTTON (button), GTK_RELIEF_NONE);
	g_signal_connect(G_OBJECT(button),"clicked", G_CALLBACK(on_query_click),NULL);
	g_signal_connect(G_OBJECT(button),"enter_notify_event", G_CALLBACK(stardict_on_enter_notify), NULL);
	gtk_box_pack_start(GTK_BOX(button_hbox),button,false,false,0);
	gtk_tooltips_set_tip(gpAppFrame->oAppCore.tooltips,button,_("Query in the main window"),NULL);

	button= gtk_button_new();
	gtk_container_add(GTK_CONTAINER(button),gtk_image_new_from_stock(GTK_STOCK_COPY,GTK_ICON_SIZE_MENU));
	gtk_button_set_relief (GTK_BUTTON (button), GTK_RELIEF_NONE);
	g_signal_connect(G_OBJECT(button),"clicked", G_CALLBACK(on_copy_click),NULL);
	g_signal_connect(G_OBJECT(button),"enter_notify_event", G_CALLBACK(stardict_on_enter_notify), NULL);
	gtk_box_pack_start(GTK_BOX(button_hbox),button,false,false,0);
	gtk_tooltips_set_tip(gpAppFrame->oAppCore.tooltips,button,_("Copy"),NULL);

	PronounceWordButton= gtk_button_new();
	gtk_container_add(GTK_CONTAINER(PronounceWordButton),gtk_image_new_from_stock(GTK_STOCK_EXECUTE,GTK_ICON_SIZE_MENU));
	gtk_button_set_relief (GTK_BUTTON (PronounceWordButton), GTK_RELIEF_NONE);
	g_signal_connect(G_OBJECT(PronounceWordButton),"clicked", G_CALLBACK(on_play_click), this);
	g_signal_connect(G_OBJECT(PronounceWordButton),"enter_notify_event", G_CALLBACK(stardict_on_enter_notify), NULL);
	gtk_box_pack_start(GTK_BOX(button_hbox),PronounceWordButton,false,false,0);
	gtk_tooltips_set_tip(gpAppFrame->oAppCore.tooltips,PronounceWordButton,_("Pronounce the word"),NULL);
	
	gtk_widget_set_sensitive(PronounceWordButton, false);

	StopButton= gtk_button_new();
	gtk_container_add(GTK_CONTAINER(StopButton),gtk_image_new_from_stock(GTK_STOCK_STOP,GTK_ICON_SIZE_MENU));
	gtk_button_set_relief (GTK_BUTTON (StopButton), GTK_RELIEF_NONE);
	g_signal_connect(G_OBJECT(StopButton),"clicked", G_CALLBACK(on_stop_click),NULL);
	g_signal_connect(G_OBJECT(StopButton),"enter_notify_event", G_CALLBACK(stardict_on_enter_notify), NULL);
	gtk_box_pack_start(GTK_BOX(button_hbox),StopButton,false,false,0);
	gtk_tooltips_set_tip(gpAppFrame->oAppCore.tooltips, StopButton, _("Stop selection scanning"),NULL);
	gboolean scan;
#ifdef _WIN32
	rw_cfg_read_boolean (usercfgfile, "preferences/dictionary", "scan_selection", &scan);
#else
	gpAppFrame->oAppConf.read_bool("/apps/stardict/preferences/dictionary/scan_selection", &scan, true);
#endif
	gtk_widget_set_sensitive(gpAppFrame->oAppCore.oFloatWin.StopButton, scan);

	button= gtk_button_new();
	gtk_container_add(GTK_CONTAINER(button),gtk_image_new_from_stock(GTK_STOCK_HELP,GTK_ICON_SIZE_MENU));
	gtk_button_set_relief (GTK_BUTTON (button), GTK_RELIEF_NONE);
	g_signal_connect(G_OBJECT(button),"clicked", G_CALLBACK(on_help_click),NULL);
	g_signal_connect(G_OBJECT(button),"enter_notify_event", G_CALLBACK(stardict_on_enter_notify), NULL);
	gtk_box_pack_start(GTK_BOX(button_hbox),button,false,false,0);
	gtk_tooltips_set_tip(gpAppFrame->oAppCore.tooltips,button,_("Help"),NULL);

	button= gtk_button_new();
	gtk_container_add(GTK_CONTAINER(button),gtk_image_new_from_stock(GTK_STOCK_QUIT,GTK_ICON_SIZE_MENU));
	gtk_button_set_relief (GTK_BUTTON (button), GTK_RELIEF_NONE);
	g_signal_connect(G_OBJECT(button),"clicked", G_CALLBACK(on_quit_click),NULL);
	g_signal_connect(G_OBJECT(button),"enter_notify_event", G_CALLBACK(stardict_on_enter_notify), NULL);
	gtk_box_pack_start(GTK_BOX(button_hbox),button,false,false,0);
	gtk_tooltips_set_tip(gpAppFrame->oAppCore.tooltips,button,_("Quit"),NULL);

	button = gtk_button_new();
	if (bIsLocked)
		lock_image= gtk_image_new_from_stock(GTK_STOCK_GOTO_LAST,GTK_ICON_SIZE_MENU);
	else
		lock_image= gtk_image_new_from_stock(GTK_STOCK_GO_FORWARD,GTK_ICON_SIZE_MENU);
	gtk_container_add(GTK_CONTAINER(button),lock_image);
	gtk_button_set_relief (GTK_BUTTON (button), GTK_RELIEF_NONE);	
	g_signal_connect(G_OBJECT(button),"clicked", G_CALLBACK(vLockCallback),this);
	g_signal_connect(G_OBJECT(button),"enter_notify_event", G_CALLBACK(stardict_on_enter_notify), NULL);
	gtk_box_pack_end(GTK_BOX(button_hbox),button,false,false,0);
	gtk_tooltips_set_tip(gpAppFrame->oAppCore.tooltips,button,_("Lock floating window"),NULL);

	label = gtk_label_new(NULL);
	//gtk_label_set_selectable(GTK_LABEL (label), true); //this make floating window can't move when click on the window,so cancel this approach.
	gtk_label_set_justify (GTK_LABEL (label), GTK_JUSTIFY_LEFT);
	//gtk_misc_set_alignment (GTK_MISC (label), 0.0, 0.5);
		
	scrolled_window = gtk_scrolled_window_new(NULL,NULL);
	gtk_scrolled_window_set_shadow_type (GTK_SCROLLED_WINDOW (scrolled_window), GTK_SHADOW_NONE);
	gtk_scrolled_window_set_policy (GTK_SCROLLED_WINDOW (scrolled_window), GTK_POLICY_NEVER, GTK_POLICY_AUTOMATIC);

	GtkWidget *viewport = gtk_viewport_new (gtk_scrolled_window_get_hadjustment (GTK_SCROLLED_WINDOW(scrolled_window)),
				gtk_scrolled_window_get_vadjustment (GTK_SCROLLED_WINDOW(scrolled_window)));
	gtk_widget_add_events(viewport,GDK_BUTTON1_MOTION_MASK);
	gtk_widget_add_events(viewport,GDK_BUTTON_RELEASE_MASK);	
	gtk_viewport_set_shadow_type(GTK_VIEWPORT(viewport),GTK_SHADOW_NONE);
	gtk_container_add (GTK_CONTAINER (scrolled_window), viewport);
	gtk_container_add (GTK_CONTAINER (viewport), label);
	
	gtk_box_pack_start(GTK_BOX(vbox),scrolled_window,true,true,0);
		
	gtk_widget_show_all(frame);
	gtk_widget_hide(button_hbox); //show all will show hbox's children,now hide hbox only.	
}

void FloatWin::ShowText(gchar **word, gchar **data,const gchar * sOriginWord)
{
	QueryingWord = sOriginWord;
	found_result = FLOAT_WIN_FOUND;
	std::string mark;
	gchar *m_str;
	mark = "<b><big>";
	m_str = g_markup_escape_text(sOriginWord,-1);
	mark += m_str;
	g_free(m_str);
	mark += "</big></b>";
	
	gchar *p;
	glong data_size,sec_size;
	for (int i=0;i< gpAppFrame->oAppCore.oLibs.total_libs();i++)
	{
		if (word[i]) {
			mark += "\n<span foreground=\"blue\">*--- ";
			m_str = g_markup_escape_text(gpAppFrame->oAppCore.oLibs.GetBookname(i),-1);
			mark += m_str;
			g_free(m_str);
			mark += " ---*</span>";
			
			if (strcmp(word[i],sOriginWord)) {
				mark +=	"\n<span foreground=\"purple\">";
				m_str = g_markup_escape_text(word[i],-1);
				mark += m_str;
				g_free(m_str);
				mark += "</span>";
			}
		}
		if (data[i]) {			
			memcpy(&data_size,data[i],sizeof(glong));
			p=data[i]+sizeof(glong);
			while (p - (data[i] + sizeof(glong))< data_size)
			{
				switch (*p)
				{
					case 'm':
					case 'o': //need more work...
						sec_size = strlen(p+sizeof(gchar));
						if (sec_size) {							
							mark+= "\n";
							m_str = g_markup_escape_text(p+sizeof(gchar),sec_size);
							mark += m_str;
							g_free(m_str);							
						}
						sec_size++;
						break;
					case 't':
						sec_size = strlen(p+sizeof(gchar));
						if (sec_size) {
							mark += "\n<big>[";
							m_str = g_markup_escape_text(p+sizeof(gchar),sec_size);
							mark += m_str;
							g_free(m_str);
							mark+= "]</big>";
						}
						sec_size++;
						break;
					case 'y':
						sec_size = strlen(p+sizeof(gchar));
						if (sec_size) {
							mark += "\n<span foreground=\"red\">[";
							m_str = g_markup_escape_text(p+sizeof(gchar),sec_size);
							mark += m_str;
							g_free(m_str);
							mark+= "]</span>";
						}
						sec_size++;						
						break;
					case 'W':
						memcpy(&sec_size,p+sizeof(gchar),sizeof(glong));
						//enbale sound button.
						sec_size+= sizeof(glong);
						break;
					case 'P':
						memcpy(&sec_size,p+sizeof(gchar),sizeof(glong));
						sec_size+= sizeof(glong);
						break;						
				}								
				p = p+sizeof(gchar)+sec_size;
			}
		}		
	}
	SetText(mark.c_str());
	
	gboolean canRead = gpAppFrame->oReadWord.canRead(sOriginWord);
	if (canRead) {
		PronounceWord = sOriginWord;
	}
	else {
		for (int i=0;i< gpAppFrame->oAppCore.oLibs.total_libs(); i++) {
			if (word[i] && strcmp(word[i], sOriginWord)) {
				if (gpAppFrame->oReadWord.canRead(word[i])) {
					canRead = true;
					PronounceWord = word[i];
				}
				break;
			}
		}
	}
	gtk_widget_set_sensitive(PronounceWordButton, canRead);	
	Popup(true);

	if (canRead && pronounce_when_popup)
		gpAppFrame->oReadWord.read(PronounceWord.c_str());
}

void FloatWin::ShowText(gchar *** pppWord, gchar *** pppWordData, const gchar ** ppOriginWord, gint count,const gchar * sOriginWord)
{
	QueryingWord = sOriginWord;
	found_result = FLOAT_WIN_FUZZY_FOUND;
	std::string mark;
	gchar *m_str;
	mark = _("Fuzzy query");
	mark += " <b><big>";
	m_str = g_markup_escape_text(sOriginWord,-1);
	mark += m_str;
	g_free(m_str);
	mark += "</big></b> ";
	mark += _("has succeeded.\n");
	mark += _("Found ");
	if (count ==1)
		mark+= _("1 word:\n");
	else
	{
		m_str=g_strdup_printf("%d",count);
		mark += m_str;
		g_free(m_str);
		mark+= _(" words:\n");
	}
	int j;
	for (j=0;j<count-1;j++)
	{
		mark += "<b><big>";
		m_str = g_markup_escape_text(ppOriginWord[j],-1);
		mark += m_str;
		g_free(m_str);
		mark += "</big></b> ";
	}
	mark += "<b><big>";
	m_str = g_markup_escape_text(ppOriginWord[count-1],-1);
	mark += m_str;
	g_free(m_str);
	mark += "</big></b>";
	
	gchar *p;
	glong data_size,sec_size;
	for (j=0;j<count;j++)
	{
		mark += "\n\n<span foreground=\"red\">#----- ";
		m_str = g_markup_escape_text(ppOriginWord[j],-1);
		mark += m_str;
		g_free(m_str);
		mark += " -----#</span>";
		
		for (int i=0;i< gpAppFrame->oAppCore.oLibs.total_libs();i++)
		{
			if (pppWord[j][i]) {
				mark += "\n<span foreground=\"blue\">*--- ";
				m_str = g_markup_escape_text(gpAppFrame->oAppCore.oLibs.GetBookname(i),-1);
				mark += m_str;
				g_free(m_str);
				mark += " ---*</span>";
				
				if (strcmp(ppOriginWord[j],pppWord[j][i])) {
					mark +=	"\n<span foreground=\"purple\">";
					m_str = g_markup_escape_text(pppWord[j][i],-1);
					mark += m_str;
					g_free(m_str);
					mark += "</span>";
				}
			}
			if (pppWordData[j][i]) {			
				memcpy(&data_size,pppWordData[j][i],sizeof(glong));
				p=pppWordData[j][i]+sizeof(glong);
				
				while (p - (pppWordData[j][i] + sizeof(glong))< data_size)
				{
					switch (*p)
					{
						case 'm':
						case 'o': //need more work...
							sec_size = strlen(p+sizeof(gchar));
							if (sec_size) {
								mark+= "\n";
								m_str = g_markup_escape_text(p+sizeof(gchar),sec_size);
								mark += m_str;
								g_free(m_str);
							}
							sec_size++;
							break;
						case 't':
							sec_size = strlen(p+sizeof(gchar));
							if (sec_size) {
								mark += "\n<big>[";
								m_str = g_markup_escape_text(p+sizeof(gchar),sec_size);
								mark += m_str;
								g_free(m_str);
								mark+= "]</big>";
							}
							sec_size++;
							break;
						case 'y':
							sec_size = strlen(p+sizeof(gchar));
							if (sec_size) {
								mark += "\n<span foreground=\"red\">[";
								m_str = g_markup_escape_text(p+sizeof(gchar),sec_size);
								mark += m_str;
								g_free(m_str);
								mark+= "]</span>";
							}
							sec_size++;						
							break;
						case 'W':
							memcpy(&sec_size,p+sizeof(gchar),sizeof(glong));
							//enbale sound button.
							sec_size+= sizeof(glong);
							break;
						case 'P':
							memcpy(&sec_size,p+sizeof(gchar),sizeof(glong));
							sec_size+= sizeof(glong);
							break;						
					}								
					p = p+sizeof(gchar)+sec_size;
				}				
			}		
		}		
	}		
	SetText(mark.c_str());
	gboolean canRead = gpAppFrame->oReadWord.canRead(sOriginWord);
	if (canRead)
		PronounceWord = sOriginWord;
	gtk_widget_set_sensitive(PronounceWordButton, canRead);

	Popup(false);
	
	if (canRead && pronounce_when_popup)
		gpAppFrame->oReadWord.read(PronounceWord.c_str());
}

void FloatWin::ShowNotFound(const char* sWord,const char* sReason, gboolean fuzzy)
{
	QueryingWord = sWord;
	if (fuzzy)
		found_result = FLOAT_WIN_FUZZY_NOT_FOUND;
	else
		found_result = FLOAT_WIN_NOT_FOUND;
	gchar *text;
	gchar *m_word,*m_reason;
	m_word = g_markup_escape_text(sWord,-1);
	m_reason = g_markup_escape_text(sReason,-1);
	text = g_strdup_printf("<b><big>%s</big></b>\n<span foreground=\"blue\">%s</span>",m_word,m_reason);
	SetText(text);
	
	gboolean canRead = gpAppFrame->oReadWord.canRead(sWord);
	if (canRead)
		PronounceWord = sWord;
	gtk_widget_set_sensitive(PronounceWordButton, canRead);

	if (fuzzy)
		Popup(false);
	else
		Popup(true);
	g_free(text);
	g_free(m_word);
	g_free(m_reason);

	if (canRead && pronounce_when_popup)
		gpAppFrame->oReadWord.read(PronounceWord.c_str());
}

void FloatWin::SetText(const gchar *text)
{	
	gtk_adjustment_set_value(gtk_scrolled_window_get_vadjustment (GTK_SCROLLED_WINDOW(scrolled_window)), 0);

	gtk_label_set_markup(GTK_LABEL(label), ""); // this should speed up the next two line.
	gtk_widget_set_size_request(label, -1, -1);         // so Popup()'s gtk_widget_size_request(label,&requisition); can
	gtk_label_set_line_wrap (GTK_LABEL (label), false); // get its original width.
	gtk_label_set_markup(GTK_LABEL(label),text);
}

void FloatWin::Popup(gboolean updatePosition)
{
	ismoving = true;

	GtkRequisition requisition;
	gtk_widget_size_request(label,&requisition);
	if (requisition.width > Window_max_width) {
		gtk_widget_set_size_request(label, Window_max_width, -1); // it is not really max window width setting.
		gtk_label_set_line_wrap (GTK_LABEL (label), true);		
		gtk_widget_size_request(label,&requisition); //update requisition.
	}
	gint window_width,window_height;
	window_width = 2*(FLOATWIN_BORDER_WIDTH+2) + requisition.width; // 2 is the frame 's width.or get it by gtk function? i am lazy,hoho
	if (requisition.height > Window_max_height) {
		static gint vscrollbar_width = 0;
		if (!vscrollbar_width) {
			if (GTK_SCROLLED_WINDOW(scrolled_window)->vscrollbar) {
				GtkRequisition vscrollbar_requisition;
				gtk_widget_size_request(GTK_SCROLLED_WINDOW(scrolled_window)->vscrollbar,&vscrollbar_requisition);				
				vscrollbar_width = vscrollbar_requisition.width;
				gint scrollbar_spacing;
				gtk_widget_style_get (GTK_WIDGET (scrolled_window), "scrollbar_spacing", &scrollbar_spacing, NULL);
				vscrollbar_width += scrollbar_spacing;
			}
		}
		gtk_widget_set_size_request(scrolled_window, requisition.width + vscrollbar_width, Window_max_height);
		window_height = 2*(FLOATWIN_BORDER_WIDTH+2) + Window_max_height;
		window_width += vscrollbar_width;
	}
	else {
		gtk_widget_set_size_request(scrolled_window, requisition.width, requisition.height);
		window_height = 2*(FLOATWIN_BORDER_WIDTH+2) + requisition.height;
	}
		
	gboolean button_hbox_visible = GTK_WIDGET_VISIBLE(button_hbox);
	if (button_hbox_visible) {
		window_height += (button_hbox->allocation).height;
		if (window_width < (button_hbox->allocation).width + 2*(FLOATWIN_BORDER_WIDTH+2))
			window_width = (button_hbox->allocation).width + 2*(FLOATWIN_BORDER_WIDTH+2);
	}	

	if (bIsLocked) {
		gtk_window_resize(GTK_WINDOW(FloatWindow),window_width,window_height);
		now_window_width = window_width;
		now_window_height = window_height;
		
		// need to make window 's resize relate to other corner?
		Show();
	}
	else
	{
		gint iCurrentX,iCurrentY;
		GdkScreen *screen = gtk_window_get_screen(GTK_WINDOW(FloatWindow));
		if ((!GTK_WIDGET_VISIBLE(FloatWindow)) || updatePosition) {
			button_box_once_shown = false;
			GdkDisplay *display = gdk_screen_get_display(screen);
			
			GdkModifierType mask;
			gdk_display_get_pointer(display,NULL,&iCurrentX,&iCurrentY, &mask);
			
			gboolean pressed = false;
			switch (gpAppFrame->oAppCore.oSelection.scan_modifier_key) {
#ifdef _WIN32
				case 0:
					if (mask & GDK_SHIFT_MASK)
						pressed = true;
				case 1:
					if (mask & GDK_MOD1_MASK)
						pressed = true;
					break;
				default:
					if (mask & GDK_CONTROL_MASK)
						pressed = true;
					break;
#else
				case 0:
					if (mask & GDK_MOD4_MASK)
						pressed = true;
					break;
				case 1:
					if (mask & GDK_SHIFT_MASK)
						pressed = true;
					break;
				case 2:
					if (mask & GDK_MOD1_MASK)
						pressed = true;
					break;
				default:
					if (mask & GDK_CONTROL_MASK)
						pressed = true;
					break;
#endif					
			}
			if (pressed) {
				popup_pointer_x = iCurrentX;
				popup_pointer_y = iCurrentY;
			}
			else {
				// popup by middle click on the notification area icon, 
				//so never hiden the floating window even mouse didn't moved as in FloatWin::vTimeOutCallback().
				popup_pointer_x = -1;
				popup_pointer_y = -1;
			}
				
			iCurrentX += FLOATWIN_OFFSET_X;
			iCurrentY += FLOATWIN_OFFSET_Y;
		}
		else {
			gtk_window_get_position(GTK_WINDOW(FloatWindow),&iCurrentX,&iCurrentY);
		}
		gint screen_width = gdk_screen_get_width(screen);
		gint screen_height = gdk_screen_get_height(screen);		
		if (iCurrentX + window_width > screen_width)
			iCurrentX = screen_width - window_width;
		if (iCurrentY + window_height > screen_height)
			iCurrentY = screen_height - window_height;		
		// don't use gdk_window_resize,it make the window can't be smaller latter!
		/*if (FloatWindow->window) {
			gdk_window_move_resize(FloatWindow->window, iCurrentX, iCurrentY, window_width, window_height);			
		}
		else {
			gtk_window_move(GTK_WINDOW(FloatWindow),iCurrentX,iCurrentY);			
			gtk_window_resize(GTK_WINDOW(FloatWindow),window_width,window_height);
		}*/
					
		//note: must do resize before move should be better,as the vTimeOutCallback() may hide it.
		gtk_window_resize(GTK_WINDOW(FloatWindow),window_width,window_height);
		gtk_window_move(GTK_WINDOW(FloatWindow),iCurrentX,iCurrentY);
		//gtk_decorated_window_move_resize_window(GTK_WINDOW(FloatWindow), iCurrentX, iCurrentY, window_width, window_height);
		now_window_width = window_width;
		now_window_height = window_height;
		
		Show();
	}	
	ismoving = false;	
}

void FloatWin::Show()
{
	gtk_widget_show(FloatWindow);
	if (!timeout)
		timeout = gtk_timeout_add(FLOAT_TIMEOUT,vTimeOutCallback,this);
}

void FloatWin::Hide()
{
	if (timeout) {
		gtk_timeout_remove(timeout);
		timeout = 0;
	}
	button_box_once_shown = false;
	gtk_widget_hide(FloatWindow);
}

gint FloatWin::vTimeOutCallback(gpointer data)
{
	FloatWin *oFloatWin = (FloatWin *)data;
	
    if((!oFloatWin->bIsLocked) && (!oFloatWin->ismoving) && (GTK_WIDGET_VISIBLE(oFloatWin->FloatWindow)))
    {
		GdkScreen *screen = gtk_window_get_screen(GTK_WINDOW(oFloatWin->FloatWindow));
		GdkDisplay *display = gdk_screen_get_display(screen);

		gint iCurrentX,iCurrentY;
		GdkModifierType mask;
		gdk_display_get_pointer(display,NULL,&iCurrentX,&iCurrentY, &mask);

		if (gpAppFrame->oAppCore.oSelection.only_scan_while_modifier_key && oFloatWin->hide_floatwin_when_modifier_key_released) {
			if (iCurrentX == oFloatWin->popup_pointer_x && iCurrentY==oFloatWin->popup_pointer_y) {
				gboolean released = false;
				switch (gpAppFrame->oAppCore.oSelection.scan_modifier_key) {
#ifdef _WIN32
					case 0:
						if (!(mask & GDK_SHIFT_MASK))
							released = true;
						break;
					case 1:
						if (!(mask & GDK_MOD1_MASK))
							released = true;
						break;
					default:
						if (!(mask & GDK_CONTROL_MASK))
							released = true;
						break;
#else
					case 0:
						if (!(mask & GDK_MOD4_MASK))
							released = true;
						break;
					case 1:
						if (!(mask & GDK_SHIFT_MASK))
							released = true;
						break;
					case 2:
						if (!(mask & GDK_MOD1_MASK))
							released = true;
						break;
					default:
						if (!(mask & GDK_CONTROL_MASK))
							released = true;
						break;
#endif
				}
				if (released) {
					oFloatWin->Hide();
					gpAppFrame->oAppCore.oSelection.LastClipWord.clear(); //so press modifier key again will pop up the floatwin.
					return true;
				}
			}
		}
		
    	int distance;
    	gint window_x,window_y,window_width,window_height;
    	gtk_window_get_position(GTK_WINDOW(oFloatWin->FloatWindow),&window_x,&window_y);
		//notice: gtk_window_get_size() is not really uptodate,don't use it! see "gtk reference".
		//gtk_window_get_size(GTK_WINDOW(oFloatWin->FloatWindow),&window_width,&window_height);
		window_width = oFloatWin->now_window_width;
		window_height = oFloatWin->now_window_height;
		
		if ( iCurrentX < window_x )
		{
			distance = (iCurrentX-window_x)*(iCurrentX-window_x);
			if ( iCurrentY < window_y )
				distance += (iCurrentY-window_y)*(iCurrentY-window_y);
			else if ( iCurrentY > window_y+window_height )
				distance += (iCurrentY-window_y-window_height)*(iCurrentY-window_y-window_height);
		}
		else if ( iCurrentX > window_x+window_width )
		{
			distance = (iCurrentX-window_x-window_width)*(iCurrentX-window_x-window_width);
			if ( iCurrentY < window_y )
				distance += (iCurrentY-window_y)*(iCurrentY-window_y);
			else if ( iCurrentY > window_y+window_height )
				distance += (iCurrentY-window_y-window_height)*(iCurrentY-window_y-window_height);
		}
		else
		{
			if ( iCurrentY < window_y )
				distance = (window_y - iCurrentY)*(window_y - iCurrentY);
			else if ( iCurrentY > window_y+window_height )
				distance = (iCurrentY-window_y-window_height)*(iCurrentY-window_y-window_height);
			else
				distance = 0; //in the floating window.
		}
		if ( distance > DISAPPEAR_DISTANCE )
		{
			oFloatWin->Hide();
		}
    } // to be hidden

    /*if ( (bIsSavedWordItemValid||bIsSavedMessageValid)
          && !bIsLocked && !bInMoving )
    {
        int iCurrentShowStates = iGetShowLevel();
        if ( bIsSavedMessageValid && iCurrentShowStates!=FLOAT_SHOW_LEVEL_NONE)
            iCurrentShowStates = FLOAT_SHOW_LEVEL_ALL;
        if ( iCurrentShowStates==FLOAT_SHOW_LEVEL_NONE && bMapped && bHaveScrollBar && wCurrentChildWindow==wForm->window )
        {
            if ( iCurrentX<=window_x+iScrollBarWidth || (buttons&Button1Mask)==Button1Mask )
                iCurrentShowStates = iSavedShowStates;
        }
        if ( iCurrentShowStates != iSavedShowStates )
        {
            vPopdown();
            if ( iCurrentShowStates != FLOAT_SHOW_LEVEL_NONE )
            {
                if ( bIsSavedWordItemValid )
                {
                    XmString * pxmsMessage = gpAppFrame->oAppCore->oWordsToShow(oSavedWordItem,False,iCurrentShowStates==FLOAT_SHOW_LEVEL_ONLYFIRST);
                    XtVaSetValues(wLabel,XmNlabelString,*pxmsMessage,NULL);
                    XmStringFree(*pxmsMessage);
                    delete pxmsMessage;
                }
                if ( bIsSavedMessageValid )
                {
                    //XtVaSetValues(wLabel,XmNlabelString,xmsSavedMessage,NULL); 
                }
                vPopup();
            }
            iSavedShowStates = iCurrentShowStates;
        }
    }*/

	return true;
}

gboolean FloatWin::vEnterNotifyCallback (GtkWidget *widget, GdkEventCrossing *event, FloatWin *oFloatWin)
{	
	/*g_print("enter ");
	switch (event->detail)
	{
		case GDK_NOTIFY_ANCESTOR:
			g_print("GDK_NOTIFY_ANCESTOR\n");
			break;
		case GDK_NOTIFY_VIRTUAL:
			g_print("GDK_NOTIFY_VIRTUAL\n");
			break;
		case GDK_NOTIFY_NONLINEAR:
			g_print("GDK_NOTIFY_NONLINEAR\n");
			break;
		case GDK_NOTIFY_NONLINEAR_VIRTUAL:
			g_print("GDK_NOTIFY_NONLINEAR_VIRTUAL\n");
			break;		
		case GDK_NOTIFY_UNKNOWN:
			g_print("GDK_NOTIFY_UNKNOWN\n");
			break;
		case GDK_NOTIFY_INFERIOR:
			g_print("GDK_NOTIFY_INFERIOR\n");
			break;
	}*/
	
	if ((event->detail==GDK_NOTIFY_NONLINEAR) || (event->detail==GDK_NOTIFY_NONLINEAR_VIRTUAL)) {
		if (!GTK_WIDGET_VISIBLE(oFloatWin->button_hbox)) {
			gtk_widget_show(oFloatWin->button_hbox);
		
			if (!oFloatWin->button_box_once_shown) {
				oFloatWin->button_box_once_shown = true;

				gint iCurrentX,iCurrentY;
				gtk_window_get_position(GTK_WINDOW(oFloatWin->FloatWindow),&iCurrentX,&iCurrentY);
				GdkScreen *screen = gtk_window_get_screen(GTK_WINDOW(oFloatWin->FloatWindow));
				gint screen_width = gdk_screen_get_width(screen);
				gint screen_height = gdk_screen_get_height(screen);					
				GtkRequisition requisition;
				gtk_widget_size_request(oFloatWin->button_hbox,&requisition);
				oFloatWin->now_window_height += requisition.height;
				requisition.width += 2*(FLOATWIN_BORDER_WIDTH+2);
				if (requisition.width > oFloatWin->now_window_width)
					oFloatWin->now_window_width = requisition.width;
				gboolean changed=false;		
				if (iCurrentX < 0) {
					iCurrentX = 0;
					changed = true;
				}
				else {
					if (iCurrentX + oFloatWin->now_window_width > screen_width) {
						iCurrentX = screen_width - oFloatWin->now_window_width;
						changed = true;
					}
				}
				if (iCurrentY < 0) {
					iCurrentY = 0;
					changed = true;
				}
				else {
					if (iCurrentY + oFloatWin->now_window_height > screen_height) {
						iCurrentY = screen_height - oFloatWin->now_window_height;	
						changed = true;			
					}			
				}
				if (changed)
					gtk_window_move(GTK_WINDOW(oFloatWin->FloatWindow),iCurrentX,iCurrentY);				
			}
		}
	}
	return true;
}

gboolean FloatWin::vLeaveNotifyCallback (GtkWidget *widget, GdkEventCrossing *event, FloatWin *oFloatWin)
{
	/*g_print("leave ");
	switch (event->detail)
	{
		case GDK_NOTIFY_ANCESTOR:
			g_print("GDK_NOTIFY_ANCESTOR\n");
			break;
		case GDK_NOTIFY_VIRTUAL:
			g_print("GDK_NOTIFY_VIRTUAL\n");
			break;
		case GDK_NOTIFY_NONLINEAR:
			g_print("GDK_NOTIFY_NONLINEAR\n");
			break;
		case GDK_NOTIFY_NONLINEAR_VIRTUAL:
			g_print("GDK_NOTIFY_NONLINEAR_VIRTUAL\n");
			break;		
		case GDK_NOTIFY_UNKNOWN:
			g_print("GDK_NOTIFY_UNKNOWN\n");
			break;
		case GDK_NOTIFY_INFERIOR:
			g_print("GDK_NOTIFY_INFERIOR\n");
			break;
	}*/
	if (((event->detail==GDK_NOTIFY_NONLINEAR) || (event->detail==GDK_NOTIFY_NONLINEAR_VIRTUAL))&&(!oFloatWin->ismoving)) {
		gtk_widget_hide(oFloatWin->button_hbox);
	}
	return true;
}

void FloatWin::on_menu_copy_activate(GtkWidget * widget, FloatWin *oFloatWin)
{
	oFloatWin->on_copy_click(widget, NULL);
}

void FloatWin::on_menu_query_activate(GtkWidget * widget, FloatWin *oFloatWin)
{
	oFloatWin->on_query_click(widget, NULL);
}

void FloatWin::on_menu_play_activate(GtkWidget * widget, FloatWin *oFloatWin)
{
	oFloatWin->on_play_click(widget, oFloatWin);
}

void FloatWin::on_menu_fuzzyquery_activate(GtkWidget * widget, FloatWin *oFloatWin)
{
	gpAppFrame->oAppCore.LookupWithFuzzyToFloatWin(oFloatWin->QueryingWord.c_str());
}

gboolean FloatWin::vButtonPressCallback (GtkWidget * widget, GdkEventButton * event , FloatWin *oFloatWin)
{
	if (event->type == GDK_BUTTON_PRESS) {
		if (event->button == 1) {
			gtk_window_get_position(GTK_WINDOW(widget),&(oFloatWin->press_window_x),&(oFloatWin->press_window_y));
			oFloatWin->press_x_root = (gint)(event->x_root);
			oFloatWin->press_y_root = (gint)(event->y_root);
			oFloatWin->ismoving = true;
		}
		else if (event->button == 3) {			
			if (oFloatWin->menu)
				gtk_widget_destroy(oFloatWin->menu);
			
			oFloatWin->menu = gtk_menu_new();

			GtkWidget *menuitem;
			menuitem = gtk_image_menu_item_new_with_mnemonic(_("_Copy"));
			GtkWidget *image;
			image = gtk_image_new_from_stock(GTK_STOCK_COPY, GTK_ICON_SIZE_MENU);
			gtk_image_menu_item_set_image(GTK_IMAGE_MENU_ITEM(menuitem), image);
			g_signal_connect(G_OBJECT(menuitem), "activate", G_CALLBACK(on_menu_copy_activate), oFloatWin);
			gtk_menu_shell_append(GTK_MENU_SHELL(oFloatWin->menu), menuitem);

			menuitem = gtk_image_menu_item_new_with_mnemonic(_("_Query"));
			image = gtk_image_new_from_stock(GTK_STOCK_FIND, GTK_ICON_SIZE_MENU);
			gtk_image_menu_item_set_image(GTK_IMAGE_MENU_ITEM(menuitem), image);
			g_signal_connect(G_OBJECT(menuitem), "activate", G_CALLBACK(on_menu_query_activate), oFloatWin);
			gtk_menu_shell_append(GTK_MENU_SHELL(oFloatWin->menu), menuitem);

			if (GTK_WIDGET_SENSITIVE(oFloatWin->PronounceWordButton)) {
				menuitem = gtk_image_menu_item_new_with_mnemonic(_("_Play"));
				image = gtk_image_new_from_stock(GTK_STOCK_EXECUTE, GTK_ICON_SIZE_MENU);
				gtk_image_menu_item_set_image(GTK_IMAGE_MENU_ITEM(menuitem), image);
				g_signal_connect(G_OBJECT(menuitem), "activate", G_CALLBACK(on_menu_play_activate), oFloatWin);
				gtk_menu_shell_append(GTK_MENU_SHELL(oFloatWin->menu), menuitem);
			}

			if ((oFloatWin->found_result != FLOAT_WIN_FUZZY_FOUND) && (oFloatWin->found_result != FLOAT_WIN_FUZZY_NOT_FOUND)) {
				menuitem = gtk_image_menu_item_new_with_mnemonic(_("_Fuzzy Query"));
				image = gtk_image_new_from_stock(GTK_STOCK_FIND_AND_REPLACE, GTK_ICON_SIZE_MENU);
				gtk_image_menu_item_set_image(GTK_IMAGE_MENU_ITEM(menuitem), image);
				g_signal_connect(G_OBJECT(menuitem), "activate", G_CALLBACK(on_menu_fuzzyquery_activate), oFloatWin);
				gtk_menu_shell_append(GTK_MENU_SHELL(oFloatWin->menu), menuitem);
			}			
			
			gtk_widget_show_all(oFloatWin->menu);
			gtk_menu_popup(GTK_MENU(oFloatWin->menu), NULL, NULL, NULL, NULL, event->button, event->time);
			if (gpAppFrame->enable_sound_event) {
#ifdef _WIN32
				gchar *filename = g_build_filename(stardict_data_dir, "sounds", "menushow.wav", NULL);
				PlaySound(filename, 0, SND_ASYNC | SND_FILENAME);
				g_free(filename);
#else
				gnome_sound_play(STARDICT_DATA_DIR "/sounds/menushow.wav");
#endif
			}
		}
		/*else if (event->button == 2) {
			gint start,end;
			if (gtk_label_get_selection_bounds(GTK_LABEL(label), &start, &end)) {
				const gchar *text = gtk_label_get_text(GTK_LABEL(label));
				gchar *a,*b;
				a = g_utf8_offset_to_pointer(text,start);
				b = g_utf8_offset_to_pointer(text,end);				
				gchar *word = g_strndup(a,b-a);
				gpAppFrame->oAppCore.SimpleLookupToFloat(word,true);
				g_free(word);
			}
		}*/
			
	}
	else if (event->type == GDK_2BUTTON_PRESS) {
		if (oFloatWin->found_result == FLOAT_WIN_NOT_FOUND) {
			gpAppFrame->oAppCore.LookupWithFuzzyToFloatWin(oFloatWin->QueryingWord.c_str());
		}
		else {
			oFloatWin->Hide();
		}
	}

	return true;
}

gboolean FloatWin::vButtonReleaseCallback (GtkWidget * widget, GdkEventButton * event , FloatWin *oFloatWin)
{
	if (event->button == 1) {
		oFloatWin->ismoving = false;
	}
	else if (event->button==3) {
			//gpAppFrame->oAppCore->Popup();
	}

	return true;
}

gboolean FloatWin::vMotionNotifyCallback (GtkWidget * widget, GdkEventMotion * event , FloatWin *oFloatWin)
{
	if (event->window == oFloatWin->FloatWindow->window || (event->state & GDK_BUTTON1_MASK))
	{
		gint x,y;
		x = oFloatWin->press_window_x + (gint)(event->x_root) - oFloatWin->press_x_root;
		y = oFloatWin->press_window_y + (gint)(event->y_root) - oFloatWin->press_y_root;
		if (x<0)
			x = 0;
		if (y<0)
			y = 0;
		gtk_window_move(GTK_WINDOW(oFloatWin->FloatWindow), x, y);
	}		

	return true;
}

void FloatWin::on_query_click(GtkWidget *widget, gpointer data)
{
	if (gpAppFrame->enable_sound_event) {
#ifdef _WIN32
		gchar *filename = g_build_filename(stardict_data_dir, "sounds", "buttonactive.wav", NULL);
		PlaySound(filename, 0, SND_ASYNC | SND_FILENAME);
		g_free(filename);
#else
		gnome_sound_play(STARDICT_DATA_DIR "/sounds/buttonactive.wav");
#endif
	}
	if (!gpAppFrame->oAppCore.oFloatWin.bIsLocked)
		gpAppFrame->oAppCore.oFloatWin.Hide();
	gpAppFrame->oAppCore.Query(gpAppFrame->oAppCore.oFloatWin.QueryingWord.c_str());	
#ifdef _WIN32
	if (!GTK_WIDGET_VISIBLE(gpAppFrame->oAppCore.window))
		gpAppFrame->oAppCore.oDockLet.stardict_systray_maximize(gpAppFrame->oAppCore.window);
#endif
	gtk_window_present(GTK_WINDOW(gpAppFrame->oAppCore.window));
}

void FloatWin::on_copy_click(GtkWidget *widget, gpointer data)
{
	if (gpAppFrame->enable_sound_event) {
#ifdef _WIN32
		gchar *filename = g_build_filename(stardict_data_dir, "sounds", "buttonactive.wav", NULL);
		PlaySound(filename, 0, SND_ASYNC | SND_FILENAME);
		g_free(filename);
#else
		gnome_sound_play(STARDICT_DATA_DIR "/sounds/buttonactive.wav");
#endif
	}
	const gchar *text = gtk_label_get_text(GTK_LABEL(gpAppFrame->oAppCore.oFloatWin.label));
	GtkClipboard* clipboard = gtk_clipboard_get(GDK_SELECTION_CLIPBOARD);
	gtk_clipboard_set_text(clipboard,text,-1);
}

void FloatWin::on_play_click(GtkWidget *widget, FloatWin *oFloatWin)
{
	gpAppFrame->oReadWord.read(oFloatWin->PronounceWord.c_str());
}

void FloatWin::on_stop_click(GtkWidget *widget, gpointer data)
{
	if (gpAppFrame->enable_sound_event) {
#ifdef _WIN32
		gchar *filename = g_build_filename(stardict_data_dir, "sounds", "buttonactive.wav", NULL);
		PlaySound(filename, 0, SND_ASYNC | SND_FILENAME);
		g_free(filename);
#else
		gnome_sound_play(STARDICT_DATA_DIR "/sounds/buttonactive.wav");
#endif
	}
#ifdef _WIN32
	rw_cfg_write_boolean (usercfgfile, "preferences/dictionary", "scan_selection", false);
	on_conf_dictionary_scan_selection_changed(false);
#else
	gpAppFrame->oAppConf.write_bool("/apps/stardict/preferences/dictionary/scan_selection", false);
#endif
}

void FloatWin::on_help_click(GtkWidget *widget, gpointer data)
{
	if (gpAppFrame->enable_sound_event) {
#ifdef _WIN32
		gchar *filename = g_build_filename(stardict_data_dir, "sounds", "buttonactive.wav", NULL);
		PlaySound(filename, 0, SND_ASYNC | SND_FILENAME);
		g_free(filename);
#else
		gnome_sound_play(STARDICT_DATA_DIR "/sounds/buttonactive.wav");
#endif
	}
	if (!gpAppFrame->oAppCore.oFloatWin.bIsLocked)
		gpAppFrame->oAppCore.oFloatWin.Hide();
#ifdef _WIN32
	//gchar *filename = g_strdup_printf(_("file:///%s/help/C/stardict.html#stardict-scan-selection"), stardict_data_dir);
	gchar *filename = g_strdup_printf(_("file:///%s/help/C/stardict.html"), stardict_data_dir);
	ShellExecute((HWND)(GDK_WINDOW_HWND(gpAppFrame->oAppCore.window->window)), "OPEN", filename, NULL, NULL, SW_SHOWNORMAL);
	g_free(filename);
#else
	gnome_help_display ("stardict.xml", "stardict-scan-selection", NULL);
#endif
}

void FloatWin::on_quit_click(GtkWidget *widget, gpointer data)
{
	if (gpAppFrame->enable_sound_event) {
#ifdef _WIN32
		gchar *filename = g_build_filename(stardict_data_dir, "sounds", "buttonactive.wav", NULL);
		PlaySound(filename, 0, SND_ASYNC | SND_FILENAME);
		g_free(filename);
#else
		gnome_sound_play(STARDICT_DATA_DIR "/sounds/buttonactive.wav");
#endif
	}
	gpAppFrame->Quit();
}

void FloatWin::vLockCallback(GtkWidget *widget, FloatWin *oFloatWin)
{
	if (gpAppFrame->enable_sound_event) {
#ifdef _WIN32
		gchar *filename = g_build_filename(stardict_data_dir, "sounds", "buttonactive.wav", NULL);
		PlaySound(filename, 0, SND_ASYNC | SND_FILENAME);
		g_free(filename);
#else
		gnome_sound_play(STARDICT_DATA_DIR "/sounds/buttonactive.wav");
#endif
	}
#ifdef _WIN32
	rw_cfg_write_boolean (usercfgfile, "preferences/floating_window", "lock", !(oFloatWin->bIsLocked));
	on_conf_floatwin_lock_changed(!(oFloatWin->bIsLocked));
#else
	gpAppFrame->oAppConf.write_bool("/apps/stardict/preferences/floating_window/lock", !(oFloatWin->bIsLocked));
#endif
}
