/* @(#)sprintf.c	1.14 03/06/15 Copyright 1985, 1988-2003 J. Schilling */
/*
 *	Copyright (c) 1985, 1988-2003 J. Schilling
 */
/*
 * Copyright Jrg Schilling. All rights reserved.
 *
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License, Version 1.0 only.
 * See the file CDDL.Schily.txt in this distribution or
 * http://opensource.org/licenses/cddl1.php for details.
 */

#include <mconfig.h>
#include <vadefs.h>
#include <standard.h>
#include <schily.h>

/*
 * Do not include stdio.h, BSD systems define sprintf the wrong way!
 */
EXPORT	int sprintf __PR((char *, const char *, ...));

#ifdef	PROTOTYPES
static void _cput(char c, long ba)
#else
static void _cput(c, ba)
	char	c;
	long	ba;
#endif
{
	*(*(char **) ba)++ = c;
}

/* VARARGS2 */
#ifdef	PROTOTYPES
EXPORT int
sprintf(char *buf, const char *form, ...)
#else
EXPORT int
sprintf(buf, form, va_alist)
	char	*buf;
	char	*form;
	va_dcl
#endif
{
	va_list	args;
	int	cnt;
	char	*bp = buf;

#ifdef	PROTOTYPES
	va_start(args, form);
#else
	va_start(args);
#endif
	cnt = format(_cput, (long)&bp, form,  args);
	va_end(args);
	*bp = '\0';

	return (cnt);
}
