/* @(#)deflts.h	1.6 02/08/26 Copyright 1997 J. Schilling */
/*
 *	Definitions for reading program defaults.
 *
 *	Copyright (c) 1997 J. Schilling
 */
/*
 * Copyright Jrg Schilling. All rights reserved.
 *
 * The contents of this file are subject to the terms of the
 * Common Development and Distribution License, Version 1.0 only.
 * See the file CDDL.Schily.txt in this distribution or
 * http://opensource.org/licenses/cddl1.php for details.
 */

#ifndef	_DEFLTS_H
#define	_DEFLTS_H

#ifndef _MCONFIG_H
#include <mconfig.h>
#endif
#ifndef _PROTOTYP_H
#include <prototyp.h>
#endif

#ifdef	__cplusplus
extern "C" {
#endif

#define	DEFLT	"/etc/default"

/*
 * cmd's to defltcntl()
 */
#define	DC_GETFLAGS	0	/* Get actual flags	*/
#define	DC_SETFLAGS	1	/* Set new flags	*/

/*
 * flags to defltcntl()
 *
 * Make sure that when adding features, the default behaviour
 * is the same as old behaviour.
 */
#define	DC_CASE		0x0001	/* Don't ignore case	*/

#define	DC_STD		DC_CASE	/* Default flags	*/

/*
 * Macros to handle flags
 */
#ifndef	TURNON
#define	TURNON(flags, mask)	flags |= mask
#define	TURNOFF(flags, mask)	flags &= ~(mask)
#define	ISON(flags, mask)	(((flags) & (mask)) == (mask))
#define	ISOFF(flags, mask)	(((flags) & (mask)) != (mask))
#endif

extern	int	defltopen	__PR((const char *name));
extern	int	defltclose	__PR((void));
extern	void	defltfirst	__PR((void));
extern	char	*defltread	__PR((const char *name));
extern	char	*defltnext	__PR((const char *name));
extern	int	defltcntl	__PR((int cmd, int flags));

#ifdef	__cplusplus
}
#endif

#endif	/* _DEFLTS_H */
