/* @(#)table.c	1.10 01/10/29 Copyright 1994 J. Schilling */
#ifndef lint
static	char sccsid[] =
	"@(#)table.c	1.10 01/10/29 Copyright 1994 J. Schilling";
#endif
/*
 *	Conversion tables for efficient conversion
 *	of different file type representations
 *
 *	Copyright (c) 1994 J. Schilling
 */
/*
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2, or (at your option)
 * any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; see the file COPYING.  If not, write to
 * the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 */

#include <mconfig.h>
#include "star.h"
#include "table.h"
#include <statdefs.h>

#ifndef	S_IFIFO			/* If system knows no fifo's		*/
#define	S_IFIFO		S_IFREG	/* Map fifo's to regular files 		*/
#endif
#ifndef	S_IFCHR			/* If system knows no character special	*/
#define	S_IFCHR		S_IFREG	/* Map character spec. to regular files	*/
#endif
#ifndef	S_IFMPC			/* If system knows no multiplexed c	*/
#define	S_IFMPC		S_IFREG	/* Map multiplexed c to regular files	*/
#endif
#ifndef	S_IFNAM			/* If system knows no named files	*/
#define	S_IFNAM		S_IFREG	/* Map named files to regular files 	*/
#endif
#ifndef	S_IFBLK			/* If system knows no block special	*/
#define	S_IFBLK		S_IFREG	/* Map block spec. to regular files	*/
#endif
#ifndef	S_IFMPB			/* If system knows no multiplexed b	*/
#define	S_IFMPB		S_IFREG	/* Map multiplexed b to regular files	*/
#endif
#ifndef	S_IFCNT			/* If system knows no contiguous files	*/
#define	S_IFCNT		S_IFREG	/* Map contiguous file to regular files */
#endif
#ifndef	S_IFLNK			/* If system knows no symbolic links	*/
#define	S_IFLNK		S_IFREG	/* Map symbolic links to regular files */
#endif
#ifndef	S_IFSOCK		/* If system knows no fifo's		*/
#define	S_IFSOCK	S_IFREG	/* Map fifo's to regular files 		*/
#endif
#ifndef	S_IFDOOR		/* If system knows no door's		*/
#define	S_IFDOOR	S_IFREG	/* Map door's to regular files		*/
#endif
#ifndef	S_IFEVC			/* If system knows no eventcount's	*/
#define	S_IFEVC		S_IFREG	/* Map eventcount's to regular files	*/
#endif
#define	S_IFBAD	S_IFMT		/* XXX Have to use another val if someone */
				/* XXX starts to use S_IFMT for a */
				/* XXX useful file type */
#define	XT_NAM	XT_BAD		/* XXX JS has not seen it yet */
				/* XXX if we use it, we have to change */
				/* XXX table.h and some of the tables below */

/*
 * UNIX File type to XT_ table
 */
char	iftoxt_tab[] = {			
			XT_NONE, XT_FIFO, XT_CHR,   XT_MPC,
			XT_DIR,  XT_NAM,  XT_BLK,   XT_MPB,
			XT_FILE, XT_CONT, XT_SLINK, XT_BAD,
			XT_SOCK, XT_DOOR,  XT_BAD,   XT_BAD,
			};

/*
 * Ustar File type to XT_ table
 */
char	ustoxt_tab[] = {
			XT_FILE, XT_LINK, XT_SLINK, XT_CHR,
			XT_BLK,  XT_DIR,  XT_FIFO,  XT_CONT,
};

/*
 * Gnutar File type to XT_ table
 */
char	gttoxt_tab[] = {
		/* A */	XT_NONE,     XT_NONE,   XT_NONE,     XT_DUMPDIR,
		/* E */	XT_NONE,     XT_NONE,   XT_NONE,     XT_NONE,
		/* I */	XT_NONE,     XT_NONE,   XT_LONGLINK, XT_LONGNAME,
		/* M */	XT_MULTIVOL, XT_NAMES,  XT_NONE,     XT_NONE,
		/* Q */	XT_NONE,     XT_NONE,   XT_SPARSE,   XT_NONE,
		/* U */	XT_NONE,     XT_VOLHDR, XT_NONE,     XT_NONE,
		/* Y */	XT_NONE,     XT_NONE, 
};

/*
 * XT_ to UNIX File type table
 */
int	xttoif_tab[] = {
			0,       S_IFREG,  S_IFCNT, S_IFREG,
			S_IFLNK, S_IFDIR,  S_IFCHR, S_IFBLK,
			S_IFIFO, S_IFSOCK, S_IFMPC, S_IFMPB,
			S_IFNAM, S_IFNAM,  S_IFDOOR, S_IFEVC,
			S_IFBAD, S_IFBAD,  S_IFBAD, S_IFBAD,
			S_IFDIR, S_IFBAD,  S_IFBAD, S_IFBAD,
			S_IFBAD, S_IFBAD,  S_IFBAD, S_IFBAD,
			S_IFBAD, S_IFBAD,  S_IFBAD, S_IFBAD,
			};

/*
 * XT_ to Star File type table
 */
char	xttost_tab[] = {
		/* 0 */	0,       F_FILE, F_FILE, F_FILE,
		/* 4 */	F_SLINK, F_DIR,  F_SPEC, F_SPEC,
		/* 8 */	F_SPEC,  F_SPEC, F_SPEC, F_SPEC,
		/*12 */	F_SPEC,  F_SPEC, F_SPEC, F_SPEC,
		/*16 */	F_SPEC,  F_SPEC, F_SPEC, F_SPEC,
		/*20 */	F_DIR,   F_FILE, F_FILE, F_FILE,
		/*24 */	F_FILE,  F_FILE, F_SPEC, F_SPEC,
		/*28 */	F_SPEC,  F_SPEC, F_SPEC, F_SPEC,
			};

/*
 * XT_ Old tar supported File type table
 */
char	xttar_tab[] = {
		/* 0 */	0,	1,	1,	1,
		/* 4 */	1,	1,	0,	0,
		/* 8 */	0,	0,	0,	0,
		/*12 */	0,	0,	0,	0,
		/*16 */	0,	0,	0,	0,
		/*20 */	0,	0,	0,	0,
		/*24 */	0,	0,	0,	0,
		/*28 */	0,	0,	0,	0,
			};
/*
 * XT_ Star supported File type table
 */
char	xtstar_tab[] = {
		/* 0 */	0,	1,	1,	1,
		/* 4 */	1,	1,	1,	1,
		/* 8 */	1,	1,	1,	1,
		/*12 */	1,	1,	1,	0,
		/*16 */	0,	0,	0,	0,
		/*20 */	0,	0,	0,	0,
		/*24 */	0,	0,	0,	0,
		/*28 */	0,	0,	0,	0,
			};
/*
 * XT_ Ustar supported File type table
 */
char	xtustar_tab[] = {
		/* 0 */	0,	1,	1,	1,
		/* 4 */	1,	1,	1,	1,
		/* 8 */	1,	0,	0,	0,
		/*12 */	0,	0,	0,	0,
		/*16 */	0,	0,	0,	0,
		/*20 */	0,	0,	0,	0,
		/*24 */	0,	0,	0,	0,
		/*28 */	0,	0,	0,	0,
			};


/*
 * XT_ to Ustar File type table
 *
 * sockets cannot be handled in ansi tar, they are handled as regular files :-(
 */
char	xttous_tab[] = {
			0,       REGTYPE, CONTTYPE, LNKTYPE,
			SYMTYPE, DIRTYPE, CHRTYPE,  BLKTYPE,
			FIFOTYPE,REGTYPE/* socket */, 0/* bad */, 0/* bad */,
			0,       0,       0,        0,
			0,       0,       0,        0,
			LF_DUMPDIR, LF_LONGLINK, LF_LONGNAME, LF_MULTIVOL,
			LF_NAMES,   LF_SPARSE,   LF_VOLHDR,   0,
			0,       0,       0,        0,
			};

/*
 * XT_ to String table
 */
char	*xttostr_tab[] = {
#define	XT_DEBUG
#ifdef	XT_DEBUG
			"U",	"-",	"C",	"H",
#else
			"-",	"-",	"-",	"-",
#endif
			"l",	"d",	"c",	"b",
			"p",	"s",	"~",	"~",
			"~",	"~",	"D",	"~",
			"~",	"~",	"~",	"~",

			"D",	"K",	"L",	"M",
#ifdef	XT_DEBUG
			"N",	"S",	"V",	"~",
#else
			"N",	"-",	"V",	"~",
#endif

			"~",	"~",	"~",	"~",
			};

/*
 * XT_ to named file type text
 */
char	*xttoname_tab[] = {
			"unallocated",	"regular",	"contiguous",		"hardlink",
			"symlink",	"directory",	"character special",	"block special",
			"fifo",		"socket",	"mpx character special","mpx block special",
			"XENIX nsem",	"XENIX nshd",	"door",		        "eventcount",
			"reserved",	"reserved",	"reserved",		"reserved",
			"dumpdir",	"longlink",	"longname",		"multivol cont.",
			"names",	"sparse",	"volheader",		"reserved",
			"reserved",	"reserved",	"reserved",		"unknown/bad",
			};

