# $Id: 1-0-0_1-1-0.py,v 1.1 2001/05/07 20:44:13 fresh Exp $
from Products.UpdateSupport.updatesupport import _updateall,_log
from BTrees.convert import convert
from BTrees.IOBTree import IOBTree

def do_update(self):
    """ Do the update """

    # make properties deletable
    for dict in self._properties:
        if dict['id']!='title':
            dict['mode']='wd'
    self._p_changed = 1
    return_text = _log('','Made Properties Deletable')
        
    # update the main BTree
    threshold=200
    if type(self.data) is not IOBTree:
        data=self.data
        self.data=IOBTree()
        convert(data, self.data, threshold)
    return_text = _log(return_text,'Updated Postings BTree')
 
    # Add the meta_data columns for search results
    for name in ['thread_path','author','date_posted','reply_cnt']:
        try:
            self._catalog.addColumn(name,'')
        except:
            return_text = _log(return_text,'Could not add meta-data column:"%s", it may already exist' % name)
            
    try:
        self._catalog.delColumn('summary')
    except:
        return_text = _log(return_text,'Could not delete meta-data column:"summary", it may not have existed anyway')
    
    return_text = _log(return_text,'Made sure correct meta-data columns are present')
        
    # code to fix ZCatalog BTrees
    self.manage_convertBTrees()
    return_text = _log(return_text,'Updated ZCatalog BTrees')

    # code to re-index everything
    self.recatalogPostings()
    return_text = _log(return_text,'Re-catalogued all postings.')

    return return_text


def update(self):
    return _updateall(self,do_update, metatypes=['Squishdot Site'])




