from copy import copy

class virtual:
    "this method is unimplemented in this base class"

class table_info_template:
    "reads info about a table, to create widgets about it"
    #######dictionaries:

    #a description  is  a sequence of 7-uples of the form
    #(name, type_code, display_size, internal_size, precision, scale, null_ok)
    
    #field to description
    #where 'description' is the 7-uple above
    field_description={}
    
    # field to columninfo
    # where     columninfo = (Field, Type, Null, Key, Default, Extra)
    #note that the above is the format used by mySQL
    field_columninfo={}


    ####### other info:
    #list of field names
    fields=[]
    #and number of fields
    n_fields=0
    
    #default row
    default_row=[]
    
    # some special Fields
    #list of fields which are part of the primary key
    primary_key_fields=[]
    #and the index of the last one in the list 'fields'
    n_primary=None

    #list of fields which have keys
    key_fields=[]
    #and the index of the last one in the list 'fields'
    n_key=None
    
    ##the method of initizialization is:
    #def __init__(self,db,db_name,table_name):
    ##where 'db' can be obtained by
    ## db=MySQLdb.connect() or other module that implements "python db api"





class entry_widget_template:
    "template for class for a row entry (that is, for the value of a column)"
    #widget that implements the GUI
    widget=None
    #or also
    __widget=None

    def __init__(self,columninfo,description):
        (Field, Type, Null, Key, Default, Extra) = columninfo
        (name, type_code, display_size, internal_size, precision, scale, null_ok)=description

        self.columninfo=copy(columninfo)
        self.description=copy(description)
        #can this entry be null?
        self.not_null=not null_ok
        
        #FIXME not portable?
        self.type=Type
        self.default=Default

        
        #self.key = Key
        
    #standard methods of this class
    def set(self,value):
        #puts the value in the appropriate widget
        raise virtual
    def get(self):
        #gets the value from the widget
        raise virtual
    def set_editable(self,flag):
        #sets the widget so that it can/cannot be edited
        raise virtual

    def log(self,level,text):
        print "LOG("+str(level)+"): "+ text

    
class row_widget_template:
    """template for class for a row (that is, for the value of a row).    
    Note that a row_widget class implements the methods of
    an entry_widget class ---    and can be used as such, for joins"""
    #widget that implements the GUI
    widget=None
    #or
    __widget=None
    
    #methods
    def get(self):
        #return the value of the primary
        return self.primary    
    def set(self,v):
        #it does an SQL SELECT to find the row where primary key=v
        raise virtual

    def get_row(self):
        raise virtual
    def set_row(self,r):
        raise virtual
        
    def set_editable(self,flag):
        #sets the widget so that it can/cannot be edited
        raise virtual

    # a fallback log method
    def log(self,level,text):
        print "LOG("+str(level)+"): "+ text
