#!/usr/local/bin/perl

use SPDB;
use SPCGI;
use SmallPig;

use strict;

sub main{
#    print "Content-type: text/html\n\n";      

  # --- create a SPDB object
  my $spdb = SPDB->new();
  
  my $spcgi = SPCGI->new($spdb);
  $spcgi->set_state_for_client();

  # --- load the lang module
  $spcgi->{STATE}->{langptr} = SmallPig::get_lang_ptr($spcgi->{STATE}->{lang}, 
						      "index");

  my $STATE = $spcgi->{'STATE'};
  my $op = $STATE->{'op'};
  
  # --- create a template object
  my $template;
  if($op eq "markallthreads"){
      require Templates::Caution;
		
      # --- create a template object
      $template = Templates::Caution->new($spcgi, $spdb);
      
      require Ops::Comments;
      my $obj = Ops::Comments->new($STATE, $spdb);
      
      my ($succ, $err_msg, $btitle, $url) = $obj->mark_all_threads();
      
      $template->{'btitle'} = $btitle;
      $template->{'bmsg'} = $err_msg;
      $template->{'uri'} = $url;
  }
  elsif($op eq "shownewposts"){
      require Templates::TopicsList;
		
      # --- create a template object
      $template = Templates::TopicsList->new($spcgi, $spdb, "shownewposts");
  }
  else{
      require Templates::Index;

      $template = Templates::Index->new($spcgi, $spdb);
  }
  # --- print the http header
  $template->print_http_header();
  $template->print_template();
}

main();
