#!/usr/local/bin/perl

use SmallPigVars qw($config);
use SPDB;
use SPCGI;

use strict;

my $lang =
{(
  'user_name1'             => "Login Name",
  'nick_name1'             => "Nick Name",
  'real_email1'            => "Real Email",
  'is_missing'             => "is missing",
  'passwds_not_match'      => "Passwords do not match.",
  'passwd_too_short'       => "Passwords need to > 5 chars.",
  'need_passwd'            => "Verified password/passord field has not been filled in.",
  'profile_saved1'         => "Administrator Account Created",
  'profile_saved2'         => "An administrator account has been created.  Go to the login and enter the username and password you chose. Now you are ready to start creating categories and boards, assigning moderators, and customizing your sporum site."
  )};

sub main{
  # --- create a SPDB object
  my $spdb = SPDB->new;
  
  my $spcgi = SPCGI->new($spdb);
  $spcgi->set_state_for_client();

  my $STATE = $spcgi->{'STATE'};
  
  my ($succ, $err_msg, $btitle, $url) = &save_first_user($STATE, $spdb);
  
  my $template;
  if($succ){
      require Templates::Caution;

      # --- create a template object
      $template = 
	Templates::Caution->new($spcgi, $spdb,
				$btitle, 
				$err_msg, $url);
  }
  else{
      require Templates::Default;
      # --- create a template object
      $template = Templates::Default->new($spcgi, $spdb);

      $template->{'caution'} = $err_msg;
      $template->{'dpage'} = "createadmin";
  }

  $template->print_http_header("");
  $template->print_template();	
}

sub save_first_user{
  my ($STATE, $spdb) = @_;
  my ($uri, $msg);

  my ($vpasswd, $passwd, $nickname, $realname, $realemail, 
      $fakeemail, $homepage, $bio, $icq, $uid, $username, $privlev) = 
	map{ $STATE->{$_} } qw(vpasswd passwd 
			       mynickname realname realemail 
			       myfakeemail homepage mybio myicq
			       myuid myusername myprivlev);

  if(!$username){
      $msg .= "<LI> $lang->{'user_name1'} $lang->{'is_missing'}";
  }
  if(!$nickname){
      $msg .= "<LI> $lang->{'nick_name1'} $lang->{'is_missing'}";
  }
  if(!$realemail){
      $msg .= "<LI> $lang->{'real_email1'} $lang->{'is_missing'}";
  }
  if($passwd && $vpasswd){
      unless($vpasswd eq $passwd){
	  $msg .= "<LI>".$lang->{'passwds_not_match'};
      }
      if(length($passwd) < 5 || length($vpasswd) <5){
	  $msg .= "<LI>".$lang->{'passwd_too_short'};
      }
  }
  if(!$passwd || !$vpasswd){
      $msg .= "<LI>".$lang->{'need_passwd'};
  }
  if($msg){
      return (0, $msg, "", "$config->{'cgidir'}/default.cgi?dpage=createadmin");
  }

  # --- insert new user in *Users*
  my $data = {('nickname'=>$nickname, 'realname'=>$realname,
	       'realemail'=>$realemail, 'fakeemail'=>$fakeemail,
	       'homepage'=>$homepage, 'bio'=>$bio,
	       'registered'=> $spdb->db_date(), 'isadmin'=>1, 'active'=>1,
	       'icq'=>$icq, 'username'=>$username,
	       'uid'=>1, 'privlev'=>$privlev)};
  my ($succ, $errmsg) = $spdb->db_insert("Users", $data);
  return (0, $errmsg, "", "$config->{'cgidir'}/default.cgi?dpage=createadmin") 
      if !$succ;    

  my ($succ, $errmsg) = $spdb->db_insert("BoardPrefs", {'uid'=>1});
  return (0, $errmsg, "", "$config->{'cgidir'}/default.cgi?dpage=createadmin") 
      if !$succ;    
  
  &_update_passwd(1, $passwd, $spdb) if $passwd && $vpasswd;

  # --- insert dummy node to *Users*
  $data = {('uid'       =>0,
	    'username'  =>'anon','nickname'  =>'anon',
	    'realemail' =>'anon','fakeemail' =>'anon',
	    'privlev' => 1)};
  my ($succ, $errmsg) = $spdb->db_insert("Users", $data);
  return (0, $errmsg, "", "$config->{'cgidir'}/default.cgi?dpage=createadmin") 
      if !$succ;

  return (1, $lang->{'profile_saved2'}, $lang->{'profile_saved1'},
	  "$config->{'cgidir'}/user.cgi?op=login");
}

sub _update_passwd{
  my ($uid, $passwd, $spdb)= @_;
  my $DBH = $spdb->{'dbh'};

  my $crypt = crypt($passwd, &_salt());
  my $data = {('passwd'=>$DBH->quote("$crypt"))};
  return $spdb->db_update("Users", $data, "uid=$uid");
}

sub _salt{
  my @saltset = (0..9, 'A'..'Z', 'a'..'z', '.', '/');
  return join('', @saltset[rand @saltset, rand @saltset]);
}

main();
