package Templates::ThreadList;

use SmallPigVars qw($config);
use Templates::CommentsTL;

use strict;
use vars qw(@ISA $template);

@ISA = qw(Templates::CommentsTL);

my $lang;

sub new{
  my ($class, $spcgi, $spdb, $pagetype) = @_;

  $template = Templates::CommentsTL->new($spcgi, $spdb, $pagetype);
  
  $template->{'spcgi'} = $spcgi;
  $template->{'STATE'} = $spcgi->{'STATE'};
  $template->{'spdb'} = $spdb;
  
  $template->{'title'} = "";
  $template->{'refresh'} = "";

  bless $template, $class;

  $template->initialize();
  
  return $template;
}

#########################################################################
# --- Sun Dec 19 23:06:10 PST 1999
# ---
sub initialize{
  my ($template) = @_;

  my $spdb = $template->{'spdb'};
  my $STATE = $template->{'STATE'};
  my $DBH = $spdb->{'dbh'};

  my ($sid, $cid, $userstatus, $nps) = 
      map{ $STATE->{$_} } qw(sid cid userstatus nps);
  
  my $pagefiles = {};
  $pagefiles->{'default'} = "default.temp";
  
  $template->{'pagefiles'} = $pagefiles;

  my $pagesubs = {};
  $pagesubs->{'default'} = \&whole;
  $pagesubs->{'printable'} = \&printable;
  
  $template->{'pagesubs'} = $pagesubs;
  
  # --- get the board name
  my $sidq = $DBH->quote($sid);
  ($template->{'boardname'}) = $spdb->db_select_cols("title", "Boards", 
						     "sid=$sidq");

  my $mpid = $template->_select_the_most_parent($cid);
  # --- get the most parent info
  ($template->{'subject'}, 
   $template->{'bodytext'}, 
   $template->{'hits'}, 
   $template->{'ip'}, 
   $template->{'time'}, 
   $template->{'closed'}, 
   $template->{'sid'}, 
   $template->{'uid'},
   $template->{'name'}, 
   $template->{'email'}, 
   $template->{'pid'}, 
   $template->{'lastmod'}, 
   $template->{'replies'}, 
   $template->{'privlev'}) = $template->_select_comment($mpid);
  $template->{'cid'} = $mpid;
  $template->{'rcid'} = $cid;

  $lang = $template->{'lang'};
}

#########################################################################
# --- pagesubs
# ---
sub whole{
  my $spdb = $template->{'spdb'};
  my $STATE = $template->{'STATE'};
  my ($page, $sid, $cid, $view, $display, $mode, $userstatus, 
      $sid, $op, $displaysort);
  ($page, $sid, $cid, $view, $display, $mode, $userstatus, 
   $sid, $op, $displaysort) =
      map { $STATE->{$_} } 
  qw(page sid cid view display mode userstatus sid op displaysort);
  
  print qq|<form action="$config->{'cgidir'}/comments.cgi"|;
  
  $template->print_standard_index();

  $template->print_threadinfo();
  $template->print_iconbar();

  if($display eq "default"){
      $template->print_threadlist();
  }
  elsif($display eq "threaded"){
      $template->print_the_first_post();
      $template->print_space();
      $template->print_threadlist1();
  }
  else{
#      my $mcid = $template->_select_the_most_parent($cid);
      # --- most parent
      if(1){# || $mcid eq $cid){
	  if($display eq "nested"){
	      $template->print_the_most_parent();
	      $template->print_the_children();
	  }
	  elsif($display eq "combined"){
	      $template->print_the_most_parent();
	      $template->print_space();
	      $template->print_threadlist1();
	      $template->print_the_children();
	  }
	  else{
	      $template->print_the_most_parent();
	      $template->print_the_children();
	  }
      }
      else{
	  my $dsort = "date ".(($displaysort eq "oldest")?"asc":"desc");
	  
	  my ($cids) = $spdb->db_select_many(1, "cid", "Posts", 
					     "pid=$template->{'pid'}",
					     "ORDER BY $dsort");
	  foreach (@$cids){
	      my ($cid) = @$_;
	      
	      ($template->{'subject'}, 
	       $template->{'bodytext'}, 
	       $template->{'hits'}, 
	       $template->{'ip'}, 
	       $template->{'time'}, 
	       $template->{'closed'}, 
	       $template->{'sid'}, 
	       $template->{'uid'},
	       $template->{'name'}, 
	       $template->{'email'}, 
	       $template->{'pid'}, 
	       $template->{'lastmod'}, 
	       $template->{'replies'}) = $template->_select_comment($cid);
	      $template->{'cid'} = $cid;
	      
	      $STATE->{'cid'} = $cid;
	      
	      if($display eq "nested"){
		  $template->print_the_most_parent();
		  $template->print_the_children();
	      }
	      else{
		  $template->print_the_most_parent();
		  $template->print_the_children();
	      }
	  }
	  
      }

  }

  $template->print_adjust_font();
#  $template->print_page_index($template->{'totalnums'});  

  print qq|<input type=hidden name=page value="$page">\n|;
  print qq|<input type=hidden name=sid value="$sid">\n|;
  print qq|<input type=hidden name=cid value="$cid">\n|;
  print qq|<input type=hidden name=view value="$view">\n|;
  print qq|<input type=hidden name=mode value="$mode">\n|;

  print "</form>";
}

sub printable{
    my $STATE = $template->{'STATE'};
    my ($display) = map { $STATE->{$_} } qw(display);
    
    #$template->print_threadinfo();
    $template->print_the_most_parent();

    if($display eq "flat"){
	$template->print_the_children();
    }
    else{
	$template->print_threadlist();
    }
}

sub print_threadinfo{
  my ($template) = @_;
  my $spdb = $template->{'spdb'};
  my $STATE = $template->{'STATE'};
  my $DBH = $spdb->{'dbh'};
  my $theme = $template->{'theme'};

  my ($sid, $sort, $view) = 
      map{ $STATE->{$_} } qw(sid sort mode postsper);

  $sid = $template->url_encode($sid);

  my $subject = $template->filter_html($template->{'subject'});

  # --- print the information!!!!!!!!!!!!!
  $template->print_block_start($theme->{'dhdrcolor'}, $theme->{'dhdrcolor'});

  my $boardname = qq|<a href="$config->{'cgidir'}/comments.cgi?op=topicslist&page=1&sid=$sid&view=$view" class=bheader>$template->{'boardname'}</a>|;

  print qq|<tr width="100%"><TD width="40%" class=bheader2nb><B>&gt;&gt;&nbsp;$boardname:&nbsp;&nbsp;$subject</B><BR></TD></tr>|;

  $template->print_block_end();
}

sub print_iconbar{
  my ($template) = @_;
  my ($STATE, $spdb) = map{ $template->{$_} } qw(STATE spdb);
  my $DBH = $spdb->{'dbh'};
  my ($can_write, 
      $cgi, $op, $sort, $postsper, $page, $sid, $view,
      $cid, $display, $pid, $words, $match, $ssid, $mode, $nps) = 
    map { $STATE->{$_ } } 
  qw(can_write cgi op sort postsper page sid view 
     cid display pid words match ssid mode nps);
  my $theme = $template->{'theme'};
  
  $page ||= 1;
  $cgi = $ENV{SCRIPT_NAME};
  my $referer = $ENV{HTTP_REFERER};
  # --- encode sid
  my $sid1 = $sid;
  $sid = $template->url_encode($sid);
 # --- encode sort
  my $sort1 = $sort;
  $sort = $template->url_encode($sort);
  
  my ($cw, $pp, $np, $all, $vad, $p);

  # --- all 
  my ($all_url, $all_alt);
  if($words){
      $all_url = "$config->{'cgidir'}/search.cgi?postsper=$postsper&sort=$sort&sid=$ssid&words=$words&match=$match"; 
      $all_alt = $lang->{'back_search'};
  }
  else{
      $all_url = "$config->{'cgidir'}/comments.cgi?op=topicslist&page=$page&postsper=$postsper&sort=$sort&sid=$sid&view=$view&mode=$mode"; 
      $all_alt = $lang->{'all_topics'};
  }
  $all = qq|<a href="$all_url"><img border=0 src="$theme->{'imagesdir'}/$theme->{'all_image'}" alt="$all_alt"></img></a>|;
  
  # --- display
  my $display1 = ($display eq "threaded")?"flat":"threaded";
  my $image = ($display eq "threaded")?$theme->{'flat_image'}:$theme->{'threaded_image'};
  my $alt = ($display eq "threaded")?$lang->{'flat_mode'}:$lang->{'threaded_mode'};
  my $display_url = "$config->{'cgidir'}/comments.cgi?op=threadlist&page=$page&sid=$sid&cid=$cid&view=$view&display=$display1";
  $display_url .= "&words=$words" if $words;
  $display_url .= "#$cid";
#  $vad = qq|<a href="$display_url"><img border=0 src="$theme->{'imagesdir'}/$image" alt="$alt"}></img></a>|;

  my $mpid = $template->_select_the_most_parent($cid);
  # --- make sure we have a correct page number --- #
  my $sidq = $DBH->quote($sid1);
  my $from = "Posts AS P, MostParents AS MP";
  my $where = "P.sid=$sidq AND approved=1 
               AND MP.cid=P.cid ";
  
  my $where1;
  if($mode eq "shownewposts"){
      my $tmp; my $flag=0;
      my @tmp = split(/\,/, $nps);
      foreach (@tmp){
	  $tmp .= "P.cid=$_ OR "; $flag = 1;
      }
      $tmp =~ s/OR $//;
      $where1 = " AND ($tmp) " if $flag;
      $where .= $where1;
  }

  $sort1 =~ s/date/lastmod/ if $from =~ /MostParents/;

  my $others = "ORDER BY $sort1 ";
  my $tmplimit = $postsper;
  if($page == 1){
    $others .= "LIMIT $tmplimit";
  }
  else{ 
    my $tmpstart = ($page-1)*$tmplimit; 
    $others .= "LIMIT $tmpstart, $tmplimit";
  }
  my ($topics) = $spdb->db_select_many(1, "P.cid", $from, 
				       $where, $others);
  
  my ($prev_page, $next_page);
  if($topics){
    my @tmp = @$topics;
    my $start = $topics->[0]->[0];
    my $end = $topics->[$#tmp]->[0];
    $prev_page = $next_page = $page;
    if($start == $mpid){
      $next_page--;
    }
    elsif($end == $mpid){
      $prev_page++;
    }
  }
  else{
    return "";
  }
    # --- get the position
  my ($pos)= (0);
  foreach (@$topics){
      last if $mpid == $_->[0]; 
      $pos++;
  }

  # ---------------------------------------------- #
  
  if(!$words){

    my $others = "ORDER BY $sort1 ";
    my ($tstart, $tlimit, $tp, $tn);
    if($page == 1 && $pos == 0){
	$tstart = 0; $tlimit = 2; $tp = 1; $tn = 3;
    }
    else{
	$tstart = ($page-1)*$postsper + $pos - 1;
	$tlimit = 3; $tp = 2; $tn = 0;
    }
	
    $others .= "LIMIT $tstart, $tlimit";
    
    my ($cidset) = $spdb->db_select_many(1, "P.cid", 
					 $from, $where, $others);
    my $prev_cid = $cidset->[$tp]->[0];
    my $next_cid = $cidset->[$tn]->[0];
  
    # --- prev page
    if(!$prev_cid){
	$pp = qq|<img border=0 src="$theme->{'imagesdir'}/$theme->{'prev_image'}"></img>|;
    }
    else{
	my $url = "$config->{'cgidir'}/comments.cgi?&op=threadlist&page=$prev_page&&sid=$sid&cid=$prev_cid&view=$view&display=$display&mode=$mode";
	$pp = qq|<a href=$url><img alt="$lang->{'prev_thread'}" border=0 src="$theme->{'imagesdir'}/$theme->{'prev_image'}"></img></a>|; 
    }
    
# --- next page
    if(!$next_cid){
	$np = qq|<img border=0 src="$theme->{'imagesdir'}/$theme->{'next_image'}"></img>|;
    }
    else{
	my $url = "$config->{'cgidir'}/comments.cgi?&op=threadlist&page=$next_page&sid=$sid&cid=$next_cid&view=$view&display=$display&mode=$mode";
	$np = qq|<a href=$url><img alt="$lang->{'next_thread'}" border=0 src="$theme->{'imagesdir'}/$theme->{'next_image'}"></img></a>|;
    }
}
  $p = qq|<a href="$config->{'cgidir'}/comments.cgi?op=threadlist&page=$page&sid=$sid&cid=$cid&display=$display&mode=printable"><img border=0 src="$theme->{'imagesdir'}/$theme->{'print_image'}"></img></a>|;
  
  $template->SUPER::print_block_start($theme->{'dhdrcolor'},
				      $theme->{'dhdrcolor'});
  
  my ($op, $display, $displaysort);
  ($op, $display, $displaysort) = 
      map{ $template->{'STATE'}->{$_} } qw(op display displaysort);
  my ($buttons, $ret);
 
  $buttons .= "&nbsp $lang->{'display_opts'}:&nbsp";
  $buttons .= $template->select_option({("$lang->{'ThreadedFlat'}"=>'nested',
					 "$lang->{'Threaded'}"=>'threaded',
					 "$lang->{'Flat'}"=>'flat',
					 "$lang->{'Combined'}"=>'combined')},
				       'display', $display);
#  $buttons .= $template->select_option({("$lang->{'Oldest'}"=>'oldest',
#					 "$lang->{'Newest'}"=>'newest')},
#				       'displaysort', $displaysort);
  # --- reply
  my $buttons1 = qq|<INPUT type="submit" name="op" value="$lang->{'Change'}">|;
  
  print "<tr>";

  print qq|<td align="left">$cw $pp $all $np $vad &nbsp;$p</td>|;

  print qq|<td align=right class=bheader2nb>$buttons<font size="1">$buttons1</font></td>|;

  print "</tr>";

  $template->SUPER::print_block_end();
}

sub print_the_first_post{
    my ($template) = @_;
    my ($STATE, $spdb, $rcid) = map{ $template->{$_} } qw(STATE spdb, rcid);
    my $DBH = $spdb->{'dbh'};
     
    my ($display, $userstatus, $sid, $mode, $cid) = 
	map { $STATE->{$_} } qw(display userstatus sid mode cid);
    
    if($mode ne "printable"){
	
	 _print_subthread_info($cid);
	 
     }
    else{
	
	print "<tr><td class=header1>$config->{'title'}<hr></td></tr>";
#      $ret .= $self->get_comments();
#      my $url = $ENV{HTTP_REFERER};
#      $ret .= "<A HREF=$url><FONT SIZE=1>&lt;back</FONT></A>";
	_print_subthread_info();
    }
    
}

sub print_the_most_parent{
  my ($template) = @_;
  my ($STATE, $spdb, $rcid) = map{ $template->{$_} } qw(STATE spdb, rcid);
  my $DBH = $spdb->{'dbh'};

  my ($display, $userstatus, $sid, $mode, $cid) = 
      map { $STATE->{$_} } qw(display userstatus sid mode cid);

  if($mode ne "printable"){
      
      _print_subthread_info();
	
  }
  else{

      print "<tr><td class=header1>$config->{'title'}<hr></td></tr>";
#      $ret .= $self->get_comments();
#      my $url = $ENV{HTTP_REFERER};
#      $ret .= "<A HREF=$url><FONT SIZE=1>&lt;back</FONT></A>";
      _print_subthread_info();
  }
}

sub print_the_children{
  my ($template) = @_; 
  my ($STATE, $mpid) = map{ $template->{$_} } qw(STATE, cid);

  my ($sid, $cid) = map{ $STATE->{$_} } qw(sid cid);
  
#  my $mpid = $template->_select_the_most_parent($cid);

  $template->_print_subthreads_info1($mpid, \&_print_subthread_info);
}

sub print_threadlist1{
    my ($template) = @_; 
    my ($STATE) = map{ $template->{$_} } qw(STATE);
    my $theme = $template->{'theme'};

    my ($sid, $cid, $uid) = map{ $template->{$_} } qw(sid cid uid);
    
    my $display = $STATE->{'display'};

    #$cid = $template->_select_the_most_parent($cid);

    $template->{'tlptr'} = [[$sid, $cid, $uid]];

    $template->print_block_start($theme->{'dhdrcolor'}, $theme->{'dhdrcolor'});

    $template->print_topicslist1();

    $template->SUPER::print_block_end();
}

sub print_topicslist1{
    my ($template) = @_;
    my $spdb = $template->{'spdb'};
    my $STATE = $template->{'STATE'};
    my $DBH = $spdb->{'dbh'};
    my $topics = $template->{'tlptr'};
    my $theme = $template->{'theme'};

    if($topics){
	
	print qq|
<tr bgcolor=$theme->{'dhdrcolor'}>
    <td width=$theme->{'csubject_w'} class=bheader2>$lang->{'subject'}</td>
    <td width=$theme->{'cuser_w'} class=bheader2>$lang->{'posted_by'}</td>
    <td width=$theme->{'edate_w'} class=bheader2>$lang->{'lastmod'}</td>
</tr>
	|;
    
	my $color = 0;
	foreach (@$topics){
	    my ($sid, $cid, $uid) = @$_;	    
	    $template->print_expanded_thread_info($STATE, $cid, "", $color);
	    $color = ($color==0)?1:0;
	    $color = $template->_print_subthreads_info($cid, 1, $color); 
	}
	
    }
    else{};    
}


sub print_threadlist{
  my ($template) = @_; 
  my ($STATE) = map{ $template->{$_} } qw(STATE);
  
  my ($sid, $cid, $uid, $display) = map{ $STATE->{$_} } qw(sid cid uid display);
  
  $cid = $template->_select_the_most_parent($cid);

  $template->{'tlptr'} = [[$sid, $cid, $uid]];

  if($display eq "default"){
      $STATE->{'cid'} = "";
  }
  $STATE->{'view'} = "expanded";
  $template->print_topicslist();
}

sub get_rid_of_cids{
    my ($template) = @_;
    my $STATE = $template->STATE;
    my $userstatus = $STATE->{'userstatus'};
    my $nps = $STATE->{'nps'};
    my $cid = $STATE->{'cid'};

    if($userstatus ne "anon"){
	$STATE->{'tnps'} = $STATE->{'nps'};
	my $tmp = "$cid,";
	if($nps =~ /(.*)$tmp(.*)/){
	    # --- erase the cid
	    $nps = "$1$2";
	}   
    
	$STATE->{'nps'} = $nps;
    }
}

#############################################################################
# --- private functions
# ---
#############################################################################
sub _print_subthreads_info1{
  my ($template, $cid, $ref, $cnt) = @_;
  my $STATE = $template->{'STATE'};
  my $spdb = $template->{'spdb'};
  my $DBH = $spdb->{'dbh'};

  my $display = $STATE->{'display'};
  my $sidq =  $DBH->quote($STATE->{'sid'});

  my ($tmp) = 
      $spdb->db_select_many_new(1, "childid", 
				"ParentAndChild, Posts", 
				"parentid=$cid AND childid=cid AND sid=$sidq
                                 AND approved=1");
  if(!$tmp){
      return;
  }
  else{
      while (my ($childid) = $tmp->fetchrow_array){
	  my $tcnt;
	  if($display eq "nested" || $display eq "combined"){
	      $tcnt = $cnt+1;
	  }
	  &{$ref}($childid, $tcnt);
	  $template->_print_subthreads_info1($childid, $ref, $cnt+1);
      }

      $spdb->db_handler_done($tmp);
  }
}

sub _print_subthread_info{
  my ($cid, $cnt) = @_;
  my ($STATE, $spdb, $rcid) = map{ $template->{$_} } qw(STATE spdb rcid);
  my $theme = $template->{'theme'};

  my $mconfig = $template->{'mconfig'};

  my ($subject, $bodytext, $hits, $ip, $time, $closed, $sid, $uid,
      $name, $email, $pid, $lastmod, $replies, $privlev);

  if(defined($cid)){
      ($subject, $bodytext, $hits, $ip, $time, $closed, $sid, $uid,
       $name, $email, $pid, $lastmod, $replies, $privlev) = 
	 $template->_select_comment($cid);
  }
  # --- the most parent
  else{
      ($subject, $bodytext, $hits, $ip, $time, $closed, $sid, $uid,
       $name, $email, $pid, $lastmod, $replies, $cid, $privlev) = 
	   map{ $template->{$_} } 
      qw(subject bodytext hits ip time closed sid uid
	 name email pid lastmod replies cid privlev);
  }

  $subject = $template->filter_html($subject);

  my ($view, $display, $page, $mode, $postsper, $userstatus, $nps) = 
    map{ $STATE->{$_} } 
  qw(view display page mode postsper userstatus tnps);
  
  my $sid1 = $template->url_encode($sid);

  # --- first update the hits of the comment
  $template->{'spdb'}->db_update("Posts", {('hits'=>"hits+1")}, "cid=$cid");

  my $user_info;
  # --- anon user
  if($uid == 0){
      $user_info = ($name)?"$name(anon)":"anon"; 
      if($email && $name){
	  if($mconfig && $STATE->{'userstatus'} ne "anon"){
	      $user_info = qq|<a href="$mconfig->{'cgidir'}/spmail.cgi?op=newmsg&mto=$email">$user_info</a>|; 
	  }
	  else{
	      $user_info = qq|<a href="mailto:$email">$user_info</a>|; 
	  }
      }
  }
  else{ 
      if(!$privlev){
	  $user_info = qq|<a href="$config->{'cgidir'}/user.cgi?op=userinfo&uid=$uid&page=1&postsper=$postsper">$name</a>|;
      }
      else{
	  $user_info = qq|<b>$name</b>|;
      }
  }
  
  my $parent = $lang->{'parent'};
  my $parent_img = qq|<img alt="*" border=0 src="$theme->{'imagesdir'}/$theme->{'parent_image'}"></img>|;
  if($pid){ 
      $parent = qq|<a href="$config->{'cgidir'}/comments.cgi?op=threadlist&page=$page&sid=$sid1&cid=$pid&display=$display#$pid">$lang->{'parent'}</a>|;
      $parent_img = qq|<img alt="$lang->{'parent_msg'}" border=0 src="$theme->{'imagesdir'}/$theme->{'parent_image'}"></img>|;
      $parent_img = qq|<a href="$config->{'cgidir'}/comments.cgi?op=threadlist&page=$page&sid=$sid1&cid=$pid&display=$display#$pid">$parent_img</a>|;
  }
  
  my $reply = $lang->{'thread_closed'};
  my $reply_img = qq|<img alt="$lang->{'reply_msg'} ($lang->{'disabled'})" border=0 src="$theme->{'imagesdir'}/$theme->{'reply_image'}"></img>|;
  unless($closed){
      $reply = qq|<a href="$config->{'cgidir'}/comments.cgi?op=reply&sid=$sid1&cid=$cid">$lang->{'reply_post'}</a>|;
      $reply_img = qq|<img src="$theme->{'imagesdir'}/$theme->{'reply_image'}" alt="$lang->{'reply_msg'}" border=0></img>|;
      $reply_img = qq|<a href="$config->{'cgidir'}/comments.cgi?op=reply&sid=$sid1&cid=$cid">$reply_img</a>|;
  }
  
  my $edit_post;
  $edit_post = "$lang->{'edit_post'}";
  my $edit_img = qq|<img alt="$lang->{'edit_msg'} ($lang->{'disabled'})" border=0 src="$theme->{'imagesdir'}/$theme->{'edit_post_image'}"></img>|;
  if(can_modify($spdb, $STATE)){
      $edit_post = qq|<a href="$config->{'cgidir'}/comments.cgi?op=editpost&sid=$sid1&cid=$cid">$lang->{'edit_post'}</a>|;
      $edit_img = qq|<img alt="$lang->{'edit_msg'}" border=0 src="$theme->{'imagesdir'}/$theme->{'edit_post_image'}"></img>|;
      $edit_img = qq|<a href="$config->{'cgidir'}/comments.cgi?op=editpost&sid=$sid1&cid=$cid">$edit_img</a>|;
  }
  
  if($userstatus ne "anon"){
      # --- deal with new post
      my $new_posts = $nps;
      my $tmp = "$cid,";
      if($new_posts =~ /(.*)$tmp(.*)/){
	  $subject .= " <font class=\"caution\">($lang->{'new'})</font>";
	  # --- erase the cid
	  $STATE->{'nps'} = "$1$2";
      }   
  }

  # --- filter html and add <BR>
  my ($html, $markup) = $template->allow_html_markup($sid);
  $bodytext = $template->recover_quote($bodytext);
  $bodytext = $template->filter_html($bodytext) unless $html;
  $bodytext = $template->add_br($bodytext);
  $bodytext = $template->format_markup($bodytext) if $markup;

  my $files_info = "";
  my ($files) = $spdb->db_select_many_new(1, 
					  "fname, fsize, fdesc, date", 
					  "FileAttach", "cid=$cid");

  my $files_info;
  if($files){
      while (my ($fname, $fsize, $fdesc, $date) = $files->fetchrow_array){
	  $date =~ s/\s+/-/g;
	  my $fnameurl;
	  ($fnameurl = $fname) =~ s/(\s+|\\)/-/g;
	  my $fnameurl = qq|<a href="$config->{'file_url'}/$date-$fnameurl">$fname</a>|;
	  $files_info .= "$fnameurl $fsize $lang->{'bytes'} $fdesc<BR>";
      }
      
      $spdb->db_handler_done($files);
  }

  $files_info = 
      "<HR align=left width=\"30%\"><B>$lang->{'file_attach2'}:</B><BR>$files_info" if $files_info;
  
  my $ret;
  if($mode eq "printable"){
    print qq! <tr><td class=header2>
      <B>$lang->{'subject'}: </B>$subject<BR>
      <B>$lang->{'name'}: $user_info 
      <BR>$lang->{'date'}: $time
      </B><BR><BR>
      $bodytext<BR><BR>
      [ $reply | $edit_post | $parent ]
      <HR>      
    </td></tr>
      !;
  }
  else{
    my ($content, $width, $csp);
    $width = $theme->{'intblwidth'};
    $width =~ s/%$//;
    $width -= $cnt * 3;
    $width .= "%";

    $template->{'tlptr'} = [[$sid, $cid, $uid]];
    $STATE->{'view'} = "expanded";

    $template->print_space();
    
    my ($dhdrcolor, $lhdrcolor) = ($cid != $rcid)?
	($theme->{'dhdrcolor'}, $theme->{'lhdrcolor'}):
	    ($theme->{'cdhdrcolor'}, $theme->{'clhdrcolor'});

    $csp = "colspan=2"; #if $display eq "threaded";
    
    my $add_msg_fav = qq|<img alt="$lang->{'add_msg_fav_msg'} ($lang->{'disabled'})" border=0 src="$theme->{'imagesdir'}/$theme->{'add_msg_fav_image'}"></img>|;
    my $send_to_friends = qq|<img alt="$lang->{'send_to_friends_msg'} ($lang->{'disabled'})" border=0 src="$theme->{'imagesdir'}/$theme->{'send_to_friends_image'}"></img>|;
    
    if($userstatus ne "anon" && $mconfig){
	$add_msg_fav = qq|<a href="$config->{'cgidir'}/comments.cgi?op=addmsgfav&cid=$cid&sid=$sid1"><img alt="$lang->{'add_msg_fav_msg'}" border=0 src="$theme->{'imagesdir'}/$theme->{'add_msg_fav_image'}"></img></a>|;
    
	$send_to_friends = qq|<a href="$config->{'cgidir'}/comments.cgi?op=sendtofriends&cid=$cid&sid=$sid1"><img alt="$lang->{'send_to_friends_msg'}" border=0 src="$theme->{'imagesdir'}/$theme->{'send_to_friends_image'}"></img></a>|;
	
    }

    $template->print_block_start($dhdrcolor,"","",$width);

    print qq^<!-- comment -->
    <tr bgcolor="$dhdrcolor">
	<td class="bheader1nb">
	    <a name="$cid">&nbsp</a><b>$lang->{'subject'}:</b> $subject
	 </td>
         <td align="right">
$reply_img 
$edit_img 
$parent_img 
$add_msg_fav 
$send_to_friends
	 </td>
     </tr>
     <tr bgcolor="$lhdrcolor">
	 <td class=bheader1nb $csp>
	     &nbsp; &nbsp; $lang->{'posted_by'}: $user_info $lang->{'on'} $time  
	 </td>
     </tr>
     <tr>
	 <td $csp>
	     <table border=0 cellspacing=0 cellpadding=10 width="100%" bgcolor=$theme->{'boxbgcolor'}>
		 <tr>
		     <td align="left" valign="top">
			 $bodytext<br>$files_info 
		     </td>
		   </tr>
	     </table>
	  </td>
     </tr>
	 ^;
#    $reply_img&nbsp;$edit_img&nbsp;$parent_img&nbsp;$add_msg_fav
    $template->print_block_end();
  }
}

sub can_modify{
  my ($spdb, $STATE) = @_;
  my $DBH = $spdb->{'dbh'};

  my ($sid, $uid, $cid, $userstatus, $tuserstatus) = 
    map{ $STATE->{$_} } qw(sid uid cid userstatus tuserstatus);

  my $select = "uid";
  my $from = "Posts";
  my $where = "cid=$cid";
  my ($tuid) = $spdb->db_select_cols($select, $from, $where) if $cid;
  
  # --- if user status is anon return 0
  return 0 if($userstatus eq "anon");

  # --- sid from mod userstatus --> ptr to arr
  my $sfmus = $tuserstatus->{mod};

  # --- if user is a moderator of this board
  return 1 if(($sfmus && grep { $_ eq $sid } @$sfmus) || 
	      $userstatus eq "admin" || $tuid == $uid);
  return 0;
}

return 1;


