package Templates::Admin::RevokeAdmin;

use SmallPigVars qw($config);

use CGI qw(:standard :cgi-lib);

use Templates::Admin::Block;
use Templates::Admin::OptBlock;

use strict;
my @ISA = qw(Templates::Admin::Block);

my %CACHE;

my $lang;

sub new{
  my ($class) = @_;
  my $self = Templates::Admin::Block->new();
  
  my $id = join '', sort values %$self, "revokeadminblock";
  return $CACHE{$id} if $CACHE{$id};
  return $CACHE{$id} = bless $self, $class;
}

sub display{
  my ($self, $STATE) = @_;
  my $theme = $STATE->{'theme'};

  $lang = $STATE->{'langptr'}; 

  my $standardindex = Templates::Admin::StandardIndex->new($STATE);

  my $content = _get_adminslist($STATE);
  my $classvars = {('content' => $content)};
  my $adminslist = Templates::Admin::OptBlock->new($classvars, $theme);
  
  my $ret;
  $ret = start_form(-method=>"post", 
		    -action=>"$config->{'cgidir'}/admin.cgi");
  $ret .= $standardindex->get();
  $ret .= $adminslist->get();
  $ret .= "<font size=1>".submit(-name=>"op", -value=>$lang->{'RevokeAdmin'})."</font>";
  $ret .= end_form()."</TD>";
  
  return $ret;
}

sub _get_adminslist{
  my $STATE = shift;
  my $ret = "";
  my $postsper = $STATE->{'postsper'};
  my $theme = $STATE->{'theme'};
  my $select = "uid, username,
                date_format(registered, \"$config->{date_format}\")";
  my $from = "Users";
  my $where = "isadmin=1 AND uid<>1 AND active=1";
  require SPDB;
  my ($admins) = SPDB->new->db_select_many(1, $select, $from, $where);
  
  $ret .= qq!
<TR BGCOLOR=$theme->{'dhdrcolor'} CELLPADDING=2>
<TD WIDTH=10% CLASS=bheader2>$lang->{'select'}</TD>
<TD CLASS=bheader2>$lang->{'loginusername'}</TD>
<TD WIDTH=25% CLASS=bheader2>$lang->{'assigned_on'}</TD>
</TR>
  !;

  unless($admins){
    $ret .= "<TR><TD COLSPAN=3>$lang->{'no_admins'}</TD></TR>";
  }

  foreach (@$admins){
    my ($uid, $username, $registered) = @$_;

 $registered =~ s/(jan|feb|mar|apr|may|jun|jul|aug|sep|oct|nov|dec)/$lang->{$1}/ig;

    $ret .= qq!
<TR>
  <TD WIDTH=10%><INPUT TYPE=radio NAME=selectedadmin VALUE=$uid></TD>
  <TD><A HREF=$config->{'cgidir'}/user.cgi?op=userinfo&uid=$uid&page=1&postsper=$postsper>$username</A></TD>
  <TD WIDTH=25%>$registered</TD>
</TR>
  !;
    
  }
  
  return $ret;
}


return 1;
