package Templates::Admin::ModifyCat;

use SmallPigVars qw($config);
use SmallPig;
use SPDB;
use CGI qw(:standard :cgi-lib);
use Templates::Admin::StandardIndex;
use Templates::Admin::Block;
use Templates::Admin::OptBlock;
use Templates::Admin::Caution;

use strict;
use vars qw(@ISA);

@ISA = qw(Templates::Admin::Block);

my $lang;

sub new{
  my ($class, $op) = @_;
  
  my $self = Templates::Admin::Block->new("modifycatblock");
  $self->{'op'} = $op;
  $self->{'spdb'} = SPDB->new;

  return bless $self, $class;
}

sub DESTROY{
    my $self = shift;
    my $spdb = $self->{'spdb'};
    $spdb->db_disconnect($spdb->{'dbh'});
}

sub get{
  my ($self, $STATE) = @_;
  my $op = $STATE->{'op'};
  my ($ret, $msg);
  my $theme = $STATE->{'theme'};

  $lang = $STATE->{'langptr'};

  my $content = $self->_get_catlist($STATE, $op);
  my $classvars = {( 'content' => $content)};
  my $catlist = Templates::Admin::OptBlock->new($classvars, $theme);
  my $standardindex = Templates::Admin::StandardIndex->new($STATE);
  
  $msg = $lang->{'modify_cat_msg1'};
  my $caution = Templates::Admin::Caution->new($theme);

  $ret = start_form(-method=>"post", -action=>"$config->{'cgidir'}/admin.cgi");
  $ret .= $standardindex->get();
  $ret .= $caution->get($msg);
  $ret .= $catlist->get();
  $ret .= "<INPUT TYPE=hidden NAME=prev_op VALUE=\"$op\"><font size=1>";
  $ret .= submit(-name=>"op", -value=>$lang->{'ChooseCategory'});
  $ret .= submit(-name=>"op", -value=>$lang->{'RemoveCategory'});
  $ret .= "</font>".end_form();

  return $ret;
}

sub _get_catlist{
  my ($self, $STATE) = @_;
  my $spdb = $self->{'spdb'};
  my $ret;
  
  my $theme = $STATE->{'theme'};

  my ($cats) = $spdb->db_select_many(1, "*", "Cats");

  $ret .= qq!
<TR BGCOLOR=$theme->{'dhdrcolor'} CELLPADDING=2>
<TD WIDTH=10% CLASS=bheader2>$lang->{'select'}</TD>
<TD WIDTH=25% CLASS=bheader2>$lang->{'keyword'}</TD>
<TD WIDTH=75%% CLASS=bheader2>$lang->{'title'}</TD>
</TR>
  !;

  unless($cats){
    $ret .= "<TR><TD COLSPAN=3>$lang->{'no_categories'}</TD></TR>";
  }

  foreach (@$cats){
    my ($catid, $cattitle, $catorder) = @$_;
    
    $ret .= qq!
<TR>
  <TD WIDTH=5%><font size=1><INPUT TYPE=radio NAME=selectedcategory VALUE="$catid"></font></TD>
  <TD WIDTH=10%>$catid</TD>
  <TD WIDTH=19%>$cattitle</TD>
</TR>      
  !;
  }
  return $ret;
}

return 1;
