package Templates::Admin::ModifyBoard;

use SmallPigVars qw($config);
use SPDB;
use CGI qw(:standard :cgi-lib);

use Templates::Admin::Block;
use Templates::Admin::OptBlock;

use strict;

my $lang;

sub new{
  my ($class, $STATE) = @_;
  my $self = Templates::Admin::Block->new();
  $self->{'STATE'} = {};  $self->{'STATE'} = $STATE;
  $self->{'spdb'} = SPDB->new;

  $lang = $STATE->{'langptr'}; 

  return bless $self, $class;
}

sub DESTROY{
    my $self = shift;
    my $spdb = $self->{'spdb'};
    $spdb->db_disconnect($spdb->{'dbh'});
}

sub display{
  my ($self) = @_;
  my $STATE = $self->{'STATE'};
  my $op1 = "";
  $op1 = $STATE->{'op'};
  my $theme = $STATE->{'theme'};
  my $standardindex = Templates::Admin::StandardIndex->new($STATE);

  my $content = $self->_get_modifyboardlist($STATE);
  my $classvars = {('content' => $content)};
  my $modifyboard = Templates::Admin::OptBlock->new($classvars, $theme);

  my $ret;

  $ret = start_form(-method=>"post", -action=>"$config->{'cgidir'}/admin.cgi");
  $ret .= $standardindex->get();
  $ret .= $modifyboard->get();
  $ret .= "<font size=1>";
  if($op1 eq "modifyboard"){
    $ret .= submit(-name=>"op", -value=>$lang->{'ChooseBoard'});
  }
  else{
    $ret .= submit(-name=>"op", -value=>$lang->{'RemoveBoard'});
  }
  $ret .= "</font>";
  $ret .= end_form()."</TD>";
  return $ret;
}

sub _get_modifyboardlist{
  my ($self, $STATE) = @_;
  my $spdb = $self->{'spdb'};
  my $ret = "";

  my $theme = $STATE->{'theme'};

  my $select = "B.sid, title, html, expire, level, active, 
                date_format(BC.date, \"$config->{date_format}\")";
  my ($boards) = 
    $spdb->db_select_many(1, $select, 
			 "Boards AS B, BoardBelongToCat AS BC",
			 "B.sid = BC.sid");
  my $tbtitle = qq!
  <TR BGCOLOR=$theme->{'dhdrcolor'} CELLPADDING=2>
    <TD CLASS=bheader2 WIDTH=5%>$lang->{'select'}</TD>
    <TD WIDTH=10% CLASS=bheader2>$lang->{'keyword'}</TD>
    <TD WIDTH=19% CLASS=bheader2>$lang->{'title'}</TD>
    <TD WIDTH=10% CLASS=bheader2>$lang->{'type'}</TD>
    <TD WIDTH=10% CLASS=bheader2>$lang->{'active'}</TD>
    <TD WIDTH=10% CLASS=bheader2>$lang->{'expire'}</TD>
    <TD WIDTH=16% CLASS=bheader2>$lang->{'created_on'}</TD>
      !;

  $ret .= $tbtitle;
  unless($boards){
    $ret .= "<TR><TD COLSPAN=7>$lang->{'no_boards'}</TD></TR>";
  }

  my @tmp;
  my $us = $STATE->{'userstatus'};
  if($us =~ /mod/){
    my $uid = $STATE->{'uid'};
    my ($sids) = $spdb->db_select_many(1,"sid","Moderators","uid=$uid");
    foreach (@$sids){ 
      my ($sid) = @$_;
      unshift @tmp, $sid; 
    }
  }

  my $flag = 1;
 GO:
  foreach (@$boards){
    my ($sid, $title, $html, $expire, $level, $active, $date) = @$_;

    $date=~ s/(jan|feb|mar|apr|may|jun|jul|aug|sep|oct|nov|dec)/$lang->{$1}/ig;

    if($expire == 0){}
    elsif($expire%30 == 0){
      $expire = ($expire/30)."M";
    }
    elsif($expire%365 == 0){
      $expire = ($expire/365)."y";
    }

    if($us eq "admin"){
      $flag = 0;
      my $status = Templates::Admin::SmallPig::get_board_status($level);
      $active = ($active)?"yes":"no";
      $ret .= qq!
<TR>
  <TD WIDTH=5%><font size=1><INPUT TYPE=radio NAME=selectedboard VALUE="$sid"></font></TD>
  <TD WIDTH=10%>$sid</TD>
  <TD WIDTH=19%>$title</TD>
  <TD WIDTH=10%>$status</TD>
  <TD WIDTH=10%>$active</TD>
  <TD WIDTH=10%>$expire</TD>
  <TD WIDTH=16%>$date</TD>
</TR>
    !;
      next GO;
    }

    foreach (@tmp){
      if($_ eq $sid){
	$flag = 0;
	my $status = Templates::Admin::SmallPig::get_board_status($level);
	$active = ($active)?"yes":"no";
	$ret .= qq!
<TR>
  <TD WIDTH=5%><INPUT TYPE=radio NAME=selectedboard VALUE="$sid"></TD>
  <TD WIDTH=10%>$sid</TD>
  <TD WIDTH=19%>$title</TD>
  <TD WIDTH=10%>$status</TD>
  <TD WIDTH=10%>$active</TD>
  <TD WIDTH=10%>$expire</TD>
  <TD WIDTH=16%>$date</TD>
</TR>
    !;
      }
    }
  }

  if($flag){ $ret .= "<TR><TD COLSPAN=7>$lang->{'no_boards'}</TD></TR>"; }
  
  return $ret;
}

return 1;
