package Templates::Admin::AssignUsers;

use SmallPigVars qw($config);
use SmallPig;
use CGI qw(:standard :cgi-lib);
use Templates::Admin::Block;
use Templates::Admin::OptBlock;
use Templates::Admin::UsersList;
use Templates::Admin::AssignUsersList;
use Templates::Admin::Caution;

use strict;
use vars qw(@ISA);

@ISA = qw(Templates::Admin::Block Templates::Admin::OptBlock);

my %CACHE;

my $lang;

sub new{
  # --- assign moderator
  # --- assign group 
  my ($class) = @_;
  my $self = Templates::Admin::Block->new();
  
  my $id = join '', sort values %$self, "assignusersblock";
  return $CACHE{$id} if $CACHE{$id};
  return $CACHE{$id} = bless $self, $class;
}

sub display{
  my ($self, $STATE) = @_;
  my ($op, $prev_op) = map{ $STATE->{$_} } qw(op prev_op);
  my $theme = $STATE->{'theme'};

  $lang = $STATE->{'langptr'};

  my $standardindex = Templates::Admin::StandardIndex->new($STATE);
  my $userslist = Templates::Admin::UsersList->new($STATE);
  my $caution = Templates::Admin::Caution->new($theme);
  my $assignuserslist = Templates::Admin::AssignUsersList->new($STATE);

  my ($msg, $ul);
  if($op eq "assignmod" || $prev_op =~ "assignmod"){
      $msg = $lang->{'assign_mod3'};
      $msg .= $lang->{'make_mult_sel'};
      $ul = $userslist->get_modlist($STATE);
  }
  else{
      $msg = $lang->{'assign_group'};
      $msg .= $lang->{'make_mult_sel'};
      $ul .= $userslist->get_grouplist($STATE);
  }
  
  my $ret;
  $ret = start_form(-method=>"post", 
		    -action=>"$config->{'cgidir'}/admin.cgi");
  $ret .= $standardindex->get(); 
  $ret .= $ul;
  $ret .= $caution->get($msg);
  $ret .= $assignuserslist->get();
  $ret .= "<font size=1>";

  if($op eq $lang->{'PreviewModerator'}){
      $ret .= submit(-name=>"op", -value=>$lang->{'SaveModerator'});
  }
  elsif($op eq $lang->{'PreviewGroup'}){
      $ret .= submit(-name=>"op", -value=>$lang->{'SaveGroup'});
  }
  if($op eq $lang->{'PreviewModerator'} || $op eq "assignmod"){
      $ret .= submit(-name=>"op", -value=>$lang->{'PreviewModerator'});
  }
  else{
      $ret .= submit(-name=>"op", -value=>$lang->{'PreviewGroup'});
  }
  $op = "$prev_op\#$op" if $prev_op;
  $ret .= hidden(-name=>"prev_op", -value=>$op);
  $ret .= "</font>";
  $ret .= end_form()."</TD>";
  
  return $ret;
}

return 1;
