package SPCGI;

use SmallPigVars qw($config);

use strict;

sub new{
    my ($class, $spdb) = @_;
    my $self = {};
    $self->{'spdb'} = $spdb;

    return bless $self, $class;
}

sub spparam{
    my ($self) = @_;
    my($query_string, $meth, $content_length);


    $meth=$ENV{'REQUEST_METHOD'} if defined($ENV{'REQUEST_METHOD'});

    # --- if multipart posting, ask CGI to handle it
    if($meth eq "POST" && defined($ENV{'CONTENT_TYPE'}) 
       && $ENV{'CONTENT_TYPE'} =~ m|^multipart/form-data|){

	require CGI;

	my $cgi = new CGI;

	return undef unless $cgi->param();
	
	my $state = {};
	my $isarr = 0;

	foreach ($cgi->param()){
	    my $key = $_;
	    my @tmp = $cgi->param($key);
	    my $curr_key;
	    foreach (@tmp){
		$isarr = 1;
		unless($curr_key eq $key){ $state->{$key} = $_; }
		else{ $state->{$key} .= "#$_"; }
		$curr_key = $key;
	    }
	}

	my $file_hdl = $cgi->param('file_hdl');
	$state->{ftype} = $cgi->uploadInfo($file_hdl)->{'Content-Type'} if $file_hdl;
	
	return $state;
    }

    $content_length = defined($ENV{'CONTENT_LENGTH'}) ? 
	$ENV{'CONTENT_LENGTH'} : 0;
    
    if($meth =~ /^GET$/) {
	$query_string = $ENV{'QUERY_STRING'} if defined $ENV{'QUERY_STRING'};
    }
    if($meth eq "POST"){
	$self->_read_from_client(\*STDIN, \$query_string, $content_length, 0)
	    if $content_length > 0;
    }
#    $query_string = q|poster=Admin&posteremail=webmeister%40realgsd.net&subject=test&body=test&op=Submit&sid=registry&fids=&cid=&uid=1&html=&markup=&prev_op=newcomment|;
    return $self->_parse_params($query_string);
}

sub cookie{
    my($self, @p) = @_;
    my($name, $value, $path, $domain, $secure, $expires) = @p;

    if(!defined($value)) {
        $self->{'.cookies'} = $self->_fetch_cookie_from_client() 
	    unless $self->{'.cookies'};

        return () unless $self->{'.cookies'};
        return keys %{$self->{'.cookies'}} unless $name;
        return () unless $self->{'.cookies'}->{$name};

        return $self->{'.cookies'}->{$name}->{'value'} 
	    if defined($name) && $name ne '';
    }

    return undef unless $name;
}

sub _set_anon{
    my ($STATE) = @_;
    $STATE->{'uid'} ||= 0;
    $STATE->{'nickname'} = $STATE->{'userstatus'} = "anon";
    $STATE->{'sort'} ||= $config->{'sort'};
    $STATE->{'postsper'} ||= 10;
    $STATE->{'view'} ||= $config->{'view'};
    $STATE->{'display'} ||= $config->{'display'};

    $STATE->{'theme'} ||= $config->{'theme'};
}

sub set_state_for_client{
    my ($self) = @_;
    my $STATE = {};
    $STATE = $self->{'STATE'} = $self->spparam(); 

    # --- verify cookie
    my $username = $self->_verify_cookie();

    my ($spdb) = map{ $self->{$_} } qw(spdb);
    my $DBH = $spdb->{'dbh'};

    $STATE->{'username'} = $username || "anon";
    $STATE->{'ip'} = $ENV{'REMOTE_ADDR'};

    if($STATE->{'username'} eq 'anon'){
	_set_anon($STATE);
	$self->{'STATE'} = $STATE;
	return;
    }
    
    my $u_q = $DBH->quote($STATE->{'username'});
    
    my $select = "uid, nickname, fakeemail, lastlogon, active, peek, lastresp, cookieexpire";
    my $res = 
	$spdb->db_select_hash_ref($select, "Users", "username=$u_q AND active=1");
    
    if($res){
	if($STATE->{'op'} ne "userinfo" && $STATE->{'op'} ne "confirm"){
	    $STATE->{'uid'} = $res->{'uid'};
	}
	foreach (keys(%$res)){ 
	    if(!$STATE->{$_} && $_ ne "uid"){
		$STATE->{$_} = $res->{$_} || $config->{$_}  
	    }
	    if($_ eq "uid"){
		($STATE->{'userstatus'}, $STATE->{'tuserstatus'})
		    = $self->check_user_status();
	    }
	}
    }
    else{
	_set_anon($STATE);
    }

    my $select = "sort, display, view, postsper, sig, theme, lang";
    $res = $spdb->db_select_hash_ref($select, "BoardPrefs", "uid=$STATE->{'uid'}");
    
    if($res){
	foreach (keys(%$res)){ 
	    if(!$STATE->{$_} && $_ ne "uid"){
		$STATE->{$_} = $res->{$_} || $config->{$_}  
	    }
	}
    }
    else{
	_set_anon($STATE);
    }
}

#############################################################################
# --- private function
# ---

sub _fetch_cookie_from_client{
    my $class = shift;
    my $raw_cookie = $ENV{HTTP_COOKIE} || $ENV{COOKIE};

    return () unless $raw_cookie;
    return $class->_parse_raw_cookie($raw_cookie);
}

sub _parse_raw_cookie{
    my ($self, $raw_cookie) = @_;
    my $results = {};

    my(@pairs) = split("; ",$raw_cookie);
    foreach (@pairs) {
        my($key, $value) = split("=");
        my(@values) = map $self->_unescape($_), split('&', $value);
        $key = $self->_unescape($key);
	
        # A bug in Netscape can cause several cookies with same name to
        # appear.  The FIRST one in HTTP_COOKIE is the most recent version.
	$results->{$key}->{'value'} ||= \@values;
    }
    return $results;
}

sub _verify_cookie{
  my $self = shift;

  require MD5;
  my $cookie = $self->cookie('login_cookie');

  return undef unless $cookie;

  my %cookie1;
  for(my $i=0; $i<@$cookie; $i=$i+2){
      $cookie1{$cookie->[$i]} = $cookie->[$i+1];
  }

  # --- set the pre username
  $self->{'STATE'}->{'preusername'} = $cookie1{'username'};

  my $secret = $config->{'cookiesecret'};
  my $newhash = MD5->hexhash(
	        $secret.MD5->hexhash(join('',
					  $secret,
					  @cookie1{qw(time username)})));

  unless($newhash eq $cookie1{'hash'}){
      return undef;
  }
  
  return $cookie1{'username'};
}

sub _read_from_client{
    my($self, $fh, $buff, $len, $offset) = @_;
    local $^W=0;
    return undef unless defined($fh);
    return read($fh, $$buff, $len, $offset);
}

sub _parse_params{
    my ($self, $tosplit) = @_;
    my @pairs = ();
    @pairs = split(/[&;]/,$tosplit);
    my($param, $value);
    my %ret;
    foreach (@pairs) {
        ($param,$value) = split('=',$_,2);
        $param = $self->_unescape($param);
        $value = $self->_unescape($value);
	if(defined($ret{$param})){
	    $ret{$param} .= "#$value";
	}
	else{
	    $ret{$param} = $value;
	}
    }
    return \%ret;
}

sub _unescape{
  my ($self, $todecode) = @_;
  return undef unless defined($todecode);
  $todecode =~ tr/+/ /;       # pluses become spaces
  $todecode =~ s/%([0-9a-fA-F]{2})/pack("c",hex($1))/ge;
  return $todecode;
}

# return "anon"  - anonymous
#        "ruser  - registered user
#        "mod"   - moderator
#        "admin" - administration
#        "gmem"  - group member
sub check_user_status{
  my ($self, $tusername) = @_;
  my ($spdb, $STATE) = map{ $self->{$_} } qw(spdb STATE);
  my $DBH = $spdb->{'dbh'};

  my ($sid, $uid, $username) = 
    map{ $STATE->{$_} } qw(sid uid username);
  
  $username = $tusername if $tusername;
  return "anon" if($username eq "anon");

  my $sidq = $DBH->quote($sid);
  my $usernameq = $DBH->quote($username);

  my $where = "username=$usernameq";
  
  # --- if user is admin?
  my ($isadmin) = $spdb->db_select_cols("isadmin", "Users", 
					$where);
  return "admin" if $isadmin;

  my ($userstatus, %tuserstatus);
  $where = "uid=$uid ";
  #$where .= "AND sid=$sidq" if($sid);
  # --- if user is mod?
  my ($sids) = $spdb->db_select_many_new(1, "sid", "Moderators", $where);
  
  if($sids){
      $userstatus = "mod|||";
      while (my ($sid) = $sids->fetchrow_array){
	  $userstatus .= "$sid|||";
	  push @{$tuserstatus{mod}}, $sid;
      }
      
      $spdb->db_handler_done($sids);
  }
  
   $userstatus =~ s/(.+)\|\|\|$/$1/;
  # --- if user is gmem?
  ($sids) = $spdb->db_select_many_new(1, "sid", "GroupMems", $where);
  
  if($sids){
      $userstatus .= "###gmem|||";
      while (my ($sid) = $sids->fetchrow_array){
	  $userstatus .= "$sid|||";
	  push @{$tuserstatus{gmem}}, $sid;
      }
      
      $spdb->db_handler_done($sids);
  }
   
  $userstatus =~ s/(.+)\|\|\|$/$1/;
  $userstatus ||= "ruser";
  return ($userstatus, \%tuserstatus);
}

return 1;

