/*
 * This is the DECtalk PC firmware loader for the Linux kernel, version 1.0
 *
 * Original 386BSD source:
 *      Copyright (c) 1996 Brian Buhrow <buhrow@lothlorien.nfbcal.org>
 *
 * Adapted for Linux:
 *      Copyright (c) 1997 Nicolas Pitre <nico@cam.org>
 *
 * Adapted for speakup:
 *      Copyright (c) 2003 David Borowski <david575@golden.net>
 *
 * All rights reserved.
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#define	MAX_FIXUPS	512	  	/* maximum fixups per exe */
/*
 *  msdos .exe files will look like ...
 */

struct dos_exe_header {
	unsigned short id;		/* Linker's signature, must be 0x5a4d */
	unsigned short rem;		/* length of image mod 512 */
	unsigned short pages;		/* length of image in pages of 512 bytes */
	unsigned short relen;		/* number of relocation items */
	unsigned short hsize;		/* header size in paragraphs of 16 bytes */
	unsigned short hmin;		/* min # of paragraphs above prog end */
	unsigned short hmax;
	unsigned short ssval;
	unsigned short spval;		/* to be loaded in sp */
	unsigned short	checksum;
	unsigned short	ipval;		/* to be loaded in ip */
	unsigned short	csval;  	/* segment offset to code */
	unsigned short	reloc;		/* location of relocation items	*/
	unsigned short	ovrlay;		/* overlay number */
};

/*  a dos relocation element looks like */

struct dos_reloc {
	short int offset, segment;
};
