-------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
-------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--=============================================================================

package body SPARK_Calendar is

   -- SPARK implementation of Calendar operations

   procedure Clock (Now : out SPARK_Calendar.Time) is
   begin
      Now := SPARK_Calendar.Time (Calendar.Clock);
   end Clock;

   procedure Year (Date   : in     SPARK_Calendar.Time;
                   Result :    out Year_Number;
                   Status :    out Error_Code) is
   begin
      Status := Valid;
      Result := Year_Number (Calendar.Year (Calendar.Time (Date)));
   exception
      when others =>
         Status := Time_Error;
   end Year;

   function Month (Date : SPARK_Calendar.Time) return Month_Number is
   begin
      return Month_Number (Calendar.Month (Calendar.Time (Date)));
   end Month;

   function Day (Date : SPARK_Calendar.Time) return Day_Number is
   begin
      return Day_Number (Calendar.Day (Calendar.Time (Date)));
   end Day;

   procedure Split
     (Date    : in     SPARK_Calendar.Time;
      Year_P  :    out Year_Number;
      Month_P :    out Month_Number;
      Day_P   :    out Day_Number;
      Status  :    out Error_Code) is
      Dummy_Seconds : Duration;
   begin
      Status := Valid;
      Calendar.Split (Calendar.Time (Date), Year_P, Month_P, Day_P, Dummy_Seconds);
   exception
      when others =>
         Status := Time_Error;
   end Split;

   procedure Time_Of
     (Year_P  : in     Year_Number;
      Month_P : in     Month_Number;
      Day_P   : in     Day_Number;
      Result  :    out SPARK_Calendar.Time;
      Status  :    out Error_Code) is
      Dummy_Seconds : Duration;
   begin
      Status        := Valid;
      Dummy_Seconds := 0.0;

      Result :=
        SPARK_Calendar.Time (Calendar.Time_Of
                               (Calendar.Year_Number (Year_P),
                                Calendar.Month_Number (Month_P),
                                Calendar.Day_Number (Day_P),
                                Dummy_Seconds));
   exception
      when others =>
         Status := Time_Error;
   end Time_Of;

   function LT (Left, Right : SPARK_Calendar.Time) return Boolean is
   begin
      return Left < Right;
   end LT;

   function LE (Left, Right : SPARK_Calendar.Time) return Boolean is
   begin
      return Left <= Right;
   end LE;

   function GT (Left, Right : SPARK_Calendar.Time) return Boolean is
   begin
      return Left > Right;
   end GT;

   function GE (Left, Right : SPARK_Calendar.Time) return Boolean is
   begin
      return Left >= Right;
   end GE;

end SPARK_Calendar;
