-------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
-------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--=============================================================================

separate (Sem)
procedure Wf_Predicate
  (Node           : in     STree.SyntaxNode;
   Scope          : in     Dictionary.Scopes;
   Context        : in     Anno_Tilde_Context;
   Component_Data : in out ComponentManager.ComponentData;
   The_Heap       : in out Heap.HeapRecord;
   Errors_Found   :    out Boolean) is
   Pred_Result : Exp_Record;
   Child       : STree.SyntaxNode;
begin
   Child := Child_Node (Current_Node => Node);
   -- ASSUME Child = annotation_expression
   SystemErrors.RT_Assert
     (C       => Syntax_Node_Type (Node => Child) = SP_Symbols.annotation_expression,
      Sys_Err => SystemErrors.Invalid_Syntax_Tree,
      Msg     => "Expect Child = annotation_expression in Wf_Predicate");
   Walk_Expression_P.Walk_Annotation_Expression
     (Exp_Node       => Child,
      Scope          => Scope,
      Type_Context   => Dictionary.GetPredefinedBooleanType,
      Context        => Context,
      Result         => Pred_Result,
      Component_Data => Component_Data,
      The_Heap       => The_Heap);

   if not Dictionary.IsBooleanTypeMark (Pred_Result.Type_Symbol) then
      Errors_Found := True;
      ErrorHandler.Semantic_Error
        (Err_Num   => 326,
         Reference => ErrorHandler.No_Reference,
         Position  => Node_Position (Node => Node),
         Id_Str    => LexTokenManager.Null_String);
   else -- result is Boolean but errors may have been found lower down the expression
      Errors_Found := Pred_Result.Errors_In_Expression;
   end if;
end Wf_Predicate;
