-------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
-------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--=============================================================================

separate (Sem.Walk_Expression_P.Walk_Annotation_Expression)
procedure Down_Wf_Store
  (Node      : in     STree.SyntaxNode;
   Scope     : in     Dictionary.Scopes;
   E_Stack   : in out Exp_Stack.Exp_Stack_Type;
   Next_Node :    out STree.SyntaxNode) is
   Type_Info   : Sem.Exp_Record;
   Error_Found : Boolean := False;
begin
   Exp_Stack.Pop (Item  => Type_Info,
                  Stack => E_Stack);
   case Type_Info.Sort is
      when Sem.Is_Unknown =>
         Type_Info := Unknown_Symbol_Record;
         Next_Node := STree.NullNode;
      when Sem.Is_Object =>
         if Dictionary.IsArrayTypeMark (Type_Info.Type_Symbol, Scope) then
            Type_Info.Param_Count := 0;
            Next_Node             := STree.Child_Node (Current_Node => Node);
            -- ASSUME Next_Node = store_list
            SystemErrors.RT_Assert
              (C       => STree.Syntax_Node_Type (Node => Next_Node) = SP_Symbols.store_list,
               Sys_Err => SystemErrors.Invalid_Syntax_Tree,
               Msg     => "Expect Next_Node = store_list in Down_Wf_Store");
         elsif Dictionary.IsRecordTypeMark (Type_Info.Type_Symbol, Scope) then
            Next_Node := STree.Child_Node (Current_Node => Node);
            -- ASSUME Next_Node = store_list
            SystemErrors.RT_Assert
              (C       => STree.Syntax_Node_Type (Node => Next_Node) = SP_Symbols.store_list,
               Sys_Err => SystemErrors.Invalid_Syntax_Tree,
               Msg     => "Expect Next_Node = store_list in Down_Wf_Store");
         else -- neither record nor array
            Error_Found := True;
            ErrorHandler.Semantic_Error
              (Err_Num   => 323,
               Reference => ErrorHandler.No_Reference,
               Position  => STree.Node_Position (Node => STree.Parent_Node (Current_Node => Node)),
               Id_Str    => LexTokenManager.Null_String);
            Next_Node := STree.NullNode;
         end if;
      when others =>
         Type_Info := Unknown_Symbol_Record;
         ErrorHandler.Semantic_Error
           (Err_Num   => 323,
            Reference => ErrorHandler.No_Reference,
            Position  => STree.Node_Position (Node => STree.Parent_Node (Current_Node => Node)),
            Id_Str    => LexTokenManager.Null_String);
         Next_Node := STree.NullNode;
   end case;
   Type_Info.Errors_In_Expression := Type_Info.Errors_In_Expression or else Error_Found;
   Exp_Stack.Push (X     => Type_Info,
                   Stack => E_Stack);
end Down_Wf_Store;
