-------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
-------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--=============================================================================

separate (Sem)
procedure Get_Type_Bounds (Type_Symbol              : in     Dictionary.Symbol;
                           Lower_Bound, Upper_Bound :    out Typ_Type_Bound) is
   Maths_Error : Maths.ErrorCode;
   Bound_Val   : Integer;
begin
   if Dictionary.IsBooleanTypeMark (Type_Symbol) then
      Lower_Bound := Typ_Type_Bound'(Is_Defined => True,
                                     Value      => 0);
      Upper_Bound := Typ_Type_Bound'(Is_Defined => True,
                                     Value      => 1);
   else
      Maths.ValueToInteger
        (Maths.ValueRep
           (Dictionary.GetScalarAttributeValue (False, -- don't want base type
                                                LexTokenManager.First_Token, Type_Symbol)),
         Bound_Val, -- to get
         Maths_Error); -- to get

      Lower_Bound := Typ_Type_Bound'(Is_Defined => (Maths_Error = Maths.NoError),
                                     Value      => Bound_Val);

      Maths.ValueToInteger
        (Maths.ValueRep
           (Dictionary.GetScalarAttributeValue (False, -- don't want base type
                                                LexTokenManager.Last_Token, Type_Symbol)),
         Bound_Val, -- to get
         Maths_Error); -- to get

      Upper_Bound := Typ_Type_Bound'(Is_Defined => (Maths_Error = Maths.NoError),
                                     Value      => Bound_Val);
      SystemErrors.RT_Assert
        (C       => not (Lower_Bound.Is_Defined and then Upper_Bound.Is_Defined) or else (Lower_Bound.Value <= Upper_Bound.Value),
         Sys_Err => SystemErrors.Math_Error,
         Msg     => "Lower bound > Upper bound in Get_Type_Bounds");
   end if;
end Get_Type_Bounds;
