-------------------------------------------------------------------------------
-- (C) Altran Praxis Limited
-------------------------------------------------------------------------------
--
-- The SPARK toolset is free software; you can redistribute it and/or modify it
-- under terms of the GNU General Public License as published by the Free
-- Software Foundation; either version 3, or (at your option) any later
-- version. The SPARK toolset is distributed in the hope that it will be
-- useful, but WITHOUT ANY WARRANTY; without even the implied warranty of
-- MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
-- Public License for more details. You should have received a copy of the GNU
-- General Public License distributed with the SPARK toolset; see file
-- COPYING3. If not, go to http://www.gnu.org/licenses for a complete copy of
-- the license.
--
--=============================================================================

separate (Dictionary)
procedure WriteOperatorRenamingDeclaration (Operator : in Symbol;
                                            Scope    : in Scopes) is

   Name  : SP_Symbols.SP_Symbol;
   Left  : Symbol;
   Right : Symbol;

   --------------------------------------------------------------------------------

   procedure WriteOperatorName (File : in SPARK_IO.File_Type;
                                Name : in SP_Symbols.SP_Symbol)
   --# global in out SPARK_IO.File_Sys;
   --# derives SPARK_IO.File_Sys from *,
   --#                                File,
   --#                                Name;
   is
   begin
      case Name is
         when SP_Symbols.RWand =>
            WriteString (File, "and");
         when SP_Symbols.RWor =>
            WriteString (File, "or");
         when SP_Symbols.RWxor =>
            WriteString (File, "xor");
         when SP_Symbols.plus =>
            WriteString (File, "+");
         when SP_Symbols.minus =>
            WriteString (File, "-");
         when SP_Symbols.RWmod =>
            WriteString (File, "mod");
         when SP_Symbols.equals =>
            WriteString (File, "=");
         when SP_Symbols.less_than =>
            WriteString (File, "<");
         when SP_Symbols.less_or_equal =>
            WriteString (File, "<=");
         when SP_Symbols.greater_than =>
            WriteString (File, ">");
         when SP_Symbols.greater_or_equal =>
            WriteString (File, ">=");
         when SP_Symbols.multiply =>
            WriteString (File, "*");
         when SP_Symbols.divide =>
            WriteString (File, "/");
         when SP_Symbols.double_star =>
            WriteString (File, "**");
         when SP_Symbols.RWabs =>
            WriteString (File, "abs");
         when others =>
            WriteString (File, "not");
      end case;
   end WriteOperatorName;

   --------------------------------------------------------------------------------

   procedure WriteUnaryOperatorRenamingDeclaration (Name    : in SP_Symbols.SP_Symbol;
                                                    Operand : in Symbol;
                                                    Scope   : in Scopes)
   --# global in     Dict;
   --#        in     LexTokenManager.State;
   --#        in out SPARK_IO.File_Sys;
   --# derives SPARK_IO.File_Sys from *,
   --#                                Dict,
   --#                                LexTokenManager.State,
   --#                                Name,
   --#                                Operand,
   --#                                Scope;
   is
   begin
      WriteString (Dict.TemporaryFile, "unary operator ");
      WriteOperatorName (Dict.TemporaryFile, Name);
      WriteString (Dict.TemporaryFile, " ");
      WriteName (Dict.TemporaryFile, Operand);
      WriteString (Dict.TemporaryFile, " is renamed in ");
      WriteScope (Dict.TemporaryFile, Scope);
      WriteLine (Dict.TemporaryFile, " ;");
   end WriteUnaryOperatorRenamingDeclaration;

   --------------------------------------------------------------------------------

   procedure WriteBinaryOperatorRenamingDeclaration
     (Name  : in SP_Symbols.SP_Symbol;
      Left  : in Symbol;
      Right : in Symbol;
      Scope : in Scopes)
   --# global in     Dict;
   --#        in     LexTokenManager.State;
   --#        in out SPARK_IO.File_Sys;
   --# derives SPARK_IO.File_Sys from *,
   --#                                Dict,
   --#                                Left,
   --#                                LexTokenManager.State,
   --#                                Name,
   --#                                Right,
   --#                                Scope;
   is
   begin
      WriteString (Dict.TemporaryFile, "binary operator ");
      WriteName (Dict.TemporaryFile, Left);
      WriteString (Dict.TemporaryFile, " ");
      WriteOperatorName (Dict.TemporaryFile, Name);
      WriteString (Dict.TemporaryFile, " ");
      WriteName (Dict.TemporaryFile, Right);
      WriteString (Dict.TemporaryFile, " is renamed in ");
      WriteScope (Dict.TemporaryFile, Scope);
      WriteLine (Dict.TemporaryFile, " ;");
   end WriteBinaryOperatorRenamingDeclaration;

   --------------------------------------------------------------------------------

begin
   Name  := RawDict.GetOperatorName (Operator);
   Left  := RawDict.GetOperatorLeftOperand (Operator);
   Right := RawDict.GetOperatorRightOperand (Operator);
   if Left = NullSymbol then
      WriteUnaryOperatorRenamingDeclaration (Name, Right, Scope);
   else
      WriteBinaryOperatorRenamingDeclaration (Name, Left, Right, Scope);
   end if;
end WriteOperatorRenamingDeclaration;
