
#include "configgeneralpage.h"

#include "config.h"

#include <klocale.h>
#include <kcombobox.h>
#include <knuminput.h>
#include <kiconloader.h>
#include <klineedit.h>
#include <kpushbutton.h>
#include <kfiledialog.h>

#include <qlayout.h>
#include <qlabel.h>
#include <qcheckbox.h>
#include <qtooltip.h>
#include <qdir.h>
#include <qregexp.h>

// ### soundkonverter 0.4: add an option to use vfat save names when the output device is vfat

ConfigGeneralPage::ConfigGeneralPage( Config* _config, QWidget *parent, const char *name )
    : ConfigPageBase( parent, name )
{
    config = _config;

    // create an icon loader object for loading icons
    KIconLoader* iconLoader = new KIconLoader();

    QVBoxLayout* box = new QVBoxLayout( parent, 0, 6 );

    QHBoxLayout* startTabBox = new QHBoxLayout( box, 6 );
    QLabel* lStartTab = new QLabel( i18n("Start in Mode")+":", parent, "lStartTab" );
    startTabBox->addWidget( lStartTab );
    cStartTab = new KComboBox( parent, "cStartTab" );
    cStartTab->insertItem( i18n("Last used") );
    cStartTab->insertItem( i18n("Simple") );
    cStartTab->insertItem( i18n("Detailed") );
    cStartTab->setCurrentItem( config->data.general.startTab );
    startTabBox->addWidget( cStartTab );
    connect( cStartTab, SIGNAL(activated(int)),
               this, SLOT(cfgChanged())
             );

    box->addSpacing( 5 );

    QHBoxLayout* defaultProfileBox = new QHBoxLayout( box, 6 );
    QLabel* lDefaultProfile = new QLabel( i18n("Default profile")+":", parent, "lDefaultProfile" );
    defaultProfileBox->addWidget( lDefaultProfile );
    cDefaultProfile = new KComboBox( parent, "cDefaultProfile" );
    sDefaultProfile += i18n("Very low");
    sDefaultProfile += i18n("Low");
    sDefaultProfile += i18n("Medium");
    sDefaultProfile += i18n("High");
    sDefaultProfile += i18n("Very high");
    sDefaultProfile += i18n("Lossless");
    sDefaultProfile += i18n("Hybrid");
    sDefaultProfile += config->getAllProfiles();
    sDefaultProfile.remove( i18n("Last used") );
    sDefaultProfile.remove( "Last used" );
    sDefaultProfile.prepend( i18n("Last used") );
    cDefaultProfile->insertStringList( sDefaultProfile );
    cDefaultProfile->setCurrentItem( profileIndex(config->data.general.defaultProfile) );
    defaultProfileBox->addWidget( cDefaultProfile );
    connect( cDefaultProfile, SIGNAL(activated(int)),
               this, SLOT(profileChanged())
             );
    connect( cDefaultProfile, SIGNAL(activated(int)),
               this, SLOT(cfgChanged())
             );
    QLabel* lDefaultFormat = new QLabel( i18n("Default format")+":", parent, "lDefaultFormat" );
    defaultProfileBox->addWidget( lDefaultFormat );
    cDefaultFormat = new KComboBox( parent, "cDefaultFormat" );
    defaultProfileBox->addWidget( cDefaultFormat );
    connect( cDefaultFormat, SIGNAL(activated(int)),
               this, SLOT(cfgChanged())
             );
    profileChanged();

    box->addSpacing( 5 );

/*    QHBoxLayout* defaultDirBox = new QHBoxLayout( box, 6 );
    QLabel* lDefaultDir = new QLabel( i18n("Default output directory")+":", parent, "lDefaultDir" );
    defaultDirBox->addWidget( lDefaultDir );
    lDir = new KLineEdit( parent, "lDir" );
    lDir->setText( config->data.general.defaultOutputDirectory );
    QToolTip::add( lDir, i18n("<p>The following strings are space holders, that will be replaced by the information in the meta data:</p><p>%a - Artist<br>%b - Album<br>%c - Comment<br>%d - Disc number<br>%g - Genre<br>%n - Track number<br>%p - Composer<br>%t - Title<br>%y - Year<br>%f - Original file name<p>") );
    defaultDirBox->addWidget( lDir );
    connect( lDir, SIGNAL(textChanged(const QString&)),
               this, SLOT(cfgChanged())
             );*/
    /*pDirInfo = new KPushButton( iconLoader->loadIcon("messagebox_info",KIcon::Small), "", parent, "pDirInfo" );
    QToolTip::add( pDirInfo, i18n("Information about the wildcards.") );
    defaultDirBox->addWidget( pDirInfo );
    connect( pDirInfo, SIGNAL(clicked()),
               this, SLOT(dirInfo())
             );*/
//     pDirSelect = new KPushButton( iconLoader->loadIcon("folder",KIcon::Small), "", parent, "pDirSelect" );
//     QToolTip::add( pDirSelect, i18n("Choose an output directory") );
//     defaultDirBox->addWidget( pDirSelect );
//     connect( pDirSelect, SIGNAL(clicked()),
//                this, SLOT(selectDir())
//              );

    QHBoxLayout* priorityBox = new QHBoxLayout( box, 6 );
    QLabel* lPriority = new QLabel( i18n("Process priority of the backends")+":", parent, "lPriority" );
    priorityBox->addWidget( lPriority );
    cPriority = new KComboBox( parent, "cPriority" );
    sPriority += i18n("Normal");
    sPriority += i18n("Low");
    cPriority->insertStringList( sPriority );
    cPriority->setCurrentItem( config->data.general.priority / 10 ); // NOTE that just works for 'normal' and 'low'
    priorityBox->addWidget( cPriority );
    connect( cPriority, SIGNAL(activated(int)),
               this, SLOT(cfgChanged())
             );

    box->addSpacing( 5 );

    QHBoxLayout* useVFATNamesBox = new QHBoxLayout( box, 6 );
    cUseVFATNames = new QCheckBox( i18n("Use FAT compatible output file names"), parent, "cUseVFATNames" );
    QToolTip::add( cUseVFATNames, i18n("Replaces some special characters like \'?\' by \'_\'.") );
    cUseVFATNames->setChecked( config->data.general.useVFATNames );
    useVFATNamesBox->addWidget( cUseVFATNames );
    connect( cUseVFATNames, SIGNAL(toggled(bool)),
               this, SLOT(cfgChanged())
             );

    box->addSpacing( 5 );

    QHBoxLayout* conflictHandlingBox = new QHBoxLayout( box, 6 );
    QLabel* lConflictHandling = new QLabel( i18n("Conflict handling")+":", parent, "lConflictHandling" );
    conflictHandlingBox->addWidget( lConflictHandling );
    cConflictHandling = new KComboBox( parent, "cConflictHandling" );
    QToolTip::add( cConflictHandling, i18n("Do that if the output file already exists") );
    sConflictHandling += i18n("Generate new file name");
    sConflictHandling += i18n("Skip file");
    cConflictHandling->insertStringList( sConflictHandling );
    cConflictHandling->setCurrentItem( config->data.general.conflictHandling );
    conflictHandlingBox->addWidget( cConflictHandling );
    connect( cConflictHandling, SIGNAL(activated(int)),
             this, SLOT(cfgChanged())
           );

    box->addSpacing( 5 );

    QHBoxLayout* numFilesBox = new QHBoxLayout( box, 6 );
    QLabel* lNumFiles = new QLabel( i18n("Number of files to convert at once")+":", parent, "lNumFiles" );
    numFilesBox->addWidget( lNumFiles );
    iNumFiles = new KIntSpinBox( 1, 100, 1, config->data.general.numFiles, 10, parent, "iNumFiles" );
    numFilesBox->addWidget( iNumFiles );
    connect( iNumFiles, SIGNAL(valueChanged(int)),
               this, SLOT(cfgChanged())
             );

    box->addSpacing( 5 );

    QHBoxLayout* updateDelayBox = new QHBoxLayout( box, 6 );
    QLabel* lUpdateDelay = new QLabel( i18n("Status update delay (time in msec.)")+":", parent, "lUpdateDelay" );
    updateDelayBox->addWidget( lUpdateDelay );
    iUpdateDelay = new KIntSpinBox( 100, 5000, 100, config->data.general.updateDelay, 10, parent, "iUpdateDelay" );
    QToolTip::add( iUpdateDelay, i18n("Update the progress bar in this interval (time in milliseconds)") );
    updateDelayBox->addWidget( iUpdateDelay );
    connect( iUpdateDelay, SIGNAL(valueChanged(int)),
               this, SLOT(cfgChanged())
             );

    box->addSpacing( 5 );

    QHBoxLayout* askForNewOptionsBox = new QHBoxLayout( box, 6 );
    cAskForNewOptions = new QCheckBox( i18n("Ask for new options, when adding files from external program"), parent, "cAskForNewOptions" );
    QToolTip::add( cAskForNewOptions, i18n("If you open a file with soundKonverter and soundKonverter is already running,\nyou can either be asked to define new converting options\nor the current settings from the soundKonverter main window are used.") );
    cAskForNewOptions->setChecked( config->data.general.askForNewOptions );
    askForNewOptionsBox->addWidget( cAskForNewOptions );
    connect( cAskForNewOptions, SIGNAL(toggled(bool)),
               this, SLOT(cfgChanged())
             );

    box->addSpacing( 5 );

    QHBoxLayout* executeUserScriptBox = new QHBoxLayout( box, 6 );
    cExecuteUserScript = new QCheckBox( i18n("Execute user script (for advanced users)"), parent, "cAskForNewOptions" );
    QToolTip::add( cExecuteUserScript, i18n("Executes a script after every finished conversion. Have a look at $KDEDIR/soundkonverter/userscript.sh") );
    cExecuteUserScript->setChecked( config->data.general.executeUserScript );
    executeUserScriptBox->addWidget( cExecuteUserScript );
    connect( cExecuteUserScript, SIGNAL(toggled(bool)),
             this, SLOT(cfgChanged())
           );

    box->addStretch();

    // delete the icon loader object
    delete iconLoader;
}

ConfigGeneralPage::~ConfigGeneralPage()
{}

void ConfigGeneralPage::resetDefaults()
{
    cStartTab->setCurrentItem( 0 );
    cDefaultProfile->setCurrentItem( 0 );
    cDefaultFormat->setCurrentItem( 0 );
//     lDir->setText( QDir::homeDirPath() + "/soundKonverter/%b/%d - %n - %a - %t" );
    cPriority->setCurrentItem( 1 );
    cUseVFATNames->setChecked( true );
    cConflictHandling->setCurrentItem( 0 );
    iNumFiles->setValue( 3 );
    iUpdateDelay->setValue( 500 );
    cAskForNewOptions->setChecked( true );
    cExecuteUserScript->setChecked( false );

    cfgChanged();
}

void ConfigGeneralPage::saveSettings()
{
    config->data.general.startTab = cStartTab->currentItem();
    config->data.general.defaultProfile = cDefaultProfile->currentText();
    config->data.general.defaultFormat = cDefaultFormat->currentText();
//     config->data.general.defaultOutputDirectory = lDir->text();
    config->data.general.priority = cPriority->currentItem() * 10; // NOTE that just works for 'normal' and 'low'
    config->data.general.useVFATNames = cUseVFATNames->isChecked();
    config->data.general.conflictHandling = cConflictHandling->currentItem();
    config->data.general.numFiles = iNumFiles->value();
    config->data.general.updateDelay = iUpdateDelay->value();
    config->data.general.askForNewOptions = cAskForNewOptions->isChecked();
    config->data.general.executeUserScript = cExecuteUserScript->isChecked();
}

int ConfigGeneralPage::profileIndex( const QString &string )
{
    return sDefaultProfile.findIndex( string );
}

int ConfigGeneralPage::formatIndex( const QString &string )
{
    return sDefaultFormat.findIndex( string );
}

// void ConfigGeneralPage::selectDir()
// {
//     QString startDir = lDir->text();
//     int i = startDir.find( QRegExp("%[aAbBcCdDgGnNpPtTyY]{1,1}") );
//     if( i != -1 ) {
//         i = startDir.findRev( "/", i );
//         startDir = startDir.left( i );
//     }
// 
//     QString directory = KFileDialog::getExistingDirectory( startDir, 0, i18n("Choose an output directory") );
//     if( !directory.isEmpty() ) {
//         QString dir = lDir->text();
//         i = dir.find( QRegExp("%[aAbBcCdDgGnNpPtTyY]{1,1}") );
//         if( i != -1 ) {
//             i = dir.findRev( "/", i );
//             lDir->setText( directory + dir.mid(i) );
//         }
//         else {
//             lDir->setText( directory );
//         }
//     }
// }

void ConfigGeneralPage::profileChanged()
{
    QString last;

    if( cDefaultProfile->currentText() == i18n("Last used") ) {
        last = cDefaultFormat->currentText();
        if( last.isEmpty() ) last = config->data.general.defaultFormat;
        cDefaultFormat->clear();
        sDefaultFormat = i18n("Last used");
        cDefaultFormat->insertStringList( sDefaultFormat );
        cDefaultFormat->setCurrentItem( formatIndex(last) );
        return;
    }

    ConversionOptions options = config->getProfile( cDefaultProfile->currentText() );
    if( !options.encodingOptions.sFormat.isEmpty() ) {
        last = cDefaultFormat->currentText();
        cDefaultFormat->clear();
        sDefaultFormat = options.encodingOptions.sFormat;
        cDefaultFormat->insertStringList( sDefaultFormat );
        cDefaultFormat->setCurrentItem( formatIndex(last) );
        return;
    }

    if( cDefaultProfile->currentText() == i18n("Very low") ||
      cDefaultProfile->currentText() == i18n("Low") ||
      cDefaultProfile->currentText() == i18n("Medium") ||
      cDefaultProfile->currentText() == i18n("High") ||
      cDefaultProfile->currentText() == i18n("Very high") ) {
        last = cDefaultFormat->currentText();
        if( last.isEmpty() ) last = config->data.general.defaultFormat;
        cDefaultFormat->clear();
        sDefaultFormat = i18n("Last used");
        sDefaultFormat += config->allLossyEncodableFormats();
        cDefaultFormat->insertStringList( sDefaultFormat );
        cDefaultFormat->setCurrentItem( formatIndex(last) );
    }
    else if( cDefaultProfile->currentText() == i18n("Lossless") ) {
        last = cDefaultFormat->currentText();
        if( last.isEmpty() ) last = config->data.general.defaultFormat;
        cDefaultFormat->clear();
        sDefaultFormat = i18n("Last used");
        sDefaultFormat += config->allLosslessEncodableFormats();
        sDefaultFormat += "wav";
        cDefaultFormat->insertStringList( sDefaultFormat );
        cDefaultFormat->setCurrentItem( formatIndex(last) );
    }
    else if( cDefaultProfile->currentText() == i18n("Hybrid") ) {
        last = cDefaultFormat->currentText();
        if( last.isEmpty() ) last = config->data.general.defaultFormat;
        cDefaultFormat->clear();
        sDefaultFormat = i18n("Last used");
        sDefaultFormat += config->allHybridEncodableFormats();
        cDefaultFormat->insertStringList( sDefaultFormat );
        cDefaultFormat->setCurrentItem( formatIndex(last) );
    }
}


