/*
 * ----------------------------------------------------
 *
 * PowerPC Instruction decoder
 * (C) 2004  Lightmaze Solutions AG
 *   Author: Jochen Karrer
 *
 * Status
 *      working
 *
 * ----------------------------------------------------
 */

#include <stdint.h>
#include <stdlib.h>
#include <string.h>
#include <stdio.h>
#include <idecode_ppc.h>
#include <instructions_ppc.h>


Instruction instrlist[] = {
{0xfc000000,2<<26,"tdi",i_tdi},
{0xfc000000,3<<26,"twi",i_twi},
{0xfc000000,7<<26,"mulli",i_mulli},
{0xfc000000,8<<26,"subfic",i_subfic},
{0xfc000000,10<<26,"cmpli",i_cmpli},
{0xfc000000,11<<26,"cmpi",i_cmpi},
{0xfc000000,12<<26,"addic",i_addic},
{0xfc000000,13<<26,"addic_",i_addic_},
{0xfc000000,14<<26,"addi",i_addi},
{0xfc000000,15<<26,"addis",i_addis},
{0xfc000000,16<<26,"bcx",i_bcx},
{0xfc000000,17<<26,"sc",i_sc},
{0xfc000000,18<<26,"bx",i_bx},
{0xfc0007fe,0x4c000000,"mcrf",i_mcrf},
{0xfc0007fe,0x4c000020,"bclrx",i_bclrx},
{0xfc0007fe,0x4c000042,"crnor",i_crnor},
{0xfc0007fe,0x4c000064,"rfi",i_rfi},
{0xfc0007fe,0x4c000102,"crandc",i_crandc},
{0xfc0007fe,0x4c00012c,"isync",i_isync},
{0xfc0007fe,0x4c000182,"crxor",i_crxor},
{0xfc0007fe,0x4c0001c2,"crnand",i_crnand},
{0xfc0007fe,0x4c000202,"crand",i_crand},
{0xfc0007fe,0x4c000242,"creqv",i_creqv},
{0xfc0007fe,0x4c000342,"crorc",i_crorc},
{0xfc0007fe,0x4c000382,"cror",i_cror},
{0xfc0007fe,0x4c000420,"bcctrx",i_bcctrx},
{0xfc000000,20<<26,"rlwimix",i_rlwimix },
{0xfc000000,21<<26,"rlwinmx",i_rlwinmx},
{0xfc000000,23<<26,"rlwnmx",i_rlwnmx },
{0xfc000000,24<<26,"ori",i_ori      },
{0xfc000000,25<<26,"oris",i_oris   },
{0xfc000000,26<<26,"xori",i_xori  },
{0xfc000000,27<<26,"xoris",i_xoris},
{0xfc000000,28<<26,"andi.",i_andi_ },
{0xfc000000,29<<26,"andis.",i_andis_},
{0xfc00001c,0x78000000,"rldiclx",i_rldiclx},
{0xfc00001c,0x78000004,"rldicrx",i_rldicrx},
{0xfc00001c,0x78000008,"rldicx",i_rldicx},
{0xfc00001c,0x7800000c,"rldimix",i_rldimix},
{0xfc00003e,0x78000080,"rldclx",i_rldclx},
{0xfc00003e,0x78000082,"rldcrx",i_rldcrx},
{0xfc0007fe,0x7c000000,"cmp",i_cmp},
{0xfc0007fe,0x7c000008,"tw",i_tw},
{0xfc0003fe,0x7c000010,"subfcx",i_subfcx},
{0xfc0007fe,0x7c000012,"mulhdux",i_mulhdux},
{0xfc0003fe,0x7c000014,"addcx",i_addcx},
{0xfc0007fe,0x7c000016,"mulhwux",i_mulhwux},
{0xfc0007fe,0x7c000026,"mfcr",i_mfcr},
{0xfc0007fe,0x7c000028,"lwarx",i_lwarx},
{0xfc0007fe,0x7c00002a,"ldx",i_ldx},
{0xfc0007fe,0x7c00002e,"lwzx",i_lwzx},
{0xfc0007fe,0x7c000030,"slwx",i_slwx},
{0xfc0007fe,0x7c000034,"cntlzwx",i_cntlzwx},
{0xfc0007fe,0x7c000036,"sldx",i_sldx},
{0xfc0007fe,0x7c000038,"andx",i_andx},
{0xfc0007fe,0x7c000040,"cmpl",i_cmpl},
{0xfc0003fe,0x7c000050,"subfx",i_subfx},
{0xfc0007fe,0x7c00006a,"ldux",i_ldux},
{0xfc0007fe,0x7c00006c,"dcbst",i_dcbst},
{0xfc0007fe,0x7c00006e,"lwzux",i_lwzux},
{0xfc0007fe,0x7c000074,"zntlzdx",i_zntlzdx},
{0xfc0007fe,0x7c000078,"andcx",i_andcx},
{0xfc0007fe,0x7c000088,"td",i_td},
{0xfc0007fe,0x7c000092,"mulhdx",i_mulhdx},
{0xfc0007fe,0x7c000096,"mulhwx",i_mulhwx},
{0xfc0007fe,0x7c0000a6,"mfmsr",i_mfmsr},
{0xfc0007fe,0x7c0000a8,"ldarx",i_ldarx},
{0xfc0007fe,0x7c0000ac,"dcbf",i_dcbf},
{0xfc0007fe,0x7c0000ae,"lbzx",i_lbzx},
{0xfc0003fe,0x7c0000d0,"negx",i_negx},
{0xfc0007fe,0x7c0000ee,"lbzux",i_lbzux},
{0xfc0007fe,0x7c0000f8,"norx",i_norx},
{0xfc0003fe,0x7c000110,"subfex",i_subfex},
{0xfc0003fe,0x7c000114,"addex",i_addex},
{0xfc0007fe,0x7c000120,"mtcrf",i_mtcrf},
{0xfc0007fe,0x7c000124,"mtmsr",i_mtmsr},
{0xfc0007fe,0x7c00012a,"stdx",i_stdx},
{0xfc0007fe,0x7c00012c,"stwcx.",i_stwcx_},
{0xfc0007fe,0x7c00012e,"stwx",i_stwx},
{0xfc0007fe,0x7c00016a,"stdux",i_stdux},
{0xfc0007fe,0x7c00016e,"stwux",i_stwux},
{0xfc0003fe,0x7c000190,"subfzex",i_subfzex},
{0xfc0003fe,0x7c000194,"addzex",i_addzex},
{0xfc0007fe,0x7c0001a4,"mtsr",i_mtsr},
{0xfc0007fe,0x7c0001ac,"stdcx",i_stdcx},
{0xfc0007fe,0x7c0001ae,"stbx",i_stbx},
{0xfc0003fe,0x7c0001d0,"subfmex",i_subfmex},
{0xfc0003fe,0x7c0001d2,"mulld",i_mulld},
{0xfc0003fe,0x7c0001d4,"addmex",i_addmex},
{0xfc0003fe,0x7c0001d6,"mullwx",i_mullwx},
{0xfc0007fe,0x7c0001e4,"mtsrin",i_mtsrin},
{0xfc0007fe,0x7c0001ec,"dcbtst",i_dcbtst},
{0xfc0007fe,0x7c0001ee,"stbux",i_stbux},
{0xfc0003fe,0x7c000214,"addx",i_addx},
{0xfc0007fe,0x7c00022c,"dcbt",i_dcbt},

{0xfc0007fe,0x7c00022e,"lhzx",i_lhzx},
{0xfc0007fe,0x7c000238,"eqvx",i_eqvx},
{0xfc0007fe,0x7c000264,"tlbie",i_tlbie},
{0xfc0007fe,0x7c00026c,"eciwx",i_eciwx},
{0xfc0007fe,0x7c00026e,"lhzux",i_lhzux},
{0xfc0007fe,0x7c000278,"xorx",i_xorx},
{0xfc0007fe,0x7c0002a6,"mfspr",i_mfspr},
{0xfc0007fe,0x7c0002aa,"lwax",i_lwax},
{0xfc0007fe,0x7c0002ae,"lhax",i_lhax},
{0xfc0007fe,0x7c0002e4,"tlbia",i_tlbia},
{0xfc0007fe,0x7c0002e6,"mftb",i_mftb},
{0xfc0007fe,0x7c0002ea,"lwaux",i_lwaux},
{0xfc0007fe,0x7c0002ee,"lhaux",i_lhaux},
{0xfc0007fe,0x7c00032e,"sthx",i_sthx},
{0xfc0007fe,0x7c000338,"orcx",i_orcx},
//{0xfc0007fe,0x7c000,}, // sradix stimmt was net in doku
{0xfc0007fe,0x7c000364,"slbie",i_slbie},
{0xfc0007fe,0x7c00036c,"ecowx",i_ecowx},
{0xfc0007fe,0x7c00036e,"sthux",i_sthux},
{0xfc0007fe,0x7c000378,"orx",i_orx},
{0xfc0003fe,0x7c000392,"divdux",i_divdux},
{0xfc0003fe,0x7c000396,"divwux",i_divwux},
{0xfc0007fe,0x7c0003a6,"mtspr",i_mtspr},
{0xfc0007fe,0x7c0003ac,"dcbi",i_dcbi},
{0xfc0007fe,0x7c0003b8,"nandx",i_nandx},
{0xfc0003fe,0x7c0003d2,"divdx",i_divdx},
{0xfc0003fe,0x7c0003d6,"divwx",i_divwx},
{0xfc0007fe,0x7c0003e4,"slbia",i_slbia},
{0xfc0007fe,0x7c000400,"mcrxr",i_mcrxr},
{0xfc0007fe,0x7c00042a,"lswx",i_lswx},
{0xfc0007fe,0x7c00042c,"lwbrx",i_lwbrx},
{0xfc0007fe,0x7c00042e,"lfsx",i_lfsx},
{0xfc0007fe,0x7c000430,"srwx",i_srwx},
{0xfc0007fe,0x7c000436,"srdx",i_srdx},
{0xfc0007fe,0x7c00046c,"tlbsync",i_tlbsync},
{0xfc0007fe,0x7c00046e,"lfsux",i_lfsux},
{0xfc0007fe,0x7c0004a6,"mfsr",i_mfsr},
{0xfc0007fe,0x7c0004aa,"lswi",i_lswi},
{0xfc0007fe,0x7c0004ac,"sync",i_sync},
{0xfc0007fe,0x7c0004ae,"lfdx",i_lfdx},
{0xfc0007fe,0x7c0004ee,"lfdux",i_lfdux},
{0xfc0007fe,0x7c000526,"mfsrin",i_mfsrin},
{0xfc0007fe,0x7c00052a,"stswx",i_stswx},
{0xfc0007fe,0x7c00052c,"stwbrx",i_stwbrx},
{0xfc0007fe,0x7c00052e,"stfsx",i_stfsx},
{0xfc0007fe,0x7c00056e,"stfsux",i_stfsux},
{0xfc0007fe,0x7c0005aa,"stswi",i_stswi},
{0xfc0007fe,0x7c0005ae,"stfdx",i_stfdx},
{0xfc0007fe,0x7c0005ec,"dcba",i_dcba},
{0xfc0007fe,0x7c0005ee,"stfdux",i_stfdux},
{0xfc0007fe,0x7c00062e,"lhbrx",i_lhbrx},
{0xfc0007fe,0x7c000630,"srawx",i_srawx},
{0xfc0007fe,0x7c000634,"sradx",i_sradx},
{0xfc0007fe,0x7c000670,"srawix",i_srawix},
{0xfc0007fe,0x7c0006ac,"eieio",i_eieio},
{0xfc0007fe,0x7c000726,"sthbrx",i_sthbrx},
{0xfc0007fe,0x7c000734,"extshx",i_extshx},
{0xfc0007fe,0x7c000774,"extsbx",i_extsbx},
{0xfc0007fe,0x7c0007ac,"icbi",i_icbi},
{0xfc0007fe,0x7c0007ae,"stfiwx",i_stfiwx},
{0xfc0007fe,0x7c0007b4,"extsw",i_extsw},
{0xfc0007fe,0x7c0007ec,"dcbz",i_dcbz},

{0xfc000000,32<<26,"lwz",i_lwz     },
{0xfc000000,33<<26,"lwzu",i_lwzu  },
{0xfc000000,34<<26,"lbz",i_lbz   },
{0xfc000000,35<<26,"lbzu",i_lbzu },
{0xfc000000,36<<26,"stw",i_stw  },
{0xfc000000,37<<26,"stwu",i_stwu},
{0xfc000000,38<<26,"stb",i_stb },
{0xfc000000,39<<26,"stbu",i_stbu},
{0xfc000000,40<<26,"lhz",i_lhz },
{0xfc000000,41<<26,"lhzu",i_lhzu},
{0xfc000000,42<<26,"lha",i_lha },
{0xfc000000,43<<26,"lhau",i_lhau},
{0xfc000000,44<<26,"sth",i_sth  },
{0xfc000000,45<<26,"sthu",i_sthu},
{0xfc000000,46<<26,"lmw",i_lmw },
{0xfc000000,47<<26,"stmw",i_stmw},
{0xfc000000,48<<26,"lfs",i_lfs },
{0xfc000000,49<<26,"lfsu",i_lfsu},
{0xfc000000,50<<26,"lfd",i_lfd },
{0xfc000000,51<<26,"lfdu",i_lfdu},
{0xfc000000,52<<26,"stfs",i_stfs},
{0xfc000000,53<<26,"stfsu",i_stfsu},
{0xfc000000,54<<26,"stfd",i_stfd },
{0xfc000000,55<<26,"stfdu",i_stfdu},
{0xfc000003,0xe8000000,"ld",i_ld},
{0xfc000003,0xe8000001,"ldu",i_ldu},
{0xfc000003,0xe8000002,"lwa",i_lwa},
{0xfc0007fe,0xec000024,"fdivsx",i_fdivsx},
{0xfc0007fe,0xec000028,"fsubsx",i_fsubsx},
{0xfc0007fe,0xec00002a,"faddsx",i_faddsx},
{0xfc0007fe,0xec00002c,"fsqrtsx",i_fsqrtsx},
{0xfc0007fe,0xec000030,"fresx",i_fsresx},
{0xfc00003e,0xec000032,"fmulsx",i_fmulsx},
{0xfc00003e,0xec000038,"fmsubsx",i_fmsubsx},
{0xfc00003e,0xec00003a,"fmaddsx",i_fmaddsx},
{0xfc00003e,0xec00003c,"fnmsubsx",i_fnmsubsx},
{0xfc00003e,0xec00003e,"fnmaddsx",i_fnmaddsx},
{0xfc000003,0xf8000000,"std",i_std},
{0xfc000003,0xf8000001,"stdu",i_stdu},
{0xfc0007fe,0xfc000000,"fcmpu",i_fcmpu},
{0xfc0007fe,0xfc000018,"frspx",i_frspx},
{0xfc0007fe,0xfc00001c,"fctiwx",i_fctiwx},
{0xfc0007fe,0xfc00001e,"fctiwzx",i_fctiwzx},
{0xfc0007fe,0xfc000024,"fdivx",i_fdivx},
{0xfc0007fe,0xfc000028,"fsubx",i_fsubx},
{0xfc0007fe,0xfc00002a,"faddx",i_faddx},
{0xfc0007fe,0xfc00002c,"fsqrtx",i_fsqrtx},
{0xfc00003e,0xfc00002e,"fselx",i_fselx},
{0xfc00003e,0xfc000032,"fmulx",i_fmulx},
{0xfc0007fe,0xfc000034,"fsqrtex",i_fsqrtex},
{0xfc00003e,0xfc000038,"fmsubx",i_fmsubx},
{0xfc00003e,0xfc00003a,"fmaddx",i_fmaddx},
{0xfc00003e,0xfc00003c,"fnmsubx",i_fnmsubx},
{0xfc00003e,0xfc00003e,"fnmaddx",i_fnmaddx},
{0xfc0007fe,0xfc000040,"fcmpo",i_fcmpo},
{0xfc0007fe,0xfc00004c,"mtfsb1x",i_mtfsb1x},
{0xfc0007fe,0xfc000050,"fnegx",i_fnegx},
{0xfc0007fe,0xfc000080,"mcrfs",i_mcrfs},
{0xfc0007fe,0xfc00008c,"mtfsb0x",i_mtfsb0x},
{0xfc0007fe,0xfc000090,"fmrx",i_fmrx},
{0xfc0007fe,0xfc00010c,"mtfsfix",i_mtfsfix},
{0xfc0007fe,0xfc000110,"fnabsx",i_fnabsx},
{0xfc0007fe,0xfc000210,"fabsx",i_fabsx},
{0xfc0007fe,0xfc00048e,"mffsx",i_mffsx},
{0xfc0007fe,0xfc00058e,"mtfsfx",i_mtfsfx},
{0xfc0007fe,0xfc00065e,"fctdix",i_fctdix},
{0xfc0007fe,0xfc00069e,"fcfidx",i_fcfidx},
{0x0,0x0,""  ,NULL}
};

Instruction instr_undefined = {0x00000000,0xffffffff,"und",i_und};

/* 
 * ---------------------------------------------------------
 * Unfortunately Global Variables are faster than structs
 * ---------------------------------------------------------
 */

InstructionProc **iProcTab;
Instruction **instructions;

void
IDecoder_New(int cpu_type) {
	int i;
	iProcTab=(InstructionProc**)malloc(sizeof(InstructionProc*)*(INSTR_INDEX_MAX+1));
	if(!iProcTab) {
		fprintf(stderr,"Out of memory\n");
		exit(3243);
	}
	memset(iProcTab,0,sizeof(InstructionProc *)*(INSTR_INDEX_MAX+1));
	instructions = (Instruction **)malloc(sizeof(Instruction *)*(INSTR_INDEX_MAX+1));
	if(!instructions) {
		fprintf(stderr,"Out of memory\n");
		exit(3532);
	}
	memset(instructions,0,sizeof(Instruction *)*(INSTR_INDEX_MAX+1));
	
	for(i=0;i<=INSTR_INDEX_MAX;i++) {
		Instruction *inst;
		uint32_t icode=INSTR_UNINDEX(i);
		for(inst=instrlist;inst->proc;inst=inst++) {
			if((icode&inst->mask) == inst->value) {
				if(iProcTab[i]) {
					fprintf(stderr,"Busy icode %08x, index %d\n",icode,i);
				} else {
					iProcTab[i]=inst->proc;
					instructions[i]=inst;
				}
			}
		}
		if(iProcTab[i]==NULL) {
			iProcTab[i] = i_und;
			instructions[i] = &instr_undefined;
		}
	}
	fprintf(stderr,"PPC Instruction decoder Initialized\n");
}

#ifdef TEST
int
main() {
	IDecoder_New();
	exit(0);
}
#endif
