#ifndef COPROCESSOR_H
#define COPROCESSOR_H
#include <stdint.h>

typedef struct ArmCoprocessor {
        void *owner;
        uint32_t (*mrc)(struct ArmCoprocessor *,int opcode_1,int crn,int crm,int opcode_2);
        void (*mcr)(struct ArmCoprocessor *,int opcode_1,uint32_t value,int crn,int crm,int opcode_2);
        void (*cdp)(struct ArmCoprocessor *,uint32_t icode);
        void (*ldc)(struct ArmCoprocessor *,uint32_t icode);
        void (*stc)(struct ArmCoprocessor *,uint32_t icode);
} ArmCoprocessor;

#endif
