/*
 * This file is part of the Sofia-SIP package
 *
 * Copyright (C) 2005 Nokia Corporation.
 *
 * Contact: Pekka Pessi <pekka.pessi@nokia.com>
 *
 * This library is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation; either version 2.1 of
 * the License, or (at your option) any later version.
 *
 * This library is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public
 * License along with this library; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA
 * 02110-1301 USA
 *
 */

/**@file http_tag.c  HTTP Tag classes
 *
 * This file is autogenerated from <http_tag.c.in>.
 *
 * This file is automatically generated from <http.h> by msg_parser.awk.
 * 
 * @author Pekka Pessi <Pekka.Pessi@nokia.com>
 */

#include "config.h"

#define TAG_NAMESPACE "http"

#include <assert.h>
#include <stddef.h>
#include <string.h>

#include <sofia-sip/su.h>

#include <sofia-sip/http.h>
#include <sofia-sip/http_protos.h>
#include <sofia-sip/http_tag.h>
#include <sofia-sip/http_tag_class.h>

tag_typedef_t httptag_any = NSTAG_TYPEDEF(*);

tag_typedef_t httptag_http = HTTPMSGTAG_TYPEDEF(http);
tag_typedef_t httptag_version = STRTAG_TYPEDEF(version);
tag_typedef_t httptag_header = 
	{{ TAG_NAMESPACE, "header", httphdrtag_class, 0 }};
tag_typedef_t httptag_header_str = STRTAG_TYPEDEF(header_str);


tag_typedef_t httptag_request = HTTPHDRTAG_TYPEDEF(request);
tag_typedef_t httptag_request_str = HTTPSTRTAG_TYPEDEF(request);

tag_typedef_t httptag_status = HTTPHDRTAG_TYPEDEF(status);
tag_typedef_t httptag_status_str = HTTPSTRTAG_TYPEDEF(status);

tag_typedef_t httptag_accept = HTTPHDRTAG_TYPEDEF(accept);
tag_typedef_t httptag_accept_str = HTTPSTRTAG_TYPEDEF(accept);

tag_typedef_t httptag_accept_charset = HTTPHDRTAG_TYPEDEF(accept_charset);
tag_typedef_t httptag_accept_charset_str = HTTPSTRTAG_TYPEDEF(accept_charset);

tag_typedef_t httptag_accept_encoding = HTTPHDRTAG_TYPEDEF(accept_encoding);
tag_typedef_t httptag_accept_encoding_str = HTTPSTRTAG_TYPEDEF(accept_encoding);

tag_typedef_t httptag_accept_language = HTTPHDRTAG_TYPEDEF(accept_language);
tag_typedef_t httptag_accept_language_str = HTTPSTRTAG_TYPEDEF(accept_language);

tag_typedef_t httptag_accept_ranges = HTTPHDRTAG_TYPEDEF(accept_ranges);
tag_typedef_t httptag_accept_ranges_str = HTTPSTRTAG_TYPEDEF(accept_ranges);

tag_typedef_t httptag_allow = HTTPHDRTAG_TYPEDEF(allow);
tag_typedef_t httptag_allow_str = HTTPSTRTAG_TYPEDEF(allow);

tag_typedef_t httptag_authentication_info = HTTPHDRTAG_TYPEDEF(authentication_info);
tag_typedef_t httptag_authentication_info_str = HTTPSTRTAG_TYPEDEF(authentication_info);

tag_typedef_t httptag_authorization = HTTPHDRTAG_TYPEDEF(authorization);
tag_typedef_t httptag_authorization_str = HTTPSTRTAG_TYPEDEF(authorization);

tag_typedef_t httptag_age = HTTPHDRTAG_TYPEDEF(age);
tag_typedef_t httptag_age_str = HTTPSTRTAG_TYPEDEF(age);

tag_typedef_t httptag_cache_control = HTTPHDRTAG_TYPEDEF(cache_control);
tag_typedef_t httptag_cache_control_str = HTTPSTRTAG_TYPEDEF(cache_control);

tag_typedef_t httptag_connection = HTTPHDRTAG_TYPEDEF(connection);
tag_typedef_t httptag_connection_str = HTTPSTRTAG_TYPEDEF(connection);

tag_typedef_t httptag_date = HTTPHDRTAG_TYPEDEF(date);
tag_typedef_t httptag_date_str = HTTPSTRTAG_TYPEDEF(date);

tag_typedef_t httptag_etag = HTTPHDRTAG_TYPEDEF(etag);
tag_typedef_t httptag_etag_str = HTTPSTRTAG_TYPEDEF(etag);

tag_typedef_t httptag_expect = HTTPHDRTAG_TYPEDEF(expect);
tag_typedef_t httptag_expect_str = HTTPSTRTAG_TYPEDEF(expect);

tag_typedef_t httptag_expires = HTTPHDRTAG_TYPEDEF(expires);
tag_typedef_t httptag_expires_str = HTTPSTRTAG_TYPEDEF(expires);

tag_typedef_t httptag_from = HTTPHDRTAG_TYPEDEF(from);
tag_typedef_t httptag_from_str = HTTPSTRTAG_TYPEDEF(from);

tag_typedef_t httptag_host = HTTPHDRTAG_TYPEDEF(host);
tag_typedef_t httptag_host_str = HTTPSTRTAG_TYPEDEF(host);

tag_typedef_t httptag_if_match = HTTPHDRTAG_TYPEDEF(if_match);
tag_typedef_t httptag_if_match_str = HTTPSTRTAG_TYPEDEF(if_match);

tag_typedef_t httptag_if_modified_since = HTTPHDRTAG_TYPEDEF(if_modified_since);
tag_typedef_t httptag_if_modified_since_str = HTTPSTRTAG_TYPEDEF(if_modified_since);

tag_typedef_t httptag_if_none_match = HTTPHDRTAG_TYPEDEF(if_none_match);
tag_typedef_t httptag_if_none_match_str = HTTPSTRTAG_TYPEDEF(if_none_match);

tag_typedef_t httptag_if_range = HTTPHDRTAG_TYPEDEF(if_range);
tag_typedef_t httptag_if_range_str = HTTPSTRTAG_TYPEDEF(if_range);

tag_typedef_t httptag_if_unmodified_since = HTTPHDRTAG_TYPEDEF(if_unmodified_since);
tag_typedef_t httptag_if_unmodified_since_str = HTTPSTRTAG_TYPEDEF(if_unmodified_since);

tag_typedef_t httptag_last_modified = HTTPHDRTAG_TYPEDEF(last_modified);
tag_typedef_t httptag_last_modified_str = HTTPSTRTAG_TYPEDEF(last_modified);

tag_typedef_t httptag_location = HTTPHDRTAG_TYPEDEF(location);
tag_typedef_t httptag_location_str = HTTPSTRTAG_TYPEDEF(location);

tag_typedef_t httptag_max_forwards = HTTPHDRTAG_TYPEDEF(max_forwards);
tag_typedef_t httptag_max_forwards_str = HTTPSTRTAG_TYPEDEF(max_forwards);

tag_typedef_t httptag_pragma = HTTPHDRTAG_TYPEDEF(pragma);
tag_typedef_t httptag_pragma_str = HTTPSTRTAG_TYPEDEF(pragma);

tag_typedef_t httptag_proxy_authenticate = HTTPHDRTAG_TYPEDEF(proxy_authenticate);
tag_typedef_t httptag_proxy_authenticate_str = HTTPSTRTAG_TYPEDEF(proxy_authenticate);

tag_typedef_t httptag_proxy_authorization = HTTPHDRTAG_TYPEDEF(proxy_authorization);
tag_typedef_t httptag_proxy_authorization_str = HTTPSTRTAG_TYPEDEF(proxy_authorization);

tag_typedef_t httptag_range = HTTPHDRTAG_TYPEDEF(range);
tag_typedef_t httptag_range_str = HTTPSTRTAG_TYPEDEF(range);

tag_typedef_t httptag_referer = HTTPHDRTAG_TYPEDEF(referer);
tag_typedef_t httptag_referer_str = HTTPSTRTAG_TYPEDEF(referer);

tag_typedef_t httptag_retry_after = HTTPHDRTAG_TYPEDEF(retry_after);
tag_typedef_t httptag_retry_after_str = HTTPSTRTAG_TYPEDEF(retry_after);

tag_typedef_t httptag_server = HTTPHDRTAG_TYPEDEF(server);
tag_typedef_t httptag_server_str = HTTPSTRTAG_TYPEDEF(server);

tag_typedef_t httptag_te = HTTPHDRTAG_TYPEDEF(te);
tag_typedef_t httptag_te_str = HTTPSTRTAG_TYPEDEF(te);

tag_typedef_t httptag_trailer = HTTPHDRTAG_TYPEDEF(trailer);
tag_typedef_t httptag_trailer_str = HTTPSTRTAG_TYPEDEF(trailer);

tag_typedef_t httptag_transfer_encoding = HTTPHDRTAG_TYPEDEF(transfer_encoding);
tag_typedef_t httptag_transfer_encoding_str = HTTPSTRTAG_TYPEDEF(transfer_encoding);

tag_typedef_t httptag_upgrade = HTTPHDRTAG_TYPEDEF(upgrade);
tag_typedef_t httptag_upgrade_str = HTTPSTRTAG_TYPEDEF(upgrade);

tag_typedef_t httptag_user_agent = HTTPHDRTAG_TYPEDEF(user_agent);
tag_typedef_t httptag_user_agent_str = HTTPSTRTAG_TYPEDEF(user_agent);

tag_typedef_t httptag_vary = HTTPHDRTAG_TYPEDEF(vary);
tag_typedef_t httptag_vary_str = HTTPSTRTAG_TYPEDEF(vary);

tag_typedef_t httptag_via = HTTPHDRTAG_TYPEDEF(via);
tag_typedef_t httptag_via_str = HTTPSTRTAG_TYPEDEF(via);

tag_typedef_t httptag_warning = HTTPHDRTAG_TYPEDEF(warning);
tag_typedef_t httptag_warning_str = HTTPSTRTAG_TYPEDEF(warning);

tag_typedef_t httptag_www_authenticate = HTTPHDRTAG_TYPEDEF(www_authenticate);
tag_typedef_t httptag_www_authenticate_str = HTTPSTRTAG_TYPEDEF(www_authenticate);

tag_typedef_t httptag_proxy_connection = HTTPHDRTAG_TYPEDEF(proxy_connection);
tag_typedef_t httptag_proxy_connection_str = HTTPSTRTAG_TYPEDEF(proxy_connection);

tag_typedef_t httptag_set_cookie = HTTPHDRTAG_TYPEDEF(set_cookie);
tag_typedef_t httptag_set_cookie_str = HTTPSTRTAG_TYPEDEF(set_cookie);

tag_typedef_t httptag_cookie = HTTPHDRTAG_TYPEDEF(cookie);
tag_typedef_t httptag_cookie_str = HTTPSTRTAG_TYPEDEF(cookie);

tag_typedef_t httptag_mime_version = HTTPHDRTAG_TYPEDEF(mime_version);
tag_typedef_t httptag_mime_version_str = HTTPSTRTAG_TYPEDEF(mime_version);

tag_typedef_t httptag_content_encoding = HTTPHDRTAG_TYPEDEF(content_encoding);
tag_typedef_t httptag_content_encoding_str = HTTPSTRTAG_TYPEDEF(content_encoding);

tag_typedef_t httptag_content_language = HTTPHDRTAG_TYPEDEF(content_language);
tag_typedef_t httptag_content_language_str = HTTPSTRTAG_TYPEDEF(content_language);

tag_typedef_t httptag_content_length = HTTPHDRTAG_TYPEDEF(content_length);
tag_typedef_t httptag_content_length_str = HTTPSTRTAG_TYPEDEF(content_length);

tag_typedef_t httptag_content_location = HTTPHDRTAG_TYPEDEF(content_location);
tag_typedef_t httptag_content_location_str = HTTPSTRTAG_TYPEDEF(content_location);

tag_typedef_t httptag_content_md5 = HTTPHDRTAG_TYPEDEF(content_md5);
tag_typedef_t httptag_content_md5_str = HTTPSTRTAG_TYPEDEF(content_md5);

tag_typedef_t httptag_content_range = HTTPHDRTAG_TYPEDEF(content_range);
tag_typedef_t httptag_content_range_str = HTTPSTRTAG_TYPEDEF(content_range);

tag_typedef_t httptag_content_type = HTTPHDRTAG_TYPEDEF(content_type);
tag_typedef_t httptag_content_type_str = HTTPSTRTAG_TYPEDEF(content_type);

tag_typedef_t httptag_unknown = HTTPHDRTAG_TYPEDEF(unknown);
tag_typedef_t httptag_unknown_str = HTTPSTRTAG_TYPEDEF(unknown);

tag_typedef_t httptag_error = HTTPHDRTAG_TYPEDEF(error);
tag_typedef_t httptag_error_str = HTTPSTRTAG_TYPEDEF(error);

tag_typedef_t httptag_separator = HTTPHDRTAG_TYPEDEF(separator);
tag_typedef_t httptag_separator_str = HTTPSTRTAG_TYPEDEF(separator);

tag_typedef_t httptag_payload = HTTPHDRTAG_TYPEDEF(payload);
tag_typedef_t httptag_payload_str = HTTPSTRTAG_TYPEDEF(payload);

