<?php
/*  
 * Analysis Console for Incident Databases (ACID)
 *
 * Author: Roman Danyliw <rdd@cert.org>, <roman@danyliw.com>
 *
 * Copyright (C) 2000 Carnegie Mellon University
 * (see the file 'acid_main.php' for license details)
 *
 * Purpose:   
 *
 */
?>

<?php
  include("acid_conf.php");
  include("acid_db.inc");
  include("acid_db_common.php");
  include("acid_common.php");
?>

<!doctype html public "-//w3c//dtd html 4.0 transitional//en">
<!-- Analysis Console for Incident Databases (ACID) <?php echo $ACID_VERSION; ?> -->
<HTML>
  <HEAD>
    <META name="Author" content="Roman Danyliw">
    <TITLE>ACID: Setup</TITLE>
    <LINK rel="stylesheet" type="text/css" href="acid_style.css">
</HEAD>

<BODY>

<TABLE WIDTH="100%" BORDER=0 CELLSPACING=0 CELLPADDING=5>
<TR>
  <TD class="mainheader">
     <?php
       include("acid_hdr1.html");
     ?>
  </TD>
  <TD class="mainheadertitle">Setup</TD>
  <TD class="mainheader" ALIGN=RIGHT>
     <?php
       include("acid_hdr2.html");
     ?>
  </TD>
</TR>
</TABLE>
<P><P>

<FORM METHOD="POST"
      ACTION="acid_db_setup.php">

<?php
  /* Connect to the Alert database */
  $db = NewACIDDBConnection($DBlib_path, $DBtype);
  $db->acidPConnect($alert_dbname, $alert_host, $alert_port, $alert_user, $alert_password);

  $tblAcidAG_present = $db->acidTableExists("acid_ag");
  $tblAcidAGAlert_present = $db->acidTableExists("acid_ag_alert");
  $tblAcidIPCache_present = $db->acidTableExists("acid_ip_cache");
  $index_event_sig_present = $db->acidIndexExists("event", "signature");
  $index_event_time_present = $db->acidIndexExists("event", "timestamp");

  if ( $debug_mode > 0 )
  {
     echo "\$submit = $submit <BR>
           table acid_ag present? $tblAcidAG_present <BR>
           table acid_ag_alert present? $tblAcidAGAlert_present <BR>
           table acid_ip_cache present? $tblAcidIPCache_present <BR>
           index event.signature present? $index_event_sig_present <BR>
           index event.time present? $index_event_time_present <BR>";
  }

  if ( $submit == "Create ACID AG" )
  {
     if ( !$tblAcidAG_present )
     {
        if ( ($db->DB_type == "mysql") || ($db->DB_type == "mysqlt") || ($db->DB_type == "maxsql") )
        {         
         $sql = '
                CREATE TABLE acid_ag ( ag_id               INT           UNSIGNED NOT NULL AUTO_INCREMENT,
                                       ag_name             VARCHAR(40),
                                       ag_desc             TEXT, 
                                       ag_ctime            DATETIME,
                                       ag_ltime            DATETIME,

                                       PRIMARY KEY         (ag_id),
                                       INDEX               (ag_id))';
        }
        else if ($db->DB_type == "postgres")
        {
         $sql = '
                CREATE TABLE acid_ag ( ag_id               SERIAL NOT NULL,
                                       ag_name             TEXT,
                                       ag_desc             TEXT, 
                                       ag_ctime            DATETIME,
                                       ag_ltime            DATETIME,

                                       PRIMARY KEY         (ag_id))'; 
        }
          $db->acidExecute($sql, -1, -1, false);
          if ( $db->acidErrorMessage() != "" )
             ErrorMessage("Unable to CREATE table 'acid_ag': ".$db->acidErrorMessage());
          else
             ErrorMessage("Successfully created 'acid_ag'");

          $tblAcidAG_present = $db->acidTableExists("acid_ag");
      }

      if ( !$tblAcidAGAlert_present )
      {
          if ( ($db->DB_type == "mysql") || ($db->DB_type == "mysqlt") || ($db->DB_type == "maxsql") )
          {  
           $sql = '
                CREATE TABLE acid_ag_alert( ag_id               INT           UNSIGNED NOT NULL,
                                            ag_sid              INT           UNSIGNED NOT NULL,
                                            ag_cid              INT           UNSIGNED NOT NULL, 
                                            PRIMARY KEY         (ag_id, ag_sid, ag_cid),
                                            INDEX               (ag_id),
                                            INDEX               (ag_sid),
                                            INDEX               (ag_cid),
                                            INDEX               (ag_sid, ag_cid))';
          }
          else if ($db->DB_type == "postgres")
          {
           $sql = '
                CREATE TABLE acid_ag_alert( ag_id               INT8 NOT NULL,
                                            ag_sid              INT4 NOT NULL,
                                            ag_cid              INT8 NOT NULL, 

                                            PRIMARY KEY         (ag_id, ag_sid, ag_cid) );
                CREATE INDEX acid_ag_alert_id_idx ON acid_ag_alert (ag_sid, ag_cid);';
          }
          $db->acidExecute($sql, -1, -1, false);
          if ( $db->acidErrorMessage() != "" )
             ErrorMessage("Unable to CREATE table 'acid_ag_alert': ".
                          $db->acidErrorMessage());
          else
             ErrorMessage("Successfully created 'acid_ag_alert'");
 
          $tblAcidAGAlert_present = $db->acidTableExists("acid_ag_alert");
      }

      if ( !$tblAcidIPCache_present )
      {
          if ( ($db->DB_type == "mysql") || ($db->DB_type == "mysqlt") || ($db->DB_type == "maxsql") )
          {  
           $sql = '
                   CREATE TABLE acid_ip_cache( ipc_ip                  INT UNSIGNED NOT NULL,
                                               ipc_fqdn                VARCHAR(50),
                                               ipc_dns_timestamp       DATETIME,
                                               ipc_whois               TEXT,
                                               ipc_whois_timestamp     DATETIME,

                                               PRIMARY KEY         (ipc_ip),
                                               INDEX               (ipc_ip) )
                  ';
          }
          else if ($db->DB_type == "postgres")
          {
           $sql = '
                   CREATE TABLE acid_ip_cache( ipc_ip                  INT8 NOT NULL,
                                               ipc_fqdn                TEXT,
                                               ipc_dns_timestamp       DATETIME,
                                               ipc_whois               TEXT,
                                               ipc_whois_timestamp     DATETIME,

                                               PRIMARY KEY         (ipc_ip) );

                   CREATE INDEX acid_ipc_ip_idx ON acid_ip_cache (ipc_ip);
                   CREATE INDEX acid_ipc_fqdn_idx ON acid_ip_cache (ipc_fqdn);
                  ';
          }
          $db->acidExecute($sql, -1, -1, false);
          if ( $db->acidErrorMessage() != "" )
             ErrorMessage("Unable to CREATE table 'acid_ip_cache': ".
                          $db->acidErrorMessage());
          else
             ErrorMessage("Successfully created 'acid_ip_cache'");

          $tblAcidAGAlert_present = $db->acidTableExists("acid_ip_cache");
      }

      echo '<HR><P>';
  }

  if ( $submit == "Create Indexes" )
  {
     if ( $index_event_sig_present == 0)
        createDBIndex($db, "event", "signature", "signature_index");
     if ( $index_event_time_present == 0)
        createDBIndex($db, "event", "timestamp", "timestamp_index");

     $index_event_sig_present = $db->acidIndexExists($db, "event", "signature");
     $index_event_time_present = $db->acidIndexExists($db, "event", "timestamp");
  }

  echo '
  <TABLE WIDTH="100%">
     <TR><TD CLASS="plfieldhdr">Operation</TD>
         <TD CLASS="plfieldhdr">Description</TD>
         <TD CLASS="plfieldhdr">Status</TD>
     </TR>
     <TR><TD VALIGN=TOP><B>ACID tables</B></TD>
         <TD>Adds tables to extend the Snort DB to support the ACID functionality</TD>
         <TD VALIGN=TOP>';

  if ( $tblAcidAG_present && $tblAcidAGAlert_present && $tblAcidIPCache_present)
     ErrorMessage("&nbsp;DONE&nbsp;");
  else
     echo '<INPUT TYPE="submit" NAME="submit" VALUE="Create ACID AG">'; 

  echo '</TD></TR>
     <TR><TD VALIGN=TOP><B>Search Indexes</B></TD>
         <TD>(Optional) Adds indexes to the Snort DB to optimize the speed of the queries</TD>
         <TD VALIGN=TOP>';

  if ( ( $index_event_sig_present == 1 ) && ( $index_event_time_present == 1 ) ) 
     ErrorMessage("&nbsp;DONE&nbsp;");
  else  if ( ( $index_event_sig_present == 0 ) || ( $index_event_time_present == 0 ) ) 
     echo '<INPUT TYPE="submit" NAME="submit" VALUE="Create Indexes">';
  else
     ErrorMessage("Unable to assess the indexes on the underlying database");

  echo '
  </TABLE>';
  
  if ( ($tblAcidAG_present) && ($tblAcidAGAlert_present) && ($tblAcidIPCache_present) )
     echo '<P>
           The underlying Alert DB is configured for usage with ACID.
           <P>
           <B>Additional DB permissions</B><BR>
           In order to support Alert purging (the selective ability to permanently delete
           alerts from the database) and DNS/whois lookup caching, 
           the DB user "'.$alert_user.'" must have the DELETE and UPDATE privilege
           on the database "'.$alert_dbname.'@'.$alert_host.'" 
           <P>
           Goto the <A HREF="acid_main.php">Main page</A> to use the application.'; 
?>
</FORM>

</BODY>

</HTML>
