/*==================================================================
 * uif_samview.h - Header file for sample viewer routines
 *
 * Smurf Sound Font Editor
 * Copyright (C) 1999-2001 Josh Green
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA or point your web browser to http://www.gnu.org.
 *
 * To contact the author of this program:
 * Email: Josh Green <jgreen@users.sourceforge.net>
 * Smurf homepage: http://smurf.sourceforge.net
 *==================================================================*/
#ifndef __UIF_SAMVIEW__
#define __UIF_SAMVIEW__

#include <gtk/gtk.h>
#include "sfont.h"

enum
{ SAMVIEW_INACTIVE, SAMVIEW_SAMPLE, SAMVIEW_IZONE };

/* Global data */
GtkWidget *samview_win;
GtkWidget *samview_widg;

/* Prototypes */
void samview_set_mode (gint mode);
void samview_update (void);
GtkWidget *samview_create (void);
void samview_set_samplemark_pos (gint markenum, gint32 val);
gint32 samview_get_samplemark_pos (gint markenum);

#endif /* __UIF_SAMVIEW__ */
