/*==================================================================
 * smurf.c - Main routine to kick things off
 *
 * Smurf Sound Font Editor
 * Copyright (C) 1999-2001 Josh Green
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA or point your web browser to http://www.gnu.org.
 *
 * To contact the author of this program:
 * Email: Josh Green <jgreen@users.sourceforge.net>
 * Smurf homepage: http://smurf.sourceforge.net
 *==================================================================*/
#include "config.h"

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>

#define _GNU_SOURCE
#include <getopt.h>

#include <gtk/gtk.h>

#include "i18n.h"
#include "sfont.h"
#include "uiface.h"
#include "wavetable.h"
#include "sequencer.h"
#include "midi.h"
#include "util.h"
#include "sfundo.h"
#include "smurfcfg.h"
#include "uif_pref.h"
#include "drivers/wtbl_awe.h"

static gchar *smurf_usage = N_(
"Smurf Sound Font Editor v%s\n"
"Copyright 1999-2001 Josh Green <jgreen@users.sourceforge.net>\n"
"Distributed under the GNU General Public License\n"
"Usage: smurf [options]\n"
"Options:\n"
"-h, --help       Display this information\n"
"-d               Disable drivers (try if Smurf crashes on start up)\n"
"-c               Ignore preferences and use factory defaults\n");


void
display_usage (void)
{
  printf (_(smurf_usage), VERSION);
}

int
main (int argc, char *argv[])
{
  gchar c;
  gboolean driver_init = TRUE;
  gboolean pref_defaults = FALSE;
  static struct option long_options[] =
  {
    {"help", 0, NULL, 'h'},
    {0, 0, 0, 0}
  };

#if defined(ENABLE_NLS)
  gtk_set_locale ();
  bindtextdomain (PACKAGE, LOCALEDIR);
  textdomain (PACKAGE);
#endif

  log_poplevel = LogLast;	/* disable log popup */

  gtk_init (&argc, &argv);	/* initialize GTK */


  /* get command line arguments */
  while ((c = getopt_long (argc, argv, "hdc", long_options, NULL)) != -1)
    {
      switch (c)
	{
	case 'h':		/* help */
	  display_usage ();
	  exit (0);
	  break;
	case 'd':		/* disable driver auto init */
	  driver_init = FALSE;
	  break;
	case 'c':		/* use default preference options */
	  pref_defaults = TRUE;
	  break;
	default:
	  display_usage ();
	  exit (1);
	  break;
	}
    }

  if (!pref_defaults)
    {
      smurfcfg_load ();		/* load smurf.cfg file */
      smurfcfg_load_state ();	/* load smurf_state.cfg file */
    }

  sfont_init_chunks ();		/* initialize sfont memory chunks */
  sfdo_init ();			/* intialize do/undo system */

  if (driver_init)
    {
      wtbl_init_from_config ();	/* Wavetable (patch loading) driver */
      seq_init_from_config ();	/* Sequencer (virtual keyboard) driver */
      midi_init_from_config ();	/* MIDI thru driver */
    }

  /* if driver is OSS and new ALSA API, then sample caching is probably
     supported */
#if defined(SEQ_OSS)
  if (seq_driver == SEQ_OSS && awe_new_api)
    wtbl_sample_cache_support = TRUE;
#endif

  /* auto detect sample caching support, if set in preferences */
  if (smurfcfg_get_int (SMURFCFG_WAVETBL_SAM_CACHING) == 2)
    wtbl_cache_samples = wtbl_sample_cache_support;

  ui_init ();			/* initialize user interface */
  log_poplevel = LogBad;	/* re-enable log popup */
  gtk_main ();			/* kick it in the main GTK loop */

  exit (0);
}
